/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.boss.attacks;

import com.mna.entities.EntityInit;
import com.mna.tools.math.MathUtils;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class OrangeChickenProjectile
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(OrangeChickenProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity target = null;
    private int ticksInAir;

    public OrangeChickenProjectile(EntityType<OrangeChickenProjectile> type, Level world) {
        super((EntityType)EntityInit.ORANGE_CHICKEN.get(), world);
        this.m_20242_(true);
    }

    public OrangeChickenProjectile(Level world, LivingEntity target) {
        this((EntityType<OrangeChickenProjectile>)((EntityType)EntityInit.ORANGE_CHICKEN.get()), world);
        if (target != null) {
            this.f_19804_.m_135381_(TARGET_ID, (Object)target.m_19879_());
            this.target = target;
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.explode();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (!pSource.m_269533_(DamageTypeTags.f_268415_) || this.m_213877_()) {
            this.explode();
        }
        return true;
    }

    private void explode() {
        if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Level.ExplosionInteraction.TNT);
            int cookies = 5 + (int)(Math.random() * 10.0);
            for (int i = 0; i < cookies; ++i) {
                ItemEntity cookie = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_42572_));
                cookie.m_20256_(new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5));
                this.m_9236_().m_7967_((Entity)cookie);
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    private LivingEntity getTarget() {
        Entity e;
        if (this.target == null && (e = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(TARGET_ID)).intValue())) instanceof LivingEntity) {
            this.target = (LivingEntity)e;
        }
        return this.target;
    }

    public void m_8119_() {
        EntityHitResult entityraytraceresult;
        if (this.m_213877_()) {
            return;
        }
        LivingEntity target = this.getTarget();
        if (target == null) {
            if (!this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        Vec3 motion = this.m_20184_();
        float homingStrength = 5.234f;
        Vec3 myPos = this.m_20182_();
        Vec3 theirPos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        float tickTheta = 15.0f * MathUtils.clamp01(homingStrength);
        if (tickTheta > 0.0f) {
            Vec3 desiredHeading = theirPos.m_82546_(myPos).m_82541_();
            Vec3 calculatedHeading = MathUtils.rotateTowards(this.m_20184_(), desiredHeading, tickTheta).m_82541_().m_82490_(1.25);
            this.m_20256_(calculatedHeading);
        }
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double f = motion.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)motion.f_82480_, (double)f) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        ++this.ticksInAir;
        Vec3 Vector3d2 = this.m_20182_();
        Vec3 Vector3d3 = Vector3d2.m_82549_(motion);
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(Vector3d2, Vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            Vector3d3 = raytraceresult.m_82450_();
        }
        if ((entityraytraceresult = this.rayTraceEntities(Vector3d2, Vector3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
            this.m_6532_((HitResult)raytraceresult);
            this.f_19812_ = true;
        }
        motion = this.m_20184_();
        double d3 = motion.f_82479_;
        double d4 = motion.f_82480_;
        double d0 = motion.f_82481_;
        double d5 = this.m_20185_() + d3;
        double d1 = this.m_20186_() + d4;
        double d2 = this.m_20189_() + d0;
        double f1 = motion.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)d3, (double)d0) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)d4, (double)f1) * 57.2957763671875));
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
        this.m_6034_(d5, d1, d2);
        this.m_20101_();
        if (this.f_19797_ > 400) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), candidate -> !candidate.m_5833_() && candidate.m_6084_() && candidate.m_6087_() || this.ticksInAir >= 5);
    }
}

