/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.recipes.RecipeInit;
import com.mna.recipes.crush.CrushingRecipe;
import com.mna.tools.ContainerTools;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ConstructCrush
extends ConstructAITask<ConstructCrush> {
    private static final int INTERACT_TIME = 20;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.CARRY, ConstructCapability.SMITH};
    private int interactTimer = 20;
    private BlockPos interactPos = null;

    public ConstructCrush(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_()) {
            return false;
        }
        return this.interactPos != null && this.construct.asEntity().m_9236_().m_46749_(this.interactPos);
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        AbstractGolem c = this.getConstructAsEntity();
        if (this.construct.getCarryingHands().length == 0) {
            if (!this.isSuccess()) {
                this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.crush_hands_empty", new Object[0]));
            }
            this.forceFail();
            return;
        }
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.RUNNING, Vec3.m_82512_((Vec3i)this.interactPos));
        this.setMoveTarget(this.interactPos);
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else {
                Pair<ItemStack, ArrayList<ItemStack>> output = this.performCrush();
                if (!((ItemStack)output.getFirst()).m_41619_()) {
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.crush_success", new Object[0]), true);
                    this.insertOrDropItem((ItemStack)output.getFirst());
                    if (output.getSecond() != null) {
                        ((ArrayList)output.getSecond()).forEach(is -> this.insertOrDropItem((ItemStack)is));
                    }
                    this.setSuccessCode();
                } else {
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.crush_failed", new Object[0]), true);
                    this.forceFail();
                }
                this.interactTimer = 20;
                c.m_6674_(Math.random() < 0.5 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
            }
        }
    }

    private Pair<ItemStack, ArrayList<ItemStack>> performCrush() {
        AbstractGolem c = this.getConstructAsEntity();
        if (!c.m_9236_().m_46749_(this.interactPos)) {
            return new Pair((Object)ItemStack.f_41583_, null);
        }
        BlockState state = c.m_9236_().m_8055_(this.interactPos);
        if (state == null || state.m_60734_() != Blocks.f_50623_) {
            return new Pair((Object)ItemStack.f_41583_, null);
        }
        InteractionHand[] carrying = this.construct.getCarryingHands();
        for (int i = 0; i < carrying.length; ++i) {
            ItemStack stack = c.m_21120_(carrying[i]);
            if (stack.m_41619_()) continue;
            CraftingContainer inv = ContainerTools.createTemporaryContainer(stack);
            CrushingRecipe smeltRecipe = c.m_9236_().m_7465_().m_44015_((RecipeType)RecipeInit.CRUSHING_TYPE.get(), (Container)inv, c.m_9236_()).orElse(null);
            if (smeltRecipe == null) {
                return new Pair((Object)ItemStack.f_41583_, null);
            }
            c.m_9236_().m_6263_(null, c.m_20185_(), c.m_20186_(), c.m_20189_(), SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.construct.getHandWithCapability(ConstructCapability.SMITH).ifPresent(h -> c.m_6674_(h));
            ItemStack output = smeltRecipe.getResultItem().m_41777_();
            output.m_41764_(stack.m_41613_() * smeltRecipe.getOutputQuantity());
            c.m_21008_(carrying[i], ItemStack.f_41583_);
            return new Pair((Object)output, smeltRecipe.rollByproducts(c.m_9236_().m_213780_(), stack.m_41613_()));
        }
        return new Pair((Object)ItemStack.f_41583_, null);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.interactTimer = 20;
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.CRUSH);
    }

    @Override
    public ConstructCrush duplicate() {
        return new ConstructCrush(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public ConstructCrush copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructCrush) {
            this.interactPos = ((ConstructCrush)other).interactPos;
        }
        return this;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        return nbt;
    }

    @Override
    public void inflateParameters() {
        this.getParameter("crush.point").ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                this.interactPos = ((ConstructTaskPointParameter)param).getPosition();
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskPointParameter("crush.point"));
        return parameters;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.interactPos != null;
    }
}

