/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.ConstructBlockAreaTask;
import com.mna.api.tools.MATags;
import com.mna.api.tools.RLoc;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import com.mna.tools.BlockUtils;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class ConstructHarvest
extends ConstructBlockAreaTask<ConstructHarvest> {
    public static final ResourceLocation construct_harvestable = RLoc.create("blocks/construct_harvestables");
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.HARVEST};

    public ConstructHarvest(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.currentTarget == null) {
            this.findBlockTarget();
            return;
        }
        if (this.moveToCurrentTarget()) {
            this.harvest();
        }
    }

    private void harvest() {
        AbstractGolem c = this.getConstructAsEntity();
        BlockState state = c.m_9236_().m_8055_(this.currentTarget);
        this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.harvesting", this.translate(state), this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_()));
        boolean success = false;
        if (this.construct.getIntelligence() >= 16) {
            FakePlayer player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.construct.asEntity().m_9236_()));
            player.m_146884_(this.construct.asEntity().m_20182_());
            success = this.harvestAndReplant(this.construct.asEntity().m_9236_(), this.currentTarget, state, (Player)player);
        } else {
            success = BlockUtils.destroyBlock((LivingEntity)(this.construct.getOwner() != null ? this.construct.getOwner() : c), c.m_9236_(), this.currentTarget, true, (Tier)Tiers.NETHERITE);
        }
        this.knownTargets.remove((Object)this.currentTarget);
        this.lastLocation = 0;
        this.currentTarget = null;
        this.exitCode = success ? 0 : 1;
    }

    private boolean harvestAndReplant(Level world, BlockPos pos, BlockState inWorld, Player player) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        AbstractGolem c = this.getConstructAsEntity();
        Optional<IntegerProperty> ageProp = inWorld.m_61147_().stream().filter(p -> p.m_61708_() == "age").map(p -> (IntegerProperty)p).findFirst();
        if (!ageProp.isPresent() || MATags.isBlockIn(inWorld.m_60734_(), MATags.Blocks.CONSTRUCT_HARVESTABLES_NO_AGE)) {
            return BlockUtils.destroyBlock((LivingEntity)(this.construct.getOwner() != null ? this.construct.getOwner() : c), c.m_9236_(), this.currentTarget, true, (Tier)Tiers.NETHERITE);
        }
        if (inWorld.m_61143_((Property)ageProp.get()) != ageProp.get().m_6908_().stream().max(Integer::compare).get()) {
            return false;
        }
        Item blockItem = inWorld.m_60734_().m_5456_();
        Block.m_49874_((BlockState)inWorld, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)ItemStack.f_41583_).forEach(stack -> {
            if (stack.m_41720_() == blockItem) {
                stack.m_41774_(1);
            }
            if (!stack.m_41619_()) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
            }
        });
        inWorld.m_222967_((ServerLevel)world, pos, ItemStack.f_41583_, true);
        if (!world.f_46443_) {
            BlockState newBlock = (BlockState)inWorld.m_61124_((Property)ageProp.get(), (Comparable)Integer.valueOf(0));
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)newBlock));
            world.m_46597_(pos, newBlock);
        }
        return true;
    }

    @Override
    public boolean isValidBlock(BlockState state, BlockPos pos) {
        return ConstructHarvest.validBlock(state);
    }

    public static boolean validBlock(BlockState state) {
        boolean valid;
        if (MATags.isBlockIn(state.m_60734_(), MATags.Blocks.CONSTRUCT_HARVESTABLE_EXCLUDE) || state.m_60795_()) {
            return false;
        }
        boolean no_age = MATags.isBlockIn(state.m_60734_(), RLoc.create("construct_harvestables_no_age"));
        boolean bl = valid = no_age || MATags.isBlockIn(state.m_60734_(), RLoc.create("construct_harvestables"));
        if (state.m_60734_() instanceof CropBlock) {
            valid &= ((CropBlock)state.m_60734_()).m_52307_(state);
        } else {
            Optional<IntegerProperty> ageProp = state.m_61147_().stream().filter(p -> p.m_61708_() == "age").map(p -> (IntegerProperty)p).findFirst();
            if (ageProp.isPresent() && !no_age) {
                int maximum = (Integer)ageProp.get().m_6908_().stream().max(Integer::compare).get();
                int value = (Integer)state.m_61143_((Property)ageProp.get());
                valid &= value == maximum;
            }
        }
        return valid;
    }

    @Override
    protected int getInteractTimer() {
        return this.getInteractTime(ConstructCapability.HARVEST);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.interactTimer = this.getInteractTime(ConstructCapability.HARVEST);
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.HARVEST);
    }

    @Override
    public ConstructHarvest duplicate() {
        return new ConstructHarvest(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructHarvest copyFrom(ConstructAITask<?> other) {
        super.copyFrom((ConstructAITask)other);
        return this;
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        return nbt;
    }

    @Override
    protected String getAreaIdentifier() {
        return "harvest.area";
    }
}

