/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.blocks.DirectionalPoint;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.IConstructDiagnostics;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskPointParameter;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ConstructMove
extends ConstructAITask<ConstructMove> {
    protected BlockPos blockPos;

    public ConstructMove(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        return super.m_8036_();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        this.construct.getDiagnostics().pushTaskUpdate(this.getId(), this.guiIcon, IConstructDiagnostics.Status.RUNNING, Vec3.m_82512_((Vec3i)this.blockPos));
        this.setMoveTarget(this.blockPos);
        if (this.doMove(1.05f)) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.move_success", new Object[0]));
            this.exitCode = 0;
            return;
        }
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.MOVE);
    }

    @Override
    public ConstructMove duplicate() {
        return new ConstructMove(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructMove copyFrom(ConstructAITask<?> other) {
        if (other instanceof ConstructMove) {
            this.blockPos = ((ConstructMove)other).blockPos;
        }
        return this;
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        if (this.blockPos != null) {
            nbt.m_128365_("blockPos", (Tag)NbtUtils.m_129224_((BlockPos)this.blockPos));
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
        if (nbt.m_128441_("blockPos")) {
            this.blockPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("blockPos"));
        }
    }

    @Override
    public void inflateParameters() {
        this.getParameter("move.point").ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                this.blockPos = ((ConstructTaskPointParameter)param).getPosition();
            }
        });
    }

    @Override
    protected List<ConstructAITaskParameter> instantiateParameters() {
        List<ConstructAITaskParameter> parameters = super.instantiateParameters();
        parameters.add(new ConstructTaskPointParameter("move.point"));
        return parameters;
    }

    public void setDesiredLocation(BlockPos pos) {
        this.blockPos = pos;
        this.getParameter("move.point").ifPresent(param -> {
            if (param instanceof ConstructTaskPointParameter) {
                ConstructTaskPointParameter point = (ConstructTaskPointParameter)param;
                point.setPoint(new DirectionalPoint(pos, Direction.UP, "", null));
            }
        });
    }

    @Override
    public boolean isFullyConfigured() {
        return this.blockPos != null;
    }
}

