/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.ai;

import com.mna.Registries;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.IConstruct;
import com.mna.api.entities.construct.ai.ConstructAITask;
import com.mna.api.entities.construct.ai.ConstructBlockAreaTask;
import com.mna.api.tools.MATags;
import com.mna.entities.constructs.ai.base.ConstructTasks;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class ConstructPlant
extends ConstructBlockAreaTask<ConstructPlant> {
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.PLANT, ConstructCapability.CARRY};
    ResourceLocation plantBlockTag;

    public ConstructPlant(IConstruct<?> construct, ResourceLocation guiIcon) {
        super(construct, guiIcon);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        AbstractGolem c = this.getConstructAsEntity();
        this.plantBlockTag = this.getHeldItemPlantBlockTag();
        if (this.plantBlockTag == null) {
            this.exitCode = 1;
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.plant_empty_hands", new Object[0]), false);
            return;
        }
        if (this.currentTarget == null) {
            this.findBlockTarget();
            return;
        }
        if (!MATags.isBlockIn(c.m_9236_().m_8055_(this.currentTarget).m_60734_(), this.plantBlockTag)) {
            this.currentTarget = null;
            this.findBlockTarget();
            return;
        }
        if (this.moveToCurrentTarget()) {
            if (c.m_9236_().m_46859_(this.currentTarget.m_7494_())) {
                InteractionHand[] carrying;
                for (InteractionHand hand : carrying = this.getHeldItem(this.plantBlockTag)) {
                    ItemStack stack = c.m_21120_(hand);
                    if (!(stack.m_41720_() instanceof BlockItem)) {
                        this.exitCode = 1;
                        this.currentTarget = null;
                        return;
                    }
                    BlockState plant = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
                    if (plant == null) continue;
                    String translatedStack = this.translate(stack);
                    stack.m_41774_(1);
                    c.m_9236_().m_46597_(this.currentTarget.m_7494_(), plant);
                    this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.planting", translatedStack, this.currentTarget.m_123341_(), this.currentTarget.m_123342_(), this.currentTarget.m_123343_()));
                    this.exitCode = 0;
                    this.currentTarget = null;
                    return;
                }
            } else {
                this.removeBlockTarget(this.currentTarget);
                this.currentTarget = null;
            }
        }
    }

    private ResourceLocation getHeldItemPlantBlockTag() {
        if (this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.SOUL_SAND_PLANTABLE)).length != 0) {
            return MATags.Blocks.CONSTRUCT_PLANTABLE_SOUL_SAND;
        }
        if (this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.SAND_PLANTABLE)).length != 0) {
            return MATags.Blocks.CONSTRUCT_PLANTABLE_SAND;
        }
        if (this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.GRASS_PLANTABLE)).length != 0) {
            return MATags.Blocks.CONSTRUCT_PLANTABLE_GRASS;
        }
        if (this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.FARMLAND_PLANTABLE)).length != 0) {
            return MATags.Blocks.CONSTRUCT_PLANTABLE_FARMLAND;
        }
        return null;
    }

    private InteractionHand[] getHeldItem(ResourceLocation targetTag) {
        if (targetTag.equals((Object)MATags.Blocks.CONSTRUCT_PLANTABLE_FARMLAND)) {
            return this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.FARMLAND_PLANTABLE));
        }
        if (targetTag.equals((Object)MATags.Blocks.CONSTRUCT_PLANTABLE_GRASS)) {
            return this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.GRASS_PLANTABLE));
        }
        if (targetTag.equals((Object)MATags.Blocks.CONSTRUCT_PLANTABLE_SAND)) {
            return this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.SAND_PLANTABLE));
        }
        if (targetTag.equals((Object)MATags.Blocks.CONSTRUCT_PLANTABLE_SOUL_SAND)) {
            return this.construct.getCarryingHands(i -> MATags.isItemEqual(i, MATags.Items.Constructs.SOUL_SAND_PLANTABLE));
        }
        return new InteractionHand[0];
    }

    @Override
    protected ConstructCapability getSwingArmCap() {
        return ConstructCapability.PLANT;
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_()) {
            this.forceFail();
            return false;
        }
        if (this.getHeldItemPlantBlockTag() == null) {
            this.pushDiagnosticMessage(this.translate("mna.constructs.feedback.plant_empty_hands", new Object[0]), false);
            this.exitCode = -1;
            return false;
        }
        return true;
    }

    @Override
    public boolean m_8045_() {
        return super.m_8045_() && this.m_8036_();
    }

    @Override
    protected int getInteractTimer() {
        return this.getInteractTime(ConstructCapability.PLANT);
    }

    @Override
    protected boolean isValidBlock(BlockState state, BlockPos pos) {
        if (!this.construct.asEntity().m_9236_().m_46859_(pos.m_7494_())) {
            return false;
        }
        if (this.plantBlockTag != null) {
            ResourceLocation blockTag = this.getHeldItemPlantBlockTag();
            return MATags.isBlockIn(state.m_60734_(), blockTag);
        }
        return MATags.isBlockIn(state.m_60734_(), MATags.Blocks.CONSTRUCT_PLANTABLE_FARMLAND) || MATags.isBlockIn(state.m_60734_(), MATags.Blocks.CONSTRUCT_PLANTABLE_SAND) || MATags.isBlockIn(state.m_60734_(), MATags.Blocks.CONSTRUCT_PLANTABLE_GRASS) || MATags.isBlockIn(state.m_60734_(), MATags.Blocks.CONSTRUCT_PLANTABLE_SOUL_SAND);
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.interactTimer = this.getInteractTime(ConstructCapability.CARRY);
    }

    @Override
    public ResourceLocation getType() {
        return Registries.ConstructTasks.get().getKey((Object)ConstructTasks.PLANT);
    }

    @Override
    public ConstructPlant duplicate() {
        return new ConstructPlant(this.construct, this.guiIcon).copyFrom((ConstructAITask)this);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public ConstructPlant copyFrom(ConstructAITask<?> other) {
        super.copyFrom((ConstructAITask)other);
        return this;
    }

    @Override
    public void readNBT(CompoundTag nbt) {
    }

    @Override
    public CompoundTag writeInternal(CompoundTag nbt) {
        return nbt;
    }

    @Override
    protected String getAreaIdentifier() {
        return "plant.area";
    }
}

