/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.constructs.movement;

import com.google.common.collect.ImmutableSet;
import com.mna.api.tools.MATags;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConstructNodeEvaluator
extends NodeEvaluator {
    public static final double SPACE_BETWEEN_WALL_POSTS = 0.5;
    protected float oldWaterCost;
    private float oldWalkableCost;
    private float oldWaterBorderCost;
    private boolean amphibious = true;
    private boolean flying = false;
    private boolean isInWater = false;
    private final Long2ObjectMap<BlockPathTypes> pathTypeByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AABB> collisionCache = new Object2BooleanOpenHashMap();

    public void m_6028_(PathNavigationRegion region, Mob mob) {
        super.m_6028_(region, mob);
        this.isInWater = mob.m_20069_();
        if (this.flying && !this.isInWater) {
            this.prepare_flying(mob);
        } else {
            this.prepare_ground(mob);
        }
    }

    public void m_6802_() {
        this.f_77313_.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        this.f_77313_.m_21441_(BlockPathTypes.WALKABLE, this.oldWalkableCost);
        this.f_77313_.m_21441_(BlockPathTypes.WATER_BORDER, this.oldWaterBorderCost);
        this.pathTypeByPosCache.clear();
        this.collisionCache.clear();
        super.m_6802_();
    }

    @Nullable
    protected Node m_5676_(int x, int y, int z) {
        if (this.flying && !this.isInWater) {
            Node node = null;
            BlockPathTypes pathType = this.getCachedBlockPathType(x, y, z);
            float f = this.f_77313_.m_21439_(pathType);
            if (f >= 0.0f) {
                node = super.m_5676_(x, y, z);
                node.f_77282_ = pathType;
                node.f_77281_ = Math.max(node.f_77281_, f);
                if (pathType == BlockPathTypes.WALKABLE) {
                    node.f_77281_ += 1.0f;
                }
            }
            return node;
        }
        return super.m_5676_(x, y, z);
    }

    public Node m_7171_() {
        if (this.flying && !this.isInWater) {
            return this.getStart_flying();
        }
        return this.getStart_ground();
    }

    public Target m_7568_(double x, double y, double z) {
        if (this.flying && !this.isInWater) {
            return new Target(super.m_5676_(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
        }
        return this.m_230615_(this.m_5676_(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z)));
    }

    public int m_6065_(Node[] p_77640_, Node current) {
        if (this.flying && !this.isInWater) {
            return this.getNeighbors_flying(p_77640_, current);
        }
        return this.getNeighbors_ground(p_77640_, current);
    }

    public BlockPathTypes m_7209_(BlockGetter blockGetter, int x, int y, int z, Mob mob) {
        if (this.flying && !this.isInWater) {
            return this.getBlockPathType_flying(blockGetter, x, y, z, mob);
        }
        return this.getBlockPathType_ground(blockGetter, x, y, z, mob);
    }

    public BlockPathTypes m_8086_(BlockGetter blockGetter, int x, int y, int z) {
        return ConstructNodeEvaluator.getBlockPathTypeStatic(blockGetter, new BlockPos.MutableBlockPos(x, y, z), this.f_77313_);
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public void setAmphibious(boolean amphibious) {
        this.amphibious = amphibious;
    }

    protected boolean isNeighborValid(@Nullable Node neighbor, Node current) {
        return neighbor != null && !neighbor.f_77279_ && (neighbor.f_77281_ >= 0.0f || current.f_77281_ < 0.0f);
    }

    private boolean hasMalus(@Nullable Node node) {
        return node != null && node.f_77281_ >= 0.0f;
    }

    private boolean isOpen(@Nullable Node node) {
        return node != null && !node.f_77279_;
    }

    protected boolean isDiagonalValid(Node pRoot, @Nullable Node pXNode, @Nullable Node pZNode, @Nullable Node pDiagonal) {
        if (pDiagonal != null && pZNode != null && pXNode != null) {
            if (pDiagonal.f_77279_) {
                return false;
            }
            if (pZNode.f_77272_ <= pRoot.f_77272_ && pXNode.f_77272_ <= pRoot.f_77272_) {
                if (pXNode.f_77282_ != BlockPathTypes.WALKABLE_DOOR && pZNode.f_77282_ != BlockPathTypes.WALKABLE_DOOR && pDiagonal.f_77282_ != BlockPathTypes.WALKABLE_DOOR) {
                    boolean flag = pZNode.f_77282_ == BlockPathTypes.FENCE && pXNode.f_77282_ == BlockPathTypes.FENCE && (double)this.f_77313_.m_20205_() < 0.5;
                    return pDiagonal.f_77281_ >= 0.0f && (pZNode.f_77272_ < pRoot.f_77272_ || pZNode.f_77281_ >= 0.0f || flag) && (pXNode.f_77272_ < pRoot.f_77272_ || pXNode.f_77281_ >= 0.0f || flag);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean canReachWithoutCollision(Node target) {
        AABB aabb = this.f_77313_.m_20191_();
        Vec3 vec3 = new Vec3((double)target.f_77271_ - this.f_77313_.m_20185_() + aabb.m_82362_() / 2.0, (double)target.f_77272_ - this.f_77313_.m_20186_() + aabb.m_82376_() / 2.0, (double)target.f_77273_ - this.f_77313_.m_20189_() + aabb.m_82385_() / 2.0);
        int i = Mth.m_14165_((double)(vec3.m_82553_() / aabb.m_82309_()));
        vec3 = vec3.m_82490_((double)(1.0f / (float)i));
        for (int j = 1; j <= i; ++j) {
            if (!this.hasCollisions(aabb = aabb.m_82383_(vec3))) continue;
            return false;
        }
        return true;
    }

    protected double getFloorLevel(BlockPos pos) {
        return (this.m_77361_() || this.isAmphibious()) && this.f_77312_.m_6425_(pos).m_205070_(FluidTags.f_13131_) ? (double)pos.m_123342_() + 0.5 : ConstructNodeEvaluator.getFloorLevel((BlockGetter)this.f_77312_, pos);
    }

    protected boolean isAmphibious() {
        return this.amphibious;
    }

    @Nullable
    protected Node findAcceptedNode(int pX, int pY, int pZ, int pVerticalDeltaLimit, double pNodeFloorLevel, Direction pDirection, BlockPathTypes pPathType) {
        Node node = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double d0 = this.getFloorLevel((BlockPos)blockpos$mutableblockpos.m_122178_(pX, pY, pZ));
        if (d0 - pNodeFloorLevel > this.getMobJumpHeight()) {
            return null;
        }
        BlockPathTypes blockpathtypes = this.getCachedBlockType(this.f_77313_, pX, pY, pZ);
        float f = this.f_77313_.m_21439_(blockpathtypes);
        double d1 = (double)this.f_77313_.m_20205_() / 2.0;
        if (f >= 0.0f) {
            node = this.getNodeAndUpdateCostToMax(pX, pY, pZ, blockpathtypes, f);
        }
        if (ConstructNodeEvaluator.doesBlockHavePartialCollision(pPathType) && node != null && node.f_77281_ >= 0.0f && !this.canReachWithoutCollision(node)) {
            node = null;
        }
        if (!(blockpathtypes == BlockPathTypes.WALKABLE || this.isAmphibious() && blockpathtypes == BlockPathTypes.WATER)) {
            double d3;
            double d2;
            AABB aabb;
            if ((node == null || node.f_77281_ < 0.0f) && pVerticalDeltaLimit > 0 && (blockpathtypes != BlockPathTypes.FENCE || this.m_255100_()) && blockpathtypes != BlockPathTypes.UNPASSABLE_RAIL && blockpathtypes != BlockPathTypes.TRAPDOOR && blockpathtypes != BlockPathTypes.POWDER_SNOW && (node = this.findAcceptedNode(pX, pY + 1, pZ, pVerticalDeltaLimit - 1, pNodeFloorLevel, pDirection, pPathType)) != null && (node.f_77282_ == BlockPathTypes.OPEN || node.f_77282_ == BlockPathTypes.WALKABLE) && this.f_77313_.m_20205_() < 1.0f && this.hasCollisions(aabb = new AABB((d2 = (double)(pX - pDirection.m_122429_()) + 0.5) - d1, this.getFloorLevel((BlockPos)blockpos$mutableblockpos.m_122169_(d2, (double)(pY + 1), d3 = (double)(pZ - pDirection.m_122431_()) + 0.5)) + 0.001, d3 - d1, d2 + d1, (double)this.f_77313_.m_20206_() + this.getFloorLevel((BlockPos)blockpos$mutableblockpos.m_122169_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_)) - 0.002, d3 + d1))) {
                node = null;
            }
            if (!this.isAmphibious() && blockpathtypes == BlockPathTypes.WATER && !this.m_77361_()) {
                if (this.getCachedBlockType(this.f_77313_, pX, pY - 1, pZ) != BlockPathTypes.WATER) {
                    return node;
                }
                while (pY > this.f_77313_.m_9236_().m_141937_()) {
                    if ((blockpathtypes = this.getCachedBlockType(this.f_77313_, pX, --pY, pZ)) != BlockPathTypes.WATER) {
                        return node;
                    }
                    node = this.getNodeAndUpdateCostToMax(pX, pY, pZ, blockpathtypes, this.f_77313_.m_21439_(blockpathtypes));
                }
            }
            if (blockpathtypes == BlockPathTypes.OPEN) {
                boolean j = false;
                int i = pY;
                while (blockpathtypes == BlockPathTypes.OPEN) {
                    if (--pY < this.f_77313_.m_9236_().m_141937_()) {
                        return this.getBlockedNode(pX, i, pZ);
                    }
                    blockpathtypes = this.getCachedBlockType(this.f_77313_, pX, pY, pZ);
                    f = this.f_77313_.m_21439_(blockpathtypes);
                    if (blockpathtypes != BlockPathTypes.OPEN && f >= 0.0f) {
                        node = this.getNodeAndUpdateCostToMax(pX, pY, pZ, blockpathtypes, f);
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    return this.getBlockedNode(pX, pY, pZ);
                }
            }
            if (ConstructNodeEvaluator.doesBlockHavePartialCollision(blockpathtypes) && node == null) {
                node = this.m_5676_(pX, pY, pZ);
                node.f_77279_ = true;
                node.f_77282_ = blockpathtypes;
                node.f_77281_ = blockpathtypes.m_77124_();
            }
            return node;
        }
        return node;
    }

    private double getMobJumpHeight() {
        return Math.max(1.125, (double)this.f_77313_.getStepHeight());
    }

    private Node getNodeAndUpdateCostToMax(int pX, int pY, int pZ, BlockPathTypes pType, float pCostMalus) {
        Node node = this.m_5676_(pX, pY, pZ);
        node.f_77282_ = pType;
        node.f_77281_ = Math.max(node.f_77281_, pCostMalus);
        return node;
    }

    private Node getBlockedNode(int pX, int pY, int pZ) {
        Node node = this.m_5676_(pX, pY, pZ);
        node.f_77282_ = BlockPathTypes.BLOCKED;
        node.f_77281_ = -1.0f;
        return node;
    }

    private boolean hasCollisions(AABB pBoundingBox) {
        return this.collisionCache.computeIfAbsent((Object)pBoundingBox, p_192973_ -> !this.f_77312_.m_45756_((Entity)this.f_77313_, pBoundingBox));
    }

    public BlockPathTypes getBlockPathTypes(BlockGetter pLevel, int pXOffset, int pYOffset, int pZOffset, EnumSet<BlockPathTypes> pOutput, BlockPathTypes pFallbackPathType, BlockPos pPos) {
        for (int i = 0; i < this.f_77315_; ++i) {
            for (int j = 0; j < this.f_77316_; ++j) {
                for (int k = 0; k < this.f_77317_; ++k) {
                    int l = i + pXOffset;
                    int i1 = j + pYOffset;
                    int j1 = k + pZOffset;
                    BlockPathTypes blockpathtypes = this.m_8086_(pLevel, l, i1, j1);
                    blockpathtypes = this.evaluateBlockPathType(pLevel, pPos, blockpathtypes);
                    if (i == 0 && j == 0 && k == 0) {
                        pFallbackPathType = blockpathtypes;
                    }
                    pOutput.add(blockpathtypes);
                }
            }
        }
        return pFallbackPathType;
    }

    protected BlockPathTypes evaluateBlockPathType(BlockGetter pLevel, BlockPos pPos, BlockPathTypes pPathTypes) {
        boolean flag = this.m_77357_();
        if (pPathTypes == BlockPathTypes.DOOR_WOOD_CLOSED && this.m_77360_() && flag) {
            pPathTypes = BlockPathTypes.WALKABLE_DOOR;
        }
        if (pPathTypes == BlockPathTypes.DOOR_OPEN && !flag) {
            pPathTypes = BlockPathTypes.BLOCKED;
        }
        if (pPathTypes == BlockPathTypes.RAIL && !(pLevel.m_8055_(pPos).m_60734_() instanceof BaseRailBlock) && !(pLevel.m_8055_(pPos.m_7495_()).m_60734_() instanceof BaseRailBlock)) {
            pPathTypes = BlockPathTypes.UNPASSABLE_RAIL;
        }
        return pPathTypes;
    }

    private BlockPathTypes getBlockPathType(Mob mob, BlockPos position) {
        return this.getCachedBlockType(mob, position.m_123341_(), position.m_123342_(), position.m_123343_());
    }

    private BlockPathTypes getCachedBlockPathType(int pX, int pY, int pZ) {
        return (BlockPathTypes)this.pathTypeByPosCache.computeIfAbsent(BlockPos.m_121882_((int)pX, (int)pY, (int)pZ), p_265010_ -> this.m_7209_((BlockGetter)this.f_77312_, pX, pY, pZ, this.f_77313_));
    }

    protected BlockPathTypes getCachedBlockType(Mob pEntity, int pX, int pY, int pZ) {
        return (BlockPathTypes)this.pathTypeByPosCache.computeIfAbsent(BlockPos.m_121882_((int)pX, (int)pY, (int)pZ), p_265015_ -> this.m_7209_((BlockGetter)this.f_77312_, pX, pY, pZ, pEntity));
    }

    protected void prepare_ground(Mob mob) {
        this.oldWalkableCost = mob.m_21439_(BlockPathTypes.WALKABLE);
        mob.m_21441_(BlockPathTypes.WALKABLE, 0.0f);
        this.oldWaterBorderCost = mob.m_21439_(BlockPathTypes.WATER_BORDER);
        mob.m_21441_(BlockPathTypes.WATER_BORDER, 4.0f);
        this.oldWaterCost = mob.m_21439_(BlockPathTypes.WATER);
        mob.m_21441_(BlockPathTypes.WATER, 6.0f);
    }

    protected void prepare_flying(Mob mob) {
        this.pathTypeByPosCache.clear();
        this.oldWaterBorderCost = mob.m_21439_(BlockPathTypes.WATER_BORDER);
        mob.m_21441_(BlockPathTypes.WATER_BORDER, 4.0f);
        this.oldWaterCost = mob.m_21439_(BlockPathTypes.WATER);
        mob.m_21441_(BlockPathTypes.WATER, 6.0f);
    }

    protected Node getStart_ground() {
        int i;
        BlockPos.MutableBlockPos blockpos$mutableblockpos;
        block11: {
            blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            i = this.f_77313_.m_146904_();
            BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)i, this.f_77313_.m_20189_()));
            if (!this.f_77313_.m_203441_(blockstate.m_60819_())) {
                if (this.m_77361_() && this.f_77313_.m_20069_()) {
                    while (true) {
                        if (!blockstate.m_60713_(Blocks.f_49990_) && blockstate.m_60819_() != Fluids.f_76193_.m_76068_(false)) {
                            --i;
                            break block11;
                        }
                        blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_()));
                    }
                }
                if (this.f_77313_.m_20096_()) {
                    i = Mth.m_14107_((double)(this.f_77313_.m_20186_() + 0.5));
                } else {
                    BlockPos blockpos = this.f_77313_.m_20183_();
                    while ((this.f_77312_.m_8055_(blockpos).m_60795_() || this.f_77312_.m_8055_(blockpos).m_60647_((BlockGetter)this.f_77312_, blockpos, PathComputationType.LAND)) && blockpos.m_123342_() > this.f_77313_.m_9236_().m_141937_()) {
                        blockpos = blockpos.m_7495_();
                    }
                    i = blockpos.m_7494_().m_123342_();
                }
            } else {
                while (this.f_77313_.m_203441_(blockstate.m_60819_())) {
                    blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_()));
                }
                --i;
            }
        }
        BlockPos blockpos1 = this.f_77313_.m_20183_();
        if (!this.canStartAt((BlockPos)blockpos$mutableblockpos.m_122178_(blockpos1.m_123341_(), i, blockpos1.m_123343_()))) {
            AABB aabb = this.f_77313_.m_20191_();
            if (this.canStartAt((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82288_, (double)i, aabb.f_82290_)) || this.canStartAt((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82288_, (double)i, aabb.f_82293_)) || this.canStartAt((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82291_, (double)i, aabb.f_82290_)) || this.canStartAt((BlockPos)blockpos$mutableblockpos.m_122169_(aabb.f_82291_, (double)i, aabb.f_82293_))) {
                return this.getStartNode((BlockPos)blockpos$mutableblockpos);
            }
        }
        return this.getStartNode(new BlockPos(blockpos1.m_123341_(), i, blockpos1.m_123343_()));
    }

    protected Node getStartNode(BlockPos pPos) {
        Node node = this.m_77349_(pPos);
        node.f_77282_ = this.getBlockPathType(this.f_77313_, node.m_77288_());
        node.f_77281_ = this.f_77313_.m_21439_(node.f_77282_);
        return node;
    }

    protected boolean canStartAt(BlockPos pPos) {
        BlockPathTypes blockpathtypes = this.getBlockPathType(this.f_77313_, pPos);
        return blockpathtypes != BlockPathTypes.OPEN && this.f_77313_.m_21439_(blockpathtypes) >= 0.0f;
    }

    protected Node getStart_flying() {
        BlockPos blockpos1;
        BlockPathTypes blockpathtypes1;
        int i;
        if (this.m_77361_() && this.f_77313_.m_20069_()) {
            i = this.f_77313_.m_146904_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(this.f_77313_.m_20185_(), (double)i, this.f_77313_.m_20189_());
            BlockState blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos);
            while (blockstate.m_60713_(Blocks.f_49990_)) {
                blockpos$mutableblockpos.m_122169_(this.f_77313_.m_20185_(), (double)(++i), this.f_77313_.m_20189_());
                blockstate = this.f_77312_.m_8055_((BlockPos)blockpos$mutableblockpos);
            }
        } else {
            i = Mth.m_14107_((double)(this.f_77313_.m_20186_() + 0.5));
        }
        if (this.f_77313_.m_21439_(blockpathtypes1 = this.getCachedBlockPathType((blockpos1 = this.f_77313_.m_20183_()).m_123341_(), i, blockpos1.m_123343_())) < 0.0f) {
            for (BlockPos blockpos : ImmutableSet.of((Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82288_, (double)i, (double)this.f_77313_.m_20191_().f_82290_), (Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82288_, (double)i, (double)this.f_77313_.m_20191_().f_82293_), (Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82291_, (double)i, (double)this.f_77313_.m_20191_().f_82290_), (Object)BlockPos.m_274561_((double)this.f_77313_.m_20191_().f_82291_, (double)i, (double)this.f_77313_.m_20191_().f_82293_))) {
                BlockPathTypes blockpathtypes = this.getCachedBlockPathType(blockpos1.m_123341_(), i, blockpos1.m_123343_());
                if (!(this.f_77313_.m_21439_(blockpathtypes) >= 0.0f)) continue;
                return super.m_5676_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            }
        }
        return super.m_5676_(blockpos1.m_123341_(), i, blockpos1.m_123343_());
    }

    protected int getNeighbors_ground(Node[] neighbors, Node current) {
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node node3;
        Node node2;
        Node node1;
        double d0;
        Node node;
        int i = 0;
        int j = 0;
        BlockPathTypes blockpathtypes = this.getCachedBlockType(this.f_77313_, current.f_77271_, current.f_77272_ + 1, current.f_77273_);
        BlockPathTypes blockpathtypes1 = this.getCachedBlockType(this.f_77313_, current.f_77271_, current.f_77272_, current.f_77273_);
        if (this.f_77313_.m_21439_(blockpathtypes) >= 0.0f && blockpathtypes1 != BlockPathTypes.STICKY_HONEY) {
            j = Mth.m_14143_((float)Math.max(1.0f, this.f_77313_.getStepHeight()));
        }
        if (this.isNeighborValid(node = this.findAcceptedNode(current.f_77271_, current.f_77272_, current.f_77273_ + 1, j, d0 = this.getFloorLevel(new BlockPos(current.f_77271_, current.f_77272_, current.f_77273_)), Direction.SOUTH, blockpathtypes1), current)) {
            neighbors[i++] = node;
        }
        if (this.isNeighborValid(node1 = this.findAcceptedNode(current.f_77271_ - 1, current.f_77272_, current.f_77273_, j, d0, Direction.WEST, blockpathtypes1), current)) {
            neighbors[i++] = node1;
        }
        if (this.isNeighborValid(node2 = this.findAcceptedNode(current.f_77271_ + 1, current.f_77272_, current.f_77273_, j, d0, Direction.EAST, blockpathtypes1), current)) {
            neighbors[i++] = node2;
        }
        if (this.isNeighborValid(node3 = this.findAcceptedNode(current.f_77271_, current.f_77272_, current.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1), current)) {
            neighbors[i++] = node3;
        }
        if (this.isDiagonalValid(current, node1, node3, node4 = this.findAcceptedNode(current.f_77271_ - 1, current.f_77272_, current.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1))) {
            neighbors[i++] = node4;
        }
        if (this.isDiagonalValid(current, node2, node3, node5 = this.findAcceptedNode(current.f_77271_ + 1, current.f_77272_, current.f_77273_ - 1, j, d0, Direction.NORTH, blockpathtypes1))) {
            neighbors[i++] = node5;
        }
        if (this.isDiagonalValid(current, node1, node, node6 = this.findAcceptedNode(current.f_77271_ - 1, current.f_77272_, current.f_77273_ + 1, j, d0, Direction.SOUTH, blockpathtypes1))) {
            neighbors[i++] = node6;
        }
        if (this.isDiagonalValid(current, node2, node, node7 = this.findAcceptedNode(current.f_77271_ + 1, current.f_77272_, current.f_77273_ + 1, j, d0, Direction.SOUTH, blockpathtypes1))) {
            neighbors[i++] = node7;
        }
        return i;
    }

    protected int getNeighbors_flying(Node[] neighbors, Node current) {
        Node xNegYNegZPos;
        Node xNegYNegZNeg;
        Node xPosYNegZPos;
        Node xPosYNegZNeg;
        Node xNegYPosZPos;
        Node xNegYPosZNeg;
        Node xPosYPosZPos;
        Node xposYPosZNeg;
        Node xNegZPos;
        Node xNegZNeg;
        Node xPosZPos;
        Node xPosZNeg;
        Node yNegZNeg;
        Node xPosYNeg;
        Node xNegYNeg;
        Node yNegZPos;
        Node yPosZNeg;
        Node xPosYPos;
        Node xNegYPos;
        Node yPoszPos;
        Node yNeg;
        Node yPos;
        Node zNeg;
        Node xPos;
        Node xNeg;
        int numOpenNeighbors = 0;
        Node zPos = this.m_5676_(current.f_77271_, current.f_77272_, current.f_77273_ + 1);
        if (this.isOpen(zPos)) {
            neighbors[numOpenNeighbors++] = zPos;
        }
        if (this.isOpen(xNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = xNeg;
        }
        if (this.isOpen(xPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = xPos;
        }
        if (this.isOpen(zNeg = this.m_5676_(current.f_77271_, current.f_77272_, current.f_77273_ - 1))) {
            neighbors[numOpenNeighbors++] = zNeg;
        }
        if (this.isOpen(yPos = this.m_5676_(current.f_77271_, current.f_77272_ + 1, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = yPos;
        }
        if (this.isOpen(yNeg = this.m_5676_(current.f_77271_, current.f_77272_ - 1, current.f_77273_))) {
            neighbors[numOpenNeighbors++] = yNeg;
        }
        if (this.isOpen(yPoszPos = this.m_5676_(current.f_77271_, current.f_77272_ + 1, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = yPoszPos;
        }
        if (this.isOpen(xNegYPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_ + 1, current.f_77273_)) && this.hasMalus(xNeg) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = xNegYPos;
        }
        if (this.isOpen(xPosYPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_ + 1, current.f_77273_)) && this.hasMalus(xPos) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = xPosYPos;
        }
        if (this.isOpen(yPosZNeg = this.m_5676_(current.f_77271_, current.f_77272_ + 1, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(yPos)) {
            neighbors[numOpenNeighbors++] = yPosZNeg;
        }
        if (this.isOpen(yNegZPos = this.m_5676_(current.f_77271_, current.f_77272_ - 1, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = yNegZPos;
        }
        if (this.isOpen(xNegYNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_ - 1, current.f_77273_)) && this.hasMalus(xNeg) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = xNegYNeg;
        }
        if (this.isOpen(xPosYNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_ - 1, current.f_77273_)) && this.hasMalus(xPos) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = xPosYNeg;
        }
        if (this.isOpen(yNegZNeg = this.m_5676_(current.f_77271_, current.f_77272_ - 1, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(yNeg)) {
            neighbors[numOpenNeighbors++] = yNegZNeg;
        }
        if (this.isOpen(xPosZNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(xPos)) {
            neighbors[numOpenNeighbors++] = xPosZNeg;
        }
        if (this.isOpen(xPosZPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(xPos)) {
            neighbors[numOpenNeighbors++] = xPosZPos;
        }
        if (this.isOpen(xNegZNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_, current.f_77273_ - 1)) && this.hasMalus(zNeg) && this.hasMalus(xNeg)) {
            neighbors[numOpenNeighbors++] = xNegZNeg;
        }
        if (this.isOpen(xNegZPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_, current.f_77273_ + 1)) && this.hasMalus(zPos) && this.hasMalus(xNeg)) {
            neighbors[numOpenNeighbors++] = xNegZPos;
        }
        if (this.isOpen(xposYPosZNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_ + 1, current.f_77273_ - 1)) && this.hasMalus(xPosZNeg) && this.hasMalus(zNeg) && this.hasMalus(xPos) && this.hasMalus(yPos) && this.hasMalus(yPosZNeg) && this.hasMalus(xPosYPos)) {
            neighbors[numOpenNeighbors++] = xposYPosZNeg;
        }
        if (this.isOpen(xPosYPosZPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_ + 1, current.f_77273_ + 1)) && this.hasMalus(xPosZPos) && this.hasMalus(zPos) && this.hasMalus(xPos) && this.hasMalus(yPos) && this.hasMalus(yPoszPos) && this.hasMalus(xPosYPos)) {
            neighbors[numOpenNeighbors++] = xPosYPosZPos;
        }
        if (this.isOpen(xNegYPosZNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_ + 1, current.f_77273_ - 1)) && this.hasMalus(xNegZNeg) && this.hasMalus(zNeg) && this.hasMalus(xNeg) && this.hasMalus(yPos) && this.hasMalus(yPosZNeg) && this.hasMalus(xNegYPos)) {
            neighbors[numOpenNeighbors++] = xNegYPosZNeg;
        }
        if (this.isOpen(xNegYPosZPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_ + 1, current.f_77273_ + 1)) && this.hasMalus(xNegZPos) && this.hasMalus(zPos) && this.hasMalus(xNeg) && this.hasMalus(yPos) && this.hasMalus(yPoszPos) && this.hasMalus(xNegYPos)) {
            neighbors[numOpenNeighbors++] = xNegYPosZPos;
        }
        if (this.isOpen(xPosYNegZNeg = this.m_5676_(current.f_77271_ + 1, current.f_77272_ - 1, current.f_77273_ - 1)) && this.hasMalus(xPosZNeg) && this.hasMalus(zNeg) && this.hasMalus(xPos) && this.hasMalus(yNeg) && this.hasMalus(yNegZNeg) && this.hasMalus(xPosYNeg)) {
            neighbors[numOpenNeighbors++] = xPosYNegZNeg;
        }
        if (this.isOpen(xPosYNegZPos = this.m_5676_(current.f_77271_ + 1, current.f_77272_ - 1, current.f_77273_ + 1)) && this.hasMalus(xPosZPos) && this.hasMalus(zPos) && this.hasMalus(xPos) && this.hasMalus(yNeg) && this.hasMalus(yNegZPos) && this.hasMalus(xPosYNeg)) {
            neighbors[numOpenNeighbors++] = xPosYNegZPos;
        }
        if (this.isOpen(xNegYNegZNeg = this.m_5676_(current.f_77271_ - 1, current.f_77272_ - 1, current.f_77273_ - 1)) && this.hasMalus(xNegZNeg) && this.hasMalus(zNeg) && this.hasMalus(xNeg) && this.hasMalus(yNeg) && this.hasMalus(yNegZNeg) && this.hasMalus(xNegYNeg)) {
            neighbors[numOpenNeighbors++] = xNegYNegZNeg;
        }
        if (this.isOpen(xNegYNegZPos = this.m_5676_(current.f_77271_ - 1, current.f_77272_ - 1, current.f_77273_ + 1)) && this.hasMalus(xNegZPos) && this.hasMalus(zPos) && this.hasMalus(xNeg) && this.hasMalus(yNeg) && this.hasMalus(yNegZPos) && this.hasMalus(xNegYNeg)) {
            neighbors[numOpenNeighbors++] = xNegYNegZPos;
        }
        return numOpenNeighbors;
    }

    protected BlockPathTypes getBlockPathType_ground(BlockGetter blockGetter, int x, int y, int z, Mob mob) {
        EnumSet<BlockPathTypes> enumset = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockpathtypes = BlockPathTypes.BLOCKED;
        blockpathtypes = this.getBlockPathTypes(blockGetter, x, y, z, enumset, blockpathtypes, mob.m_20183_());
        if (enumset.contains(BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        if (enumset.contains(BlockPathTypes.UNPASSABLE_RAIL)) {
            return BlockPathTypes.UNPASSABLE_RAIL;
        }
        BlockPathTypes blockpathtypes1 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockpathtypes2 : enumset) {
            if (mob.m_21439_(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(mob.m_21439_(blockpathtypes2) >= mob.m_21439_(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockpathtypes == BlockPathTypes.OPEN && mob.m_21439_(blockpathtypes1) == 0.0f && this.f_77315_ <= 1 ? BlockPathTypes.OPEN : blockpathtypes1;
    }

    protected BlockPathTypes getBlockPathType_flying(BlockGetter pLevel, int pX, int pY, int pZ, Mob pMob) {
        EnumSet<BlockPathTypes> enumset = EnumSet.noneOf(BlockPathTypes.class);
        BlockPathTypes blockpathtypes = BlockPathTypes.BLOCKED;
        BlockPos blockpos = pMob.m_20183_();
        blockpathtypes = this.getBlockPathTypes(pLevel, pX, pY, pZ, enumset, blockpathtypes, blockpos);
        if (enumset.contains(BlockPathTypes.FENCE)) {
            return BlockPathTypes.FENCE;
        }
        BlockPathTypes blockpathtypes1 = BlockPathTypes.BLOCKED;
        for (BlockPathTypes blockpathtypes2 : enumset) {
            if (pMob.m_21439_(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(pMob.m_21439_(blockpathtypes2) >= pMob.m_21439_(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockpathtypes == BlockPathTypes.OPEN && pMob.m_21439_(blockpathtypes1) == 0.0f ? BlockPathTypes.OPEN : blockpathtypes1;
    }

    public static BlockPathTypes getBlockPathTypeStatic(BlockGetter getter, BlockPos.MutableBlockPos position, Mob mob) {
        int i = position.m_123341_();
        int j = position.m_123342_();
        int k = position.m_123343_();
        BlockPathTypes blockPathType = ConstructNodeEvaluator.getBlockPathTypeRaw(getter, (BlockPos)position);
        if (blockPathType == BlockPathTypes.OPEN && j >= getter.m_141937_() + 1) {
            BlockPathTypes pathTypeBelow = ConstructNodeEvaluator.getBlockPathTypeRaw(getter, (BlockPos)position.m_122178_(i, j - 1, k));
            BlockPathTypes blockPathTypes = blockPathType = pathTypeBelow != BlockPathTypes.WALKABLE && pathTypeBelow != BlockPathTypes.OPEN && pathTypeBelow != BlockPathTypes.WATER && pathTypeBelow != BlockPathTypes.LAVA ? BlockPathTypes.WALKABLE : BlockPathTypes.OPEN;
            if (pathTypeBelow == BlockPathTypes.DAMAGE_FIRE) {
                blockPathType = BlockPathTypes.DAMAGE_FIRE;
            }
            if (pathTypeBelow == BlockPathTypes.DAMAGE_OTHER) {
                blockPathType = BlockPathTypes.DAMAGE_OTHER;
            }
            if (pathTypeBelow == BlockPathTypes.STICKY_HONEY) {
                blockPathType = BlockPathTypes.STICKY_HONEY;
            }
            if (pathTypeBelow == BlockPathTypes.POWDER_SNOW) {
                blockPathType = BlockPathTypes.DANGER_POWDER_SNOW;
            }
            if (pathTypeBelow == BlockPathTypes.DAMAGE_CAUTIOUS) {
                blockPathType = BlockPathTypes.DAMAGE_CAUTIOUS;
            }
        }
        if (blockPathType == BlockPathTypes.WALKABLE) {
            blockPathType = ConstructNodeEvaluator.checkNeighbourBlocks(getter, position.m_122178_(i, j, k), blockPathType);
        }
        return blockPathType;
    }

    public static BlockPathTypes checkNeighbourBlocks(BlockGetter pLevel, BlockPos.MutableBlockPos pCenterPos, BlockPathTypes pNodeType) {
        int x = pCenterPos.m_123341_();
        int y = pCenterPos.m_123342_();
        int z = pCenterPos.m_123343_();
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                    if (xOffset == 0 && zOffset == 0) continue;
                    pCenterPos.m_122178_(x + xOffset, y + yOffset, z + zOffset);
                    BlockState blockstate = pLevel.m_8055_((BlockPos)pCenterPos);
                    BlockPathTypes blockPathType = blockstate.getAdjacentBlockPathType(pLevel, (BlockPos)pCenterPos, null, pNodeType);
                    if (blockPathType != null) {
                        return blockPathType;
                    }
                    FluidState fluidState = blockstate.m_60819_();
                    BlockPathTypes fluidPathType = fluidState.getAdjacentBlockPathType(pLevel, (BlockPos)pCenterPos, null, pNodeType);
                    if (fluidPathType != null) {
                        return fluidPathType;
                    }
                    if (blockstate.m_60713_(Blocks.f_50128_) || blockstate.m_60713_(Blocks.f_50685_)) {
                        return BlockPathTypes.DANGER_OTHER;
                    }
                    if (ConstructNodeEvaluator.isBurningBlock(blockstate)) {
                        return BlockPathTypes.DANGER_FIRE;
                    }
                    if (pLevel.m_6425_((BlockPos)pCenterPos).m_205070_(FluidTags.f_13131_)) {
                        return BlockPathTypes.WATER_BORDER;
                    }
                    if (!blockstate.m_60713_(Blocks.f_50070_) && !blockstate.m_60713_(Blocks.f_152588_)) continue;
                    return BlockPathTypes.DAMAGE_CAUTIOUS;
                }
            }
        }
        return pNodeType;
    }

    protected static BlockPathTypes getBlockPathTypeRaw(BlockGetter pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        BlockPathTypes type = blockstate.getBlockPathType(pLevel, pPos, null);
        if (type != null) {
            return type;
        }
        Block block = blockstate.m_60734_();
        if (blockstate.m_60795_() || MATags.isBlockIn(block, MATags.Blocks.CONSTRUCT_WALK_THROUGH)) {
            return BlockPathTypes.OPEN;
        }
        if (!(blockstate.m_204336_(BlockTags.f_13036_) || blockstate.m_60713_(Blocks.f_50196_) || blockstate.m_60713_(Blocks.f_152545_))) {
            if (blockstate.m_60713_(Blocks.f_152499_)) {
                return BlockPathTypes.POWDER_SNOW;
            }
            if (!blockstate.m_60713_(Blocks.f_50128_) && !blockstate.m_60713_(Blocks.f_50685_)) {
                if (blockstate.m_60713_(Blocks.f_50719_)) {
                    return BlockPathTypes.STICKY_HONEY;
                }
                if (blockstate.m_60713_(Blocks.f_50262_)) {
                    return BlockPathTypes.COCOA;
                }
                if (!blockstate.m_60713_(Blocks.f_50070_) && !blockstate.m_60713_(Blocks.f_152588_)) {
                    FluidState fluidstate = pLevel.m_6425_(pPos);
                    BlockPathTypes nonLoggableFluidPathType = fluidstate.getBlockPathType(pLevel, pPos, null, false);
                    if (nonLoggableFluidPathType != null) {
                        return nonLoggableFluidPathType;
                    }
                    if (fluidstate.m_205070_(FluidTags.f_13132_)) {
                        return BlockPathTypes.LAVA;
                    }
                    if (ConstructNodeEvaluator.isBurningBlock(blockstate)) {
                        return BlockPathTypes.DAMAGE_FIRE;
                    }
                    if (block instanceof DoorBlock) {
                        DoorBlock doorblock = (DoorBlock)block;
                        if (((Boolean)blockstate.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                            return BlockPathTypes.DOOR_OPEN;
                        }
                        return doorblock.m_278711_().f_278463_() ? BlockPathTypes.DOOR_WOOD_CLOSED : BlockPathTypes.DOOR_IRON_CLOSED;
                    }
                    if (block instanceof BaseRailBlock) {
                        return BlockPathTypes.RAIL;
                    }
                    if (block instanceof LeavesBlock) {
                        return BlockPathTypes.LEAVES;
                    }
                    if (!(blockstate.m_204336_(BlockTags.f_13039_) || blockstate.m_204336_(BlockTags.f_13032_) || block instanceof FenceGateBlock && !((Boolean)blockstate.m_61143_((Property)FenceGateBlock.f_53341_)).booleanValue())) {
                        if (!blockstate.m_60647_(pLevel, pPos, PathComputationType.LAND)) {
                            return BlockPathTypes.BLOCKED;
                        }
                        BlockPathTypes loggableFluidPathType = fluidstate.getBlockPathType(pLevel, pPos, null, true);
                        if (loggableFluidPathType != null) {
                            return loggableFluidPathType;
                        }
                        return fluidstate.m_205070_(FluidTags.f_13131_) ? BlockPathTypes.WATER : BlockPathTypes.OPEN;
                    }
                    return BlockPathTypes.FENCE;
                }
                return BlockPathTypes.DAMAGE_CAUTIOUS;
            }
            return BlockPathTypes.DAMAGE_OTHER;
        }
        return BlockPathTypes.TRAPDOOR;
    }

    public static boolean isBurningBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13076_) || state.m_60713_(Blocks.f_49991_) || state.m_60713_(Blocks.f_50450_) || CampfireBlock.m_51319_((BlockState)state) || state.m_60713_(Blocks.f_152477_);
    }

    public static double getFloorLevel(BlockGetter blockGetter, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        VoxelShape voxelshape = blockGetter.m_8055_(below).m_60812_(blockGetter, below);
        return (double)below.m_123342_() + (voxelshape.m_83281_() ? 0.0 : voxelshape.m_83297_(Direction.Axis.Y));
    }

    private static boolean doesBlockHavePartialCollision(BlockPathTypes pBlockPathType) {
        return pBlockPathType == BlockPathTypes.FENCE || pBlockPathType == BlockPathTypes.DOOR_WOOD_CLOSED || pBlockPathType == BlockPathTypes.DOOR_IRON_CLOSED;
    }
}

