/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.config.GeneralConfigValues;
import com.mna.api.entities.DamageHelper;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.faction.IFaction;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.effects.EffectInit;
import com.mna.entities.faction.base.BaseFlyingFactionMob;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LanternWraith
extends BaseFlyingFactionMob<LanternWraith>
implements RangedAttackMob {
    private static final String INSTRUCTION_BOLT = "bolt";
    private static final String INSTRUCTION_AFFECT = "affect";
    private boolean isAttacking = false;

    public LanternWraith(EntityType<LanternWraith> type, Level worldIn) {
        super(type, worldIn);
    }

    public static boolean canSpawnPredicate(EntityType<LanternWraith> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        if (worldIn.m_46791_() == Difficulty.PEACEFUL || !IFactionEnemy.canMnASpawn(worldIn, pos)) {
            return false;
        }
        if (randomIn.m_188499_()) {
            return false;
        }
        if (randomIn.m_188503_(15) > 7) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.m_122032_();
        do {
            blockpos$mutableblockpos.m_122173_(Direction.UP);
        } while (worldIn.m_6425_((BlockPos)blockpos$mutableblockpos).m_205070_(FluidTags.f_13132_));
        if (worldIn.m_8055_((BlockPos)blockpos$mutableblockpos).m_60795_()) {
            int existingWraiths;
            return GeneralConfigValues.LanternWraithSpawnBoundsSize <= 0 || (existingWraiths = worldIn.m_45976_(LanternWraith.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)blockpos$mutableblockpos), (double)GeneralConfigValues.LanternWraithSpawnBoundsSize, (double)GeneralConfigValues.LanternWraithSpawnBoundsSize, (double)GeneralConfigValues.LanternWraithSpawnBoundsSize)).size()) <= GeneralConfigValues.LanternWraithGroupingLimit;
        }
        return false;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFlyingFactionMob<?>> state) {
        if (!this.isAttacking) {
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.ModelLanternWraith.move"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.ModelLanternWraith.idle"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.ModelLanternWraith.attack"));
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new RangedAttackGoal((RangedAttackMob)this, this.m_21133_(Attributes.f_22279_), 40, 80, 12.0f));
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SFX.Entity.LanternWraith.HURT;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.LanternWraith.DEATH;
    }

    public SoundEvent m_7515_() {
        return SFX.Entity.LanternWraith.IDLE;
    }

    @Override
    public IFaction getFaction() {
        return Factions.DEMONS;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        if (this.isAttacking) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<LivingEntity>(INSTRUCTION_BOLT, 20, target, this::handleDelayCallback));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isAttacking = true;
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11699_, SoundSource.HOSTILE, 1.0f, (float)(0.9 + Math.random() * 0.2));
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public void spawnSoulFireBolt(Entity target) {
        if (!target.m_6084_()) {
            return;
        }
        ServerMessageDispatcher.sendParticleSpawn(this.m_20185_(), this.m_20186_() + (double)1.1f, this.m_20189_(), target.m_20185_(), target.m_20186_() + (double)target.m_20192_(), target.m_20189_(), 0, 64.0f, (ResourceKey<Level>)this.m_9236_().m_46472_(), (MAParticleType)((Object)ParticleInit.WRAITH_BOLT.get()));
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Vec3>(INSTRUCTION_AFFECT, 20, target.m_20182_(), this::tryAffectTarget));
    }

    public void tryAffectTarget(String identifier, Vec3 position) {
        LivingEntity entity = this.m_5448_();
        if (entity == null) {
            return;
        }
        MobEffect goalEffect = MobEffects.f_19597_;
        int duration = 60;
        boolean increaseMagnitude = true;
        if (this.tier >= 2 && entity.m_21124_((MobEffect)EffectInit.LIFE_TAP.get()) == null) {
            goalEffect = (MobEffect)EffectInit.LIFE_TAP.get();
            duration = 200;
            increaseMagnitude = false;
        } else if (this.tier >= 3 && !entity.m_20096_()) {
            goalEffect = (MobEffect)EffectInit.GRAVITY_WELL.get();
            duration = 100;
            increaseMagnitude = false;
        }
        double dist = entity.m_20238_(position);
        if (!entity.m_6084_() || dist > 4.0) {
            return;
        }
        if (entity instanceof Player) {
            entity.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.getCastingResource().consume(entity, 100.0f));
        }
        int magnitude = 0;
        int damage = 5;
        MobEffectInstance inst = entity.m_21124_(goalEffect);
        if (inst != null) {
            if (increaseMagnitude) {
                damage += inst.m_19564_() * 2;
                if ((magnitude += inst.m_19564_() + 1) > 2) {
                    magnitude = 2;
                }
            } else {
                damage += 5;
            }
        }
        entity.m_7292_(new MobEffectInstance(goalEffect, duration, magnitude));
        entity.m_6469_(DamageHelper.createSourcedType((ResourceKey<DamageType>)DamageTypes.f_268515_, this.m_9236_().m_9598_(), (Entity)this), (float)damage);
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    private void handleDelayCallback(String identifier, LivingEntity entity) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            switch (identifier) {
                case "bolt": {
                    this.spawnSoulFireBolt((Entity)entity);
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            this.isAttacking = false;
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isAttacking);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isAttacking = nbt.m_128471_("attacking");
    }

    @Override
    protected float attackTargetRunawayDistance() {
        return 10.0f;
    }

    @Override
    protected float attackTargetRunawayThreshold() {
        return 4.0f;
    }
}

