/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.faction;

import com.mna.api.ManaAndArtificeMod;
import com.mna.api.entities.IFactionEnemy;
import com.mna.api.entities.ISpellInteractibleEntity;
import com.mna.api.faction.IFaction;
import com.mna.api.sound.SFX;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedEvent;
import com.mna.effects.EffectInit;
import com.mna.entities.ai.FactionTierWrapperGoal;
import com.mna.entities.boss.BossMonster;
import com.mna.entities.faction.base.BaseFactionMob;
import com.mna.factions.Factions;
import com.mna.network.ServerMessageDispatcher;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Spellbreaker
extends BaseFactionMob<Spellbreaker>
implements ISpellInteractibleEntity<Spellbreaker> {
    private static final String INSTRUCTION_DAMAGE = "damage";
    private static final String INSTRUCTION_SILENCE = "silence";
    private static final String INSTRUCTION_RALLY = "rally";
    private static final int SHIELD_BASH_CD = 300;
    private static final int RALLY_CD = 3600;
    private int shieldBashCooldown = 0;
    private int rallyCooldown = 0;
    private boolean isActing = false;
    private boolean isMeleeAttacking = false;
    private boolean isShieldBashing = false;
    private boolean isRallying = false;

    public Spellbreaker(EntityType<Spellbreaker> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public IFaction getFaction() {
        return Factions.COUNCIL;
    }

    public boolean m_21254_() {
        return !this.isActing;
    }

    @Override
    protected PlayState handleAnimState(AnimationState<? extends BaseFactionMob<?>> state) {
        if (!this.isActing) {
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.combat_walk"));
            }
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.model.combat_idle"));
        }
        if (this.isShieldBashing) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.combat_shield_bash"));
        }
        if (this.isRallying) {
            return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.combat_rally"));
        }
        return state.setAndContinue(RawAnimation.begin().thenPlay("animation.model.combat_stab"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        --this.shieldBashCooldown;
        --this.rallyCooldown;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FactionTierWrapperGoal(2, this, new RallyGoal()));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, this.m_21133_(Attributes.f_22279_), false));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, (double)0.35f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::factionTargetPlayerPredicate));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, this::factionTargetHelpPredicate));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, e -> e instanceof IFactionEnemy && ((IFactionEnemy)e).getFaction() != this.getFaction()));
    }

    public void m_21011_(InteractionHand p_226292_1_, boolean p_226292_2_) {
        if (this.isActing) {
            return;
        }
        DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 40, "", this::handleDelayCallback));
        this.isActing = true;
        this.isMeleeAttacking = true;
        ServerMessageDispatcher.sendEntityStateMessage(this);
    }

    public boolean m_7327_(Entity entityIn) {
        if (!this.isMeleeAttacking) {
            return true;
        }
        if (this.tier >= 2 && this.shieldBashCooldown <= 0) {
            this.isShieldBashing = true;
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>(INSTRUCTION_SILENCE, 20, entityIn, this::handleDelayCallback));
        } else {
            DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedEvent<Entity>(INSTRUCTION_DAMAGE, 20, entityIn, this::handleDelayCallback));
        }
        this.isMeleeAttacking = false;
        return true;
    }

    public boolean damageEntity(Entity entityIn) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entityIn.m_20254_(i * 4);
        }
        if (flag = entityIn.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f)) {
            if (f1 > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entityIn instanceof Player) {
                Player playerentity = (Player)entityIn;
                this.m_21424_(playerentity, this.m_21205_(), playerentity.m_6117_() ? playerentity.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entityIn);
            this.m_21335_(entityIn);
            if (this.f_19796_.m_188501_() < 0.4f && entityIn instanceof Mob) {
                ((Mob)entityIn).m_6710_((LivingEntity)this);
            }
        }
        return flag;
    }

    private void m_21424_(Player p_233655_1_, ItemStack p_233655_2_, ItemStack p_233655_3_) {
        if (!p_233655_2_.m_41619_() && !p_233655_3_.m_41619_() && p_233655_2_.m_41720_() instanceof AxeItem && p_233655_3_.m_41720_() == Items.f_42740_) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                p_233655_1_.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)p_233655_1_, (byte)30);
            }
        }
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, (double)0.55f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    private void handleDelayCallback(String identifier, Entity entity) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            switch (identifier) {
                case "damage": {
                    this.damageEntity(entity);
                    this.m_5496_(SFX.Entity.Generic.WOOSH, 1.0f, (float)(0.9 + Math.random() * (double)0.2f));
                    break;
                }
                case "silence": {
                    this.damageEntity(entity);
                    if (entity instanceof Player) {
                        ((Player)entity).m_7292_(new MobEffectInstance((MobEffect)EffectInit.SILENCE.get(), 100));
                    }
                    this.m_5496_(SFX.Entity.Spellbreaker.SHIELD_BASH, 1.0f, (float)(0.9 + Math.random() * (double)0.2f));
                    break;
                }
                case "rally": {
                    this.m_5496_(SFX.Entity.Spellbreaker.RALLY, 1.0f, 1.0f);
                    List allies = this.m_9236_().m_6443_(Monster.class, this.m_20191_().m_82400_(10.0), e -> e.m_6084_() && e instanceof Spellbreaker);
                    for (Monster m : allies) {
                        m.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 300, 1, false, true));
                        m.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 1, false, false));
                        m.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 300, 2, false, true));
                    }
                    break;
                }
            }
        }
    }

    private void handleDelayCallback(String identifier, String data) {
        if (!this.m_9236_().m_5776_()) {
            this.isActing = false;
            if (this.isShieldBashing) {
                this.shieldBashCooldown = 300;
                this.isShieldBashing = false;
            } else if (this.isRallying) {
                this.rallyCooldown = 3600;
                this.isRallying = false;
            }
            ServerMessageDispatcher.sendEntityStateMessage(this);
        }
    }

    @Override
    public CompoundTag getPacketData() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("attacking", this.isActing);
        nbt.m_128379_("shield_bashing", this.isShieldBashing);
        nbt.m_128379_("rallying", this.isRallying);
        return nbt;
    }

    @Override
    public void handlePacketData(CompoundTag nbt) {
        this.isActing = nbt.m_128471_("attacking");
        this.isShieldBashing = nbt.m_128471_("shield_bashing");
        this.isRallying = nbt.m_128471_("rallying");
    }

    @Override
    public boolean onShapeTarget(ISpellDefinition spell, SpellSource source) {
        if (!(source.getCaster() instanceof BossMonster) || Math.random() < 0.25) {
            Vec3 fwd = Vec3.m_82503_((Vec2)this.m_20155_());
            return ManaAndArtificeMod.getSpellHelper().reflectSpell(this.m_9236_(), (LivingEntity)this, spell, source, this.m_20182_(), fwd, true);
        }
        return true;
    }

    public class RallyGoal
    extends Goal {
        public RallyGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Spellbreaker.this.rallyCooldown <= 0 && Spellbreaker.this.m_5448_() != null && Spellbreaker.this.m_21223_() < Spellbreaker.this.m_21233_() * 0.75f && !Spellbreaker.this.m_21023_(MobEffects.f_19605_) && !Spellbreaker.this.m_21023_(MobEffects.f_19606_) && !Spellbreaker.this.m_21023_(MobEffects.f_19600_) && !Spellbreaker.this.isActing;
        }

        public void m_8056_() {
            Spellbreaker.this.m_21573_().m_26573_();
            Spellbreaker.this.isRallying = true;
            Spellbreaker.this.isActing = true;
            DelayedEventQueue.pushEvent(Spellbreaker.this.m_9236_(), new TimedDelayedEvent<LivingEntity>(Spellbreaker.INSTRUCTION_RALLY, 20, (LivingEntity)Spellbreaker.this, Spellbreaker.this::handleDelayCallback));
            DelayedEventQueue.pushEvent(Spellbreaker.this.m_9236_(), new TimedDelayedEvent<String>("resetattack", 40, "", Spellbreaker.this::handleDelayCallback));
            ServerMessageDispatcher.sendEntityStateMessage(Spellbreaker.this);
        }

        public boolean m_8045_() {
            return Spellbreaker.this.isRallying;
        }
    }
}

