/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.ritual;

import com.mna.entities.models.DemonStoneModel;
import com.mna.entities.rituals.DemonStone;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DemonStoneRenderer
extends EntityRenderer<DemonStone> {
    private static final ResourceLocation DEMON_STONE_TEXTURE = new ResourceLocation("textures/block/nether_bricks.png");
    protected final DemonStoneModel<DemonStone> modelStone = new DemonStoneModel(Minecraft.m_91087_().m_167973_().m_171103_(DemonStoneModel.LAYER_LOCATION));

    public DemonStoneRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(DemonStone entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        matrixStackIn.m_85836_();
        int age = entityIn.getAge();
        matrixStackIn.m_252880_(0.0f, -1.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        float angleDegrees = 0.0f;
        int numPillars = 3;
        for (int i = 0; i < numPillars; ++i) {
            matrixStackIn.m_85836_();
            float riseAmount = Math.min((float)(age - i * 10) / 100.0f * 2.5f, 2.5f);
            matrixStackIn.m_252880_(0.0f, -riseAmount, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(angleDegrees));
            matrixStackIn.m_252880_(-2.0f, 0.0f, 0.0f);
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            this.modelStone.m_6973_(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(this.modelStone.m_103119_(this.getTextureLocation(entityIn)));
            this.modelStone.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
            angleDegrees += 360.0f / (float)numPillars;
        }
        matrixStackIn.m_85849_();
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getTextureLocation(DemonStone entity) {
        return DEMON_STONE_TEXTURE;
    }
}

