/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.renderers.ritual;

import com.mna.api.tools.MATags;
import com.mna.entities.utility.DisplayReagents;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;

public class DisplayReagentsRenderer
extends EntityRenderer<DisplayReagents> {
    private final ItemRenderer itemRenderer;
    private final Minecraft mc = Minecraft.m_91087_();

    public DisplayReagentsRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = this.mc.m_91291_();
    }

    public ResourceLocation getTextureLocation(DisplayReagents entity) {
        return null;
    }

    public void render(DisplayReagents entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        List<ResourceLocation> reagents = entityIn.getResourceLocations();
        float displayItemWidth = 0.0625f;
        float offset = (float)reagents.size() * displayItemWidth;
        Quaternionf cameraRotation = this.f_114476_.m_253208_();
        Quaternionf portalRotation = new Quaternionf(0.0f, cameraRotation.y(), 0.0f, cameraRotation.w());
        int multiItemIndex = entityIn.getAge() / 40;
        int count = 0;
        float scaleFactor = 0.25f;
        for (ResourceLocation location : reagents) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_252880_(offset * (float)reagents.size() / 2.0f - displayItemWidth * 2.0f, 1.0f, 0.0f);
            matrixStackIn.m_252880_(-offset * (float)count, 0.0f, 0.0f);
            matrixStackIn.m_85841_(scaleFactor, scaleFactor, scaleFactor);
            matrixStackIn.m_85836_();
            matrixStackIn.m_252781_(portalRotation);
            List<Item> item = MATags.smartLookupItem(location);
            ItemStack renderStack = item.size() == 1 ? new ItemStack((ItemLike)item.get(0)) : new ItemStack((ItemLike)item.get(multiItemIndex % item.size()));
            if (renderStack != null) {
                this.itemRenderer.m_269128_(renderStack, ItemDisplayContext.FIXED, packedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, (Level)this.mc.f_91073_, 0);
            }
            matrixStackIn.m_85849_();
            this.m_7649_(entityIn, (Component)Component.m_237113_((String)("" + (count + 1))), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.m_85849_();
            ++count;
        }
        super.m_7392_((Entity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }
}

