/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.rituals;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.advancements.CustomAdvancementTriggers;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.config.GeneralConfigValues;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.recipes.IManaweavePattern;
import com.mna.api.recipes.IRitualRecipe;
import com.mna.api.rituals.IRitualReagent;
import com.mna.api.rituals.RitualBlockPos;
import com.mna.api.rituals.RitualEffect;
import com.mna.api.sound.SFX;
import com.mna.blocks.BlockInit;
import com.mna.blocks.ritual.ChalkRuneBlock;
import com.mna.blocks.tileentities.ChalkRuneTile;
import com.mna.capabilities.chunkdata.ChunkMagicProvider;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.manaweaving.Manaweave;
import com.mna.events.EventDispatcher;
import com.mna.network.ServerMessageDispatcher;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.manaweaving.ManaweavingPatternHelper;
import com.mna.recipes.rituals.RitualRecipe;
import com.mna.rituals.RitualBlockPosComparator;
import com.mna.rituals.RitualReagent;
import com.mna.rituals.contexts.RitualContext;
import com.mna.rituals.contexts.RitualReagentReplaceContext;
import com.mna.sound.EntityAliveLoopingSound;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.network.NetworkHooks;

public class Ritual
extends Entity {
    private static final EntityDataAccessor<CompoundTag> BLOCK_LOCATIONS = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<CompoundTag> VALID_LOCATIONS = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<CompoundTag> COLLECTED_REAGENTS = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final EntityDataAccessor<Byte> RITUAL_STATE = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> SHUTDOWN_AGE = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> RITUAL_NAME = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> CASTER_UUID = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> REQUESTED_PATTERN = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> CURRENT_ENTITY = SynchedEntityData.m_135353_(Ritual.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final byte MODE_ALL = 0;
    public static final byte MODE_INDEXED = 1;
    public static final byte MODE_INDEXED_DISPLAY = 2;
    public static final int REAGENT_ADVANCE_RATE = 20;
    public static final int RADIANT_ADVANCE_RATE = 10;
    public static final int BEAM_ADVANCE_RATE = 3;
    public static final float SPEED_NORMAL = 1.0f;
    public static float SPEED_FAST = 0.1f;
    private int age = 0;
    private int stageTicks = 0;
    final RitualBlockPosComparator comp;
    private NonNullList<Pair<BlockPos, ItemStack>> collectedReagents;
    private NonNullList<ResourceLocation> collectedPatterns;
    private NonNullList<ResourceLocation> requiredPatterns;
    private RitualState prevState;
    private RitualState curState;
    private boolean forceCollectAllReagents = false;
    private Entity __patternEntity;
    private int patternConsumeTicks = 0;
    private int dispatchTries = 0;
    private NonNullList<RitualEffect> __cachedRitualHandlers;
    private RitualRecipe __cachedCurrentRitual;
    private boolean __dynamicReagentsCached = false;
    public long worldTimeAtReagentCollectStart = 0L;
    private ItemStack cachedDynamicStack = ItemStack.f_41583_;
    private boolean dynamicItemChanged = false;

    public Ritual(EntityType<? extends Ritual> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_20331_(true);
        this.comp = new RitualBlockPosComparator();
        this.collectedReagents = NonNullList.m_122779_();
        this.collectedPatterns = NonNullList.m_122779_();
        this.requiredPatterns = NonNullList.m_122779_();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void runStateLogic() {
        try {
            switch (this.curState) {
                case POWERING_UP: {
                    this.logic_statePoweringUp();
                    break;
                }
                case COLLECTING_REAGENTS: {
                    this.logic_stateGatheringReagents();
                    break;
                }
                case COLLECTING_PATTERNS: {
                    this.logic_stateGatheringPatterns();
                    break;
                }
                case COLLAPSING: {
                    this.logic_collapsing();
                    break;
                }
                case PROCESSING_RITUAL: {
                    this.logic_processRitual();
                    break;
                }
                case COMPLETING: {
                    this.logic_complete();
                    break;
                }
            }
        }
        catch (Throwable t) {
            try {
                Player p = this.getCaster();
                if (p != null) {
                    p.m_213846_((Component)Component.m_237115_((String)"ritual.mna.fatal_error"));
                }
            }
            catch (Throwable subt) {
                ManaAndArtifice.LOGGER.error("Tried to send a message to the player performing the ritual about the following error, but it failed.");
                ManaAndArtifice.LOGGER.error((Object)subt);
            }
            ManaAndArtifice.LOGGER.error("A critical error has been caught during a ritual.  The ritual was terminated to preserve stability.");
            ManaAndArtifice.LOGGER.error((Object)t);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void logic_statePoweringUp() {
        if (this.getAge() % 5 == 0) {
            this.checkForExplosion(true);
        }
        if (this.getStageTicks() >= this.getPowerupTime()) {
            this.setState(RitualState.COLLECTING_REAGENTS);
        }
    }

    private void logic_stateGatheringReagents() {
        if (this.getAge() % 5 == 0) {
            this.checkForExplosion(false);
        }
        if (this.getStageTicks() == 10) {
            NonNullList<RitualBlockPos> locations = this.getRitualData((byte)1);
            for (RitualBlockPos rbp : locations) {
                BlockEntity te = this.m_9236_().m_7702_(rbp.getBlockPos());
                if (te == null || !(te instanceof ChalkRuneTile)) continue;
                ChalkRuneTile teCr = (ChalkRuneTile)te;
                if (rbp.isPresent() && !rbp.getReagent().isEmpty()) {
                    if (teCr.MatchesReagent(rbp.getReagent().getResourceLocation())) {
                        if (rbp.getReagent().shouldConsumeReagent() || rbp.getReagent().isManualReturn() || this.forceCollectAllReagents) {
                            ItemStack stack = teCr.m_8020_(0).m_41777_();
                            teCr.clearStack();
                            this.collectedReagents.add((Object)new Pair((Object)rbp.getBlockPos(), (Object)stack));
                            BlockState state = this.m_9236_().m_8055_(rbp.getBlockPos());
                            this.m_9236_().m_7260_(rbp.getBlockPos(), state, state, 2);
                        } else {
                            this.collectedReagents.add((Object)new Pair((Object)rbp.getBlockPos(), (Object)teCr.m_8020_(0).m_41777_()));
                        }
                    } else {
                        this.collectedReagents.add((Object)new Pair((Object)rbp.getBlockPos(), (Object)new ItemStack((ItemLike)Items.f_41852_)));
                    }
                }
                teCr.setReadOnly(true);
            }
            if (!this.m_9236_().m_5776_()) {
                ListTag list = this.writeCollectedReagents();
                CompoundTag compound = new CompoundTag();
                compound.m_128365_("data", (Tag)list);
                this.f_19804_.m_135381_(COLLECTED_REAGENTS, (Object)compound);
                ServerMessageDispatcher.sendRitualReagentData(compound, this.m_19879_(), (ServerLevel)this.m_9236_(), this.m_20183_());
            }
        }
        if (this.getStageTicks() >= 40) {
            this.setState(RitualState.COLLECTING_PATTERNS);
        }
    }

    private void logic_stateGatheringPatterns() {
        if (this.getAge() % 5 == 0) {
            this.checkForExplosion(false);
        }
        if (this.requiredPatterns.size() == 0) {
            this.setState(RitualState.COLLAPSING);
            return;
        }
        ManaweavingPattern pattern = this.getRequestedPattern();
        if (pattern == null) {
            this.setRequestedPattern(((ResourceLocation)this.requiredPatterns.get(0)).toString());
            return;
        }
        if (this.getCurrentEntityTarget() == null) {
            if (this.getAge() % 10 == 0) {
                this.findPatternEntity();
            }
        } else {
            ++this.patternConsumeTicks;
            if (this.patternConsumeTicks >= 20) {
                this.getCurrentEntityTarget().m_142687_(Entity.RemovalReason.DISCARDED);
                this.setRequestedPattern("");
                this.patternConsumeTicks = 0;
                this.collectedPatterns.add((Object)((ResourceLocation)this.requiredPatterns.get(0)));
                this.requiredPatterns.remove(0);
            }
        }
    }

    private void logic_collapsing() {
        if (this.getStageTicks() >= 20) {
            this.setState(RitualState.PROCESSING_RITUAL);
        }
    }

    private void logic_processRitual() {
        Player ritualCaster = this.getCaster();
        if (ritualCaster != null || this.dispatchTries >= 10) {
            if (ritualCaster == null) {
                ManaAndArtifice.LOGGER.error("Failed to parse UUID for ritual caster.  Giving up and completing the ritual anyway, but some effects may not apply!");
            }
            for (RitualEffect eff : this.getHandlers()) {
                eff.onRitualCompleted(new RitualContext(this.getCaster(), this));
            }
        } else {
            ++this.dispatchTries;
            return;
        }
        int shutdownTime = 0;
        for (RitualEffect eff : this.getHandlers()) {
            int time = eff.getRitualCompleteDelay(new RitualContext(this.getCaster(), this));
            if (time <= shutdownTime) continue;
            shutdownTime = time;
        }
        if (shutdownTime < 0) {
            shutdownTime = 0;
        }
        this.setShutdownAge(shutdownTime);
        this.setState(RitualState.COMPLETING);
    }

    private void logic_complete() {
        if (this.m_6084_() && this.getStageTicks() > this.getShutdownAge()) {
            NonNullList<RitualBlockPos> positions = this.getRitualData((byte)0);
            for (int i = 0; i < positions.size(); ++i) {
                ChalkRuneTile tecr;
                BlockState runeState = this.m_9236_().m_8055_(((RitualBlockPos)positions.get(i)).getBlockPos());
                if (runeState.m_60734_() != BlockInit.CHALK_RUNE.get() || (tecr = (ChalkRuneTile)this.m_9236_().m_7702_(((RitualBlockPos)positions.get(i)).getBlockPos())) == null) continue;
                if (((Boolean)runeState.m_61143_((Property)ChalkRuneBlock.METAL)).booleanValue()) {
                    tecr.setReadOnly(false);
                    this.m_9236_().m_46597_(((RitualBlockPos)positions.get(i)).getBlockPos(), (BlockState)runeState.m_61124_((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                if (!tecr.isGhostItem()) {
                    Containers.m_19002_((Level)this.m_9236_(), (BlockPos)((RitualBlockPos)positions.get(i)).getBlockPos(), (Container)tecr);
                }
                this.m_9236_().m_46597_(((RitualBlockPos)positions.get(i)).getBlockPos(), Blocks.f_50016_.m_49966_());
            }
            if (this.getCurrentRitual() != null && this.getCaster() != null) {
                EventDispatcher.DispatchRitualComplete(this.getCurrentRitual(), this.getHandlers(), this.m_20183_(), this.collectedReagents.stream().map(e -> (ItemStack)e.getSecond()).collect(Collectors.toList()), this.getCaster());
                this.getCaster().getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> this.getCaster().getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> m.addMagicXP(10, this.getCaster(), (IPlayerProgression)p)));
                this.executeCommand(this.getCurrentRitual());
                if (this.getCaster() instanceof ServerPlayer) {
                    CustomAdvancementTriggers.PERFORM_RITUAL.trigger((ServerPlayer)this.getCaster(), this.getCurrentRitual().m_6423_(), this.getCurrentRitual().getTier());
                }
            }
            this.m_9236_().m_46745_(this.m_20183_()).getCapability(ChunkMagicProvider.MAGIC).ifPresent(cm -> cm.addResidualMagic(this.__cachedCurrentRitual != null ? (float)(this.__cachedCurrentRitual.getTier() * 100) : 100.0f));
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_8119_() {
        this.prevState = this.curState;
        this.curState = this.getState();
        this.setStageTicks(this.getStageTicks() + 1);
        if (this.curState == RitualState.GUIDING_REAGENT_PLACEMENT) {
            if (!this.m_9236_().m_5776_() && !this.__dynamicReagentsCached && this.stageTicks % 20 == 0) {
                this.checkRitualIntegrity(true);
            }
            return;
        }
        this.setAge(this.getAge() + 1);
        if (this.prevState != this.curState) {
            this.setStageTicks(0);
        }
        if (this.m_9236_().m_5776_()) {
            this.SpawnParticles();
            this.PlaySounds();
        } else {
            this.runStateLogic();
        }
    }

    public boolean confirmRitualReagents() {
        if (this.getState() != RitualState.GUIDING_REAGENT_PLACEMENT) {
            return false;
        }
        boolean canStart = true;
        ArrayList<BlockPos> validLocations = new ArrayList<BlockPos>();
        NonNullList<RitualBlockPos> ritualData = this.getRitualData((byte)1, true);
        if (this.dynamicItemChanged) {
            this.cancelRitual(true);
            return false;
        }
        for (RitualBlockPos pos : ritualData) {
            if (!pos.isPresent() || pos.getReagent().isOptional() || !this.m_9236_().m_46749_(pos.getBlockPos())) continue;
            ChalkRuneTile te = (ChalkRuneTile)this.m_9236_().m_7702_(pos.getBlockPos());
            if (te == null) {
                return false;
            }
            boolean match = te.MatchesReagent(pos.getReagent().getResourceLocation());
            if (match) {
                validLocations.add(pos.getBlockPos());
            }
            canStart &= match;
        }
        this.setValidReagentLocations(validLocations);
        if (canStart) {
            this.setState(RitualState.POWERING_UP);
        }
        return canStart;
    }

    @Nullable
    public IRitualReagent getReagentForPosition(BlockPos pos) {
        if (this.getState() != RitualState.GUIDING_REAGENT_PLACEMENT) {
            return null;
        }
        Optional<RitualBlockPos> dataPos = this.getRitualData((byte)1).stream().filter(rbp -> rbp.getBlockPos().equals((Object)pos)).findFirst();
        if (dataPos.isPresent() && this.m_9236_().m_46749_(pos)) {
            ChalkRuneTile te = (ChalkRuneTile)this.m_9236_().m_7702_(dataPos.get().getBlockPos());
            if (te == null) {
                return null;
            }
            return dataPos.get().getReagent();
        }
        return null;
    }

    public boolean checkForExplosion(boolean checkReagents) {
        if (this.getState() == RitualState.COMPLETING || this.getState() == RitualState.PROCESSING_RITUAL) {
            return false;
        }
        if (!this.m_6084_()) {
            return false;
        }
        boolean integrityCheck = this.checkRitualIntegrity(checkReagents);
        if (!integrityCheck) {
            this.cancelRitual(true);
            if (this.getState() != RitualState.GUIDING_REAGENT_PLACEMENT) {
                float radius = this.__cachedCurrentRitual == null ? 2.5f : (float)this.__cachedCurrentRitual.getLowerBound();
                this.m_9236_().m_254849_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), radius, this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
                this.setState(RitualState.DEAD);
            }
            return false;
        }
        return true;
    }

    private boolean checkRitualIntegrity(boolean checkReagents) {
        NonNullList<RitualBlockPos> locations = this.getRitualData((byte)0);
        for (int i = 0; i < locations.size(); ++i) {
            ChalkRuneTile te;
            if (!this.m_9236_().m_46749_(((RitualBlockPos)locations.get(i)).getBlockPos()) || this.m_9236_().m_8055_(((RitualBlockPos)locations.get(i)).getBlockPos()).m_60734_() != ((Block)BlockInit.CHALK_RUNE.get()).m_49966_().m_60734_()) {
                return false;
            }
            if (!checkReagents || ((RitualBlockPos)locations.get(i)).getIndex() < 0 || !((RitualBlockPos)locations.get(i)).isPresent() || ((RitualBlockPos)locations.get(i)).getReagent().isOptional() || (te = (ChalkRuneTile)this.m_9236_().m_7702_(((RitualBlockPos)locations.get(i)).getBlockPos())).MatchesReagent(((RitualBlockPos)locations.get(i)).getReagent().getResourceLocation())) continue;
            return false;
        }
        return true;
    }

    private void findPatternEntity() {
        Optional<Manaweave> patternEntity = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(10.0), entity -> {
            if (!(entity instanceof Manaweave)) {
                return false;
            }
            Manaweave mw = (Manaweave)((Object)entity);
            ArrayList<IManaweavePattern> p = mw.getPatterns();
            if (p.size() != 1) {
                return false;
            }
            return p.get(0).getRegistryId().toString().equals(this.getRequestedPattern().m_6423_().toString());
        }).stream().map(e -> (Manaweave)((Object)e)).findFirst();
        if (patternEntity != null && patternEntity.isPresent()) {
            this.setCurrentEntityTarget(patternEntity.get());
            patternEntity.get().setMerging(true);
        }
    }

    public boolean cancelRitual() {
        return this.cancelRitual(false);
    }

    private boolean cancelRitual(boolean ignoreState) {
        if (!this.m_9236_().m_5776_() && (ignoreState || this.getState() == RitualState.GUIDING_REAGENT_PLACEMENT)) {
            NonNullList<RitualBlockPos> locations = this.getRitualData((byte)0);
            for (RitualBlockPos pos : locations) {
                BlockEntity te = this.m_9236_().m_7702_(pos.getBlockPos());
                if (te == null || !(te instanceof ChalkRuneTile)) continue;
                if (this.m_9236_().m_8055_(pos.getBlockPos()).m_60734_() == BlockInit.CHALK_RUNE.get()) {
                    ((ChalkRuneTile)te).setReadOnly(false);
                    this.m_9236_().m_46597_(pos.getBlockPos(), (BlockState)this.m_9236_().m_8055_(pos.getBlockPos()).m_61124_((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(false)));
                    continue;
                }
                this.m_9236_().m_46597_(pos.getBlockPos(), Blocks.f_50016_.m_49966_());
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    public void executeCommand(IRitualRecipe recipe) {
        if (!recipe.hasCommand()) {
            return;
        }
        MinecraftServer minecraftserver = this.m_9236_().m_7654_();
        if (minecraftserver.m_6993_()) {
            try {
                CommandSourceStack css = new CommandSourceStack((CommandSource)this, this.m_20182_(), this.m_20155_(), this.m_9236_() instanceof ServerLevel ? (ServerLevel)this.m_9236_() : null, GeneralConfigValues.RitualPermissionLevel, this.m_7755_().getString(), this.m_5446_(), this.m_9236_().m_7654_(), (Entity)this.getCaster());
                minecraftserver.m_129892_().m_230957_(css, recipe.getCommand());
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Executing ritual command");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Command to be executed");
                crashreportcategory.m_128159_("Command", (Object)recipe.getCommand());
                throw new ReportedException(crashreport);
            }
        }
    }

    private void PlaySounds() {
        if (this.curState == RitualState.POWERING_UP && this.stageTicks == 0) {
            this.PlaySound(SFX.Spell.Cast.ARCANE);
            if (this.getHandlers().size() > 0) {
                RitualEffect effect = (RitualEffect)this.getHandlers().get((int)(Math.random() * (double)this.getHandlers().size()));
                this.PlayLoopingSound(effect.getLoopSound(new RitualContext(this.getCaster(), this)));
            } else {
                this.PlayLoopingSound(SFX.Loops.ENDER);
            }
        }
        if (this.curState.ordinal() >= RitualState.POWERING_UP.ordinal() && this.curState != RitualState.COMPLETING) {
            int beamAge;
            int points;
            int radiant_ticks = (int)Math.ceil(10.0f * this.getSpeed());
            int maxPos = this.age / radiant_ticks;
            if (maxPos < (points = this.getRitualData((byte)2).size()) + 1 && this.age % radiant_ticks == 0) {
                this.PlaySound(SFX.Ritual.Effects.RITUAL_POINT_APPEAR);
            }
            if ((beamAge = this.age - radiant_ticks * points) == 5) {
                this.PlaySound(SFX.Spell.Cast.ENDER);
            }
        }
    }

    private void PlaySound(SoundEvent soundID) {
        this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), soundID, SoundSource.PLAYERS, 1.0f, 1.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void PlayLoopingSound(SoundEvent soundID) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityAliveLoopingSound(soundID, this));
    }

    private void SpawnParticles() {
        boolean useDefault = false;
        RitualContext context = new RitualContext(this.getCaster(), this);
        for (RitualEffect effect : this.getHandlers()) {
            useDefault |= !effect.spawnRitualParticles(context);
        }
        RitualState curState = this.getState();
        NonNullList<RitualBlockPos> positions = this.getRitualData((byte)1);
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos cur = ((RitualBlockPos)positions.get(i)).getBlockPos();
            if (useDefault && curState.ordinal() > RitualState.POWERING_UP.ordinal()) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_VELOCITY.get())), (double)cur.m_123341_() + Math.random(), (double)cur.m_123342_(), (double)cur.m_123343_() + Math.random(), 0.0, Math.random() * (double)0.05f + (double)0.05f, 0.0);
            }
            if (curState == RitualState.COLLECTING_PATTERNS && this.getCurrentEntityTarget() != null) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_LERP_POINT.get())), -0.5 + this.getCurrentEntityTarget().m_20185_() + Math.random(), -0.5 + this.getCurrentEntityTarget().m_20186_() + Math.random(), -0.5 + this.getCurrentEntityTarget().m_20189_() + Math.random(), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            }
            if (this.getStageTicks() != this.getShutdownAge()) continue;
            for (int j = 0; j < 10; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.SPARKLE_RANDOM.get())), (double)cur.m_123341_() + Math.random(), (double)cur.m_123342_(), (double)cur.m_123343_() + Math.random(), (double)0.1f, (double)0.1f, (double)0.1f);
            }
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_LOCATIONS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(RITUAL_STATE, (Object)((byte)RitualState.GUIDING_REAGENT_PLACEMENT.ordinal()));
        this.f_19804_.m_135372_(RITUAL_NAME, (Object)"");
        this.f_19804_.m_135372_(SHUTDOWN_AGE, (Object)-1);
        this.f_19804_.m_135372_(SPEED, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(CASTER_UUID, (Object)"");
        this.f_19804_.m_135372_(REQUESTED_PATTERN, (Object)"");
        this.f_19804_.m_135372_(CURRENT_ENTITY, (Object)-1);
        this.f_19804_.m_135372_(VALID_LOCATIONS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(COLLECTED_REAGENTS, (Object)new CompoundTag());
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (this.m_9236_().m_5776_() && key == COLLECTED_REAGENTS) {
            ListTag data = ((CompoundTag)this.f_19804_.m_135370_(COLLECTED_REAGENTS)).m_128437_("data", 10);
            this.readCollectedReagents(data);
        } else if (this.m_9236_().m_5776_() && key == RITUAL_STATE && this.getState() == RitualState.COLLECTING_REAGENTS) {
            this.worldTimeAtReagentCollectStart = this.m_9236_().m_46467_();
        }
        super.m_7350_(key);
    }

    private void WriteBlockPosToNBT(String key, RitualBlockPos pos, CompoundTag nbt) {
        CompoundTag subNBT = new CompoundTag();
        subNBT.m_128405_("idx", pos.getIndex());
        subNBT.m_128405_("d_idx", pos.getDisplayIndex());
        subNBT.m_128405_("x", pos.getBlockPos().m_123341_());
        subNBT.m_128405_("y", pos.getBlockPos().m_123342_());
        subNBT.m_128405_("z", pos.getBlockPos().m_123343_());
        if (pos.isPresent()) {
            ((RitualReagent)pos.getReagent()).writeToNBT(subNBT);
        }
        nbt.m_128365_(key, (Tag)subNBT);
    }

    private RitualBlockPos ReadBlockPosFromNBT(String key, CompoundTag nbt) {
        if (!nbt.m_128441_(key)) {
            return null;
        }
        CompoundTag subNBT = nbt.m_128469_(key);
        if (!(subNBT.m_128441_("x") && subNBT.m_128441_("y") && subNBT.m_128441_("z") && subNBT.m_128441_("idx") && subNBT.m_128441_("d_idx"))) {
            return null;
        }
        return new RitualBlockPos(subNBT.m_128451_("idx"), subNBT.m_128451_("d_idx"), new BlockPos(subNBT.m_128451_("x"), subNBT.m_128451_("y"), subNBT.m_128451_("z")), RitualReagent.fromNBT(subNBT));
    }

    public void readCollectedReagents(ListTag data) {
        this.collectedReagents.clear();
        for (int i = 0; i < data.size(); ++i) {
            CompoundTag entry = data.m_128728_(i);
            if (entry == null || !entry.m_128441_("pos") || !entry.m_128441_("stack")) continue;
            BlockPos pos = BlockPos.m_122022_((long)entry.m_128454_("pos"));
            ItemStack stack = ItemStack.m_41712_((CompoundTag)entry.m_128469_("stack"));
            if (pos == null || stack == null) continue;
            this.collectedReagents.add((Object)new Pair((Object)pos, (Object)stack));
        }
        this.worldTimeAtReagentCollectStart = this.m_9236_().m_46467_();
        if (!this.m_9236_().m_5776_()) {
            ListTag list = this.writeCollectedReagents();
            CompoundTag compound = new CompoundTag();
            compound.m_128365_("data", (Tag)list);
            this.f_19804_.m_135381_(COLLECTED_REAGENTS, (Object)compound);
        }
    }

    private ListTag writeCollectedReagents() {
        ListTag collected_reagents = new ListTag();
        for (Pair e : this.collectedReagents) {
            CompoundTag entry = new CompoundTag();
            entry.m_128356_("pos", ((BlockPos)e.getFirst()).m_121878_());
            entry.m_128365_("stack", (Tag)((ItemStack)e.getSecond()).m_41739_(new CompoundTag()));
            collected_reagents.add((Object)entry);
        }
        return collected_reagents;
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("ritual_data")) {
            int i;
            int count;
            CompoundTag ritualData = compound.m_128469_("ritual_data");
            if (ritualData.m_128441_("shutdown_age")) {
                this.f_19804_.m_135381_(SHUTDOWN_AGE, (Object)ritualData.m_128451_("shutdown_age"));
            }
            if (ritualData.m_128441_("ritual_name")) {
                this.f_19804_.m_135381_(RITUAL_NAME, (Object)ritualData.m_128461_("ritual_name"));
            }
            if (ritualData.m_128441_("state")) {
                this.f_19804_.m_135381_(RITUAL_STATE, (Object)ritualData.m_128445_("state"));
            }
            if (ritualData.m_128441_("speed")) {
                this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(ritualData.m_128457_("speed")));
            }
            if (ritualData.m_128441_("caster")) {
                this.f_19804_.m_135381_(CASTER_UUID, (Object)ritualData.m_128461_("caster"));
            }
            if (ritualData.m_128441_("block_locations")) {
                this.f_19804_.m_135381_(BLOCK_LOCATIONS, (Object)((CompoundTag)ritualData.m_128423_("block_locations")));
            }
            if (ritualData.m_128441_("valid_locations")) {
                this.f_19804_.m_135381_(VALID_LOCATIONS, (Object)((CompoundTag)ritualData.m_128423_("valid_locations")));
            }
            if (ritualData.m_128441_("__dynamicReagentsCached")) {
                this.__dynamicReagentsCached = ritualData.m_128471_("__dynamicReagentsCached");
            }
            if (ritualData.m_128425_("collected_reagents", 9)) {
                this.readCollectedReagents(ritualData.m_128437_("collected_reagents", 10));
            } else {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (ritualData.m_128441_("forceCollectAllReagents")) {
                this.forceCollectAllReagents = ritualData.m_128471_("forceCollectAllReagents");
            }
            if (ritualData.m_128441_("dynamicSourceCache")) {
                this.cachedDynamicStack = ItemStack.m_41712_((CompoundTag)((CompoundTag)ritualData.m_128423_("dynamicSourceCache")));
            }
            if (ritualData.m_128441_("collected_patterns")) {
                CompoundTag collected_patterns = ritualData.m_128469_("collected_patterns");
                count = collected_patterns.m_128451_("count");
                for (i = 0; i < count; ++i) {
                    this.collectedPatterns.add((Object)new ResourceLocation(collected_patterns.m_128461_("pattern_" + i)));
                }
            }
            if (ritualData.m_128441_("required_patterns")) {
                CompoundTag required_patterns = ritualData.m_128469_("required_patterns");
                count = required_patterns.m_128451_("count");
                for (i = 0; i < count; ++i) {
                    this.requiredPatterns.add((Object)new ResourceLocation(required_patterns.m_128461_("pattern_" + i)));
                }
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        CompoundTag ritualData = new CompoundTag();
        ritualData.m_128405_("shutdown_age", ((Integer)this.f_19804_.m_135370_(SHUTDOWN_AGE)).intValue());
        ritualData.m_128359_("ritual_name", (String)this.f_19804_.m_135370_(RITUAL_NAME));
        ritualData.m_128359_("caster", (String)this.f_19804_.m_135370_(CASTER_UUID));
        ritualData.m_128344_("state", ((Byte)this.f_19804_.m_135370_(RITUAL_STATE)).byteValue());
        ritualData.m_128350_("speed", ((Float)this.f_19804_.m_135370_(SPEED)).floatValue());
        ritualData.m_128365_("block_locations", (Tag)this.f_19804_.m_135370_(BLOCK_LOCATIONS));
        ritualData.m_128365_("valid_locations", (Tag)this.f_19804_.m_135370_(VALID_LOCATIONS));
        ritualData.m_128379_("forceCollectAllReagents", this.forceCollectAllReagents);
        ritualData.m_128379_("__dynamicReagentsCached", this.__dynamicReagentsCached);
        ritualData.m_128365_("dynamicSourceCache", (Tag)this.cachedDynamicStack.serializeNBT());
        ritualData.m_128365_("collected_reagents", (Tag)this.writeCollectedReagents());
        CompoundTag collected_patterns = new CompoundTag();
        collected_patterns.m_128405_("count", this.collectedPatterns.size());
        for (int i = 0; i < this.collectedPatterns.size(); ++i) {
            collected_patterns.m_128359_("pattern_" + i, ((ResourceLocation)this.collectedPatterns.get(i)).toString());
        }
        ritualData.m_128365_("collected_patterns", (Tag)collected_patterns);
        CompoundTag required_patterns = new CompoundTag();
        required_patterns.m_128405_("count", this.requiredPatterns.size());
        for (int i = 0; i < this.requiredPatterns.size(); ++i) {
            required_patterns.m_128359_("pattern_" + i, ((ResourceLocation)this.requiredPatterns.get(i)).toString());
        }
        ritualData.m_128365_("required_patterns", (Tag)required_patterns);
        compound.m_128365_("ritual_data", (Tag)ritualData);
    }

    public ArrayList<BlockPos> getValidReagentLocations() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        CompoundTag nbt = (CompoundTag)this.f_19804_.m_135370_(VALID_LOCATIONS);
        if (!nbt.m_128441_("count")) {
            return positions;
        }
        int count = nbt.m_128451_("count");
        for (int i = 0; i < count; ++i) {
            if (nbt.m_128441_("block_pos_" + i)) {
                CompoundTag blockPos = nbt.m_128469_("block_pos_" + i);
                BlockPos pos = new BlockPos(blockPos.m_128451_("x"), blockPos.m_128451_("y"), blockPos.m_128451_("z"));
                positions.add(pos);
                continue;
            }
            ManaAndArtifice.LOGGER.error("Missing key block_pos_" + i + " in valid reagent locations sync data.");
        }
        return positions;
    }

    private void setValidReagentLocations(ArrayList<BlockPos> locations) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("count", locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            CompoundTag blockPos = new CompoundTag();
            BlockPos pos = locations.get(i);
            blockPos.m_128405_("x", pos.m_123341_());
            blockPos.m_128405_("y", pos.m_123342_());
            blockPos.m_128405_("z", pos.m_123343_());
            nbt.m_128365_("block_pos_" + i, (Tag)blockPos);
        }
        this.f_19804_.m_135381_(VALID_LOCATIONS, (Object)nbt);
    }

    private void setCurrentEntityTarget(Entity e) {
        this.f_19804_.m_135381_(CURRENT_ENTITY, (Object)e.m_19879_());
    }

    private Entity getCurrentEntityTarget() {
        if (this.__patternEntity == null || !this.__patternEntity.m_6084_()) {
            this.patternConsumeTicks = 0;
            this.__patternEntity = this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(CURRENT_ENTITY)).intValue());
        }
        return this.__patternEntity;
    }

    public void setRequiredPatterns(Collection<ResourceLocation> patterns) {
        if (patterns == this.requiredPatterns) {
            return;
        }
        this.requiredPatterns.addAll(patterns);
    }

    public void setRitualBlockLocations(NonNullList<RitualBlockPos> locations) {
        CompoundTag blockLocations = new CompoundTag();
        blockLocations.m_128405_("count", locations.size());
        for (int i = 0; i < locations.size(); ++i) {
            this.WriteBlockPosToNBT("blockPos" + i, (RitualBlockPos)locations.get(i), blockLocations);
        }
        this.f_19804_.m_135381_(BLOCK_LOCATIONS, (Object)blockLocations);
    }

    public NonNullList<RitualBlockPos> getRitualData(byte mode) {
        return this.getRitualData(mode, false);
    }

    public NonNullList<RitualBlockPos> getRitualData(byte mode, boolean checkDynamicChange) {
        NonNullList positions = NonNullList.m_122779_();
        CompoundTag blockLocations = (CompoundTag)this.f_19804_.m_135370_(BLOCK_LOCATIONS);
        if (!blockLocations.m_128441_("count")) {
            return positions;
        }
        RitualBlockPos dynamicSupplier = null;
        boolean foundDynamics = false;
        int count = blockLocations.m_128451_("count");
        for (int i = 0; i < count; ++i) {
            RitualBlockPos pos = this.ReadBlockPosFromNBT("blockPos" + i, blockLocations);
            if (pos == null) {
                return NonNullList.m_122779_();
            }
            if (mode == 1 && pos.getIndex() < 0 || mode == 2 && pos.getDisplayIndex() < 0) continue;
            if (pos.getReagent() != null) {
                if (pos.getReagent().isDynamic()) {
                    foundDynamics = true;
                }
                if (pos.getReagent().isDynamicSource()) {
                    dynamicSupplier = pos;
                }
            }
            positions.add((Object)pos);
        }
        if (mode == 1 || mode == 0) {
            this.comp.setCompareIndex();
        } else if (mode == 2) {
            this.comp.setCompareDisplay();
        }
        positions.sort((Comparator)this.comp);
        if (!this.m_9236_().m_5776_()) {
            ItemStack dynamicStack;
            BlockEntity te;
            if (!this.__dynamicReagentsCached) {
                if (foundDynamics) {
                    if (dynamicSupplier == null) {
                        ManaAndArtifice.LOGGER.error("Ritual specifies dynamic reagents/patterns but no supplier is found!");
                        positions.clear();
                    } else {
                        BlockEntity te2 = this.m_9236_().m_7702_(dynamicSupplier.getBlockPos());
                        if (te2 != null && te2 instanceof ChalkRuneTile) {
                            ItemStack dynamicStack2;
                            boolean modified = false;
                            this.cachedDynamicStack = dynamicStack2 = ((ChalkRuneTile)te2).getDisplayedItem().m_41777_();
                            for (RitualEffect eff : this.getHandlers()) {
                                modified |= eff.getDynamicReagents(dynamicStack2, new RitualReagentReplaceContext(this.getCaster(), this, (NonNullList<RitualBlockPos>)positions));
                            }
                            if (modified) {
                                this.setRitualBlockLocations((NonNullList<RitualBlockPos>)positions);
                                this.__dynamicReagentsCached = true;
                            }
                        }
                    }
                } else {
                    this.__dynamicReagentsCached = true;
                }
            } else if (foundDynamics && checkDynamicChange && (te = this.m_9236_().m_7702_(dynamicSupplier.getBlockPos())) != null && te instanceof ChalkRuneTile && !ItemStack.m_41728_((ItemStack)this.cachedDynamicStack, (ItemStack)(dynamicStack = ((ChalkRuneTile)te).getDisplayedItem().m_41777_()))) {
                this.dynamicItemChanged = true;
            }
        }
        return positions;
    }

    private ResourceLocation getRitualName() {
        return new ResourceLocation((String)this.f_19804_.m_135370_(RITUAL_NAME));
    }

    public void setRitualName(ResourceLocation name) {
        this.f_19804_.m_135381_(RITUAL_NAME, (Object)name.toString());
        this.__cachedCurrentRitual = RitualRecipe.find(this.m_9236_(), name);
        if (this.__cachedCurrentRitual != null) {
            ArrayList<ResourceLocation> patterns = new ArrayList<ResourceLocation>();
            for (String s : this.__cachedCurrentRitual.getManaweavePatterns()) {
                patterns.add(new ResourceLocation(s));
            }
            this.setRequiredPatterns(patterns);
        }
    }

    public RitualRecipe getCurrentRitual() {
        if (this.__cachedCurrentRitual == null) {
            this.__cachedCurrentRitual = RitualRecipe.find(this.m_9236_(), this.getRitualName());
        }
        return this.__cachedCurrentRitual;
    }

    public RitualState getState() {
        return RitualState.values()[(Byte)this.f_19804_.m_135370_(RITUAL_STATE)];
    }

    private void setState(RitualState state) {
        this.f_19804_.m_135381_(RITUAL_STATE, (Object)((byte)state.ordinal()));
        if (state == RitualState.COLLECTING_REAGENTS) {
            this.worldTimeAtReagentCollectStart = this.m_9236_().m_46467_();
        }
    }

    private int getShutdownAge() {
        return (Integer)this.f_19804_.m_135370_(SHUTDOWN_AGE);
    }

    private void setShutdownAge(int shutdown_age) {
        this.f_19804_.m_135381_(SHUTDOWN_AGE, (Object)shutdown_age);
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        speed = Mth.m_14036_((float)speed, (float)0.1f, (float)2.0f);
        this.f_19804_.m_135381_(SPEED, (Object)Float.valueOf(speed));
    }

    public void preConsumePatterns(List<ResourceLocation> patterns) {
        this.requiredPatterns.removeAll(patterns);
    }

    public void setCasterUUID(UUID casterUUID) {
        if (casterUUID != null) {
            this.f_19804_.m_135381_(CASTER_UUID, (Object)casterUUID.toString());
        } else {
            ManaAndArtifice.LOGGER.error("Received null UUID for ritual caster.  Some effects may not apply!");
        }
    }

    public UUID getCasterUUID() {
        try {
            UUID uUID = UUID.fromString((String)this.f_19804_.m_135370_(CASTER_UUID));
            return uUID;
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return null;
    }

    @Nullable
    private Player getCaster() {
        if (this.getCasterUUID() == null) {
            return null;
        }
        return this.m_9236_().m_46003_(this.getCasterUUID());
    }

    private int getPowerupTime() {
        return (int)Math.ceil((float)(this.getRitualData((byte)2).size() * 13 + 20) * this.getSpeed());
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(3.0);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getStageTicks() {
        return this.stageTicks;
    }

    public void setStageTicks(int stageTicks) {
        this.stageTicks = stageTicks;
    }

    public void setRequestedPattern(String pattern) {
        this.f_19804_.m_135381_(REQUESTED_PATTERN, (Object)pattern);
    }

    public ManaweavingPattern getRequestedPattern() {
        String patternID = (String)this.f_19804_.m_135370_(REQUESTED_PATTERN);
        return ManaweavingPatternHelper.GetManaweavingRecipe(this.m_9236_(), new ResourceLocation(patternID));
    }

    public void setForceConsumeReagents(boolean force) {
        this.forceCollectAllReagents = force;
    }

    private NonNullList<RitualEffect> getHandlers() {
        if (this.__cachedRitualHandlers == null) {
            this.__cachedRitualHandlers = NonNullList.m_122779_();
            Registries.RitualEffect.get().getValues().forEach(eff -> {
                if (eff.handlesRitual(this.getRitualName())) {
                    this.__cachedRitualHandlers.add(eff);
                }
            });
        }
        return this.__cachedRitualHandlers;
    }

    public NonNullList<ItemStack> getCollectedReagents() {
        NonNullList reagents = NonNullList.m_122779_();
        reagents.addAll((Collection)this.collectedReagents.stream().map(e -> (ItemStack)e.getSecond()).collect(Collectors.toList()));
        return reagents;
    }

    public NonNullList<Pair<BlockPos, ItemStack>> getCollectedReagentsByLocation() {
        return this.collectedReagents;
    }

    public NonNullList<ResourceLocation> getCollectedPatterns() {
        NonNullList patterns = NonNullList.m_122779_();
        patterns.addAll(this.collectedPatterns);
        return patterns;
    }

    public NonNullList<ResourceLocation> getRequiredPatterns() {
        return this.requiredPatterns;
    }

    public void m_6075_() {
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_6043_() {
    }

    public boolean canUpdate() {
        return true;
    }

    public static enum RitualState {
        GUIDING_REAGENT_PLACEMENT,
        POWERING_UP,
        COLLECTING_REAGENTS,
        COLLECTING_PATTERNS,
        COLLAPSING,
        PROCESSING_RITUAL,
        COMPLETING,
        DEAD;

    }
}

