/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery;

import com.mna.gui.containers.providers.NamedRift;
import com.mna.tools.GuiTools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class Rift
extends Entity
implements IEntityAdditionalSpawnData {
    private static final String KEY_AGE = "age";
    private static final String KEY_IS_ENDERCHEST = "isEnderchest";
    private int age = 0;
    private boolean isEnderChest = false;

    public Rift(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public void m_8119_() {
        this.setAge(this.getAge() + 1);
        if (this.getAge() >= 200 && !this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!player.m_9236_().m_5776_()) {
            if (this.isEnderChest) {
                GuiTools.openEnderChest(player);
            } else {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new NamedRift());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6075_() {
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128441_(KEY_AGE)) {
            this.setAge(compound.m_128451_(KEY_AGE));
        }
        if (compound.m_128441_(KEY_IS_ENDERCHEST)) {
            this.setEnderChest(compound.m_128471_(KEY_IS_ENDERCHEST));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(KEY_AGE, this.getAge());
        compound.m_128379_(KEY_IS_ENDERCHEST, this.isEnderChest);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return true;
    }

    public int getAge() {
        return this.age;
    }

    public boolean getIsEnderChest() {
        return this.isEnderChest;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setEnderChest(boolean enderChest) {
        this.isEnderChest = enderChest;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.age);
        buffer.writeBoolean(this.isEnderChest);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.age = additionalData.readInt();
        this.isEnderChest = additionalData.readBoolean();
    }
}

