/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.ISpellInteractibleBlock;
import com.mna.api.entities.ISpellInteractibleEntity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedSpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.entities.EntityInit;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.mutable.MutableInt;

public class Smite
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<CompoundTag> SPELL_RECIPE = SynchedEntityData.m_135353_(Smite.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private static final Vec3 DOWN = new Vec3(0.0, -1.0, 0.0);
    private List<Entity> hitEntities;
    public UUID shootingEntity;
    private int ticksInAir;
    private ArrayList<Affinity> affinities;
    private SpellRecipe _cachedSpellRecipe = null;
    private float bonusDamagePctFromHeight = 0.0f;
    private HashMap<Affinity, BiConsumer<Integer, Float>> particleFunctions = new HashMap();

    public Smite(EntityType<? extends Smite> type, Level world) {
        super((EntityType)EntityInit.SMITE_PROJECTILE.get(), world);
        this.m_20242_(true);
        this.particleFunctions.put(Affinity.ARCANE, this::spawnArcaneParticles);
        this.particleFunctions.put(Affinity.ENDER, this::spawnEnderParticles);
        this.particleFunctions.put(Affinity.FIRE, this::spawnFireParticles);
        this.particleFunctions.put(Affinity.HELLFIRE, this::spawnHellfireParticles);
        this.particleFunctions.put(Affinity.LIGHTNING, this::spawnLightningParticles);
        this.particleFunctions.put(Affinity.WATER, this::spawnWaterParticles);
        this.particleFunctions.put(Affinity.ICE, this::spawnFrostParticles);
        this.particleFunctions.put(Affinity.WIND, this::spawnWindParticles);
        this.particleFunctions.put(Affinity.EARTH, this::spawnEarthParticles);
        this.particleFunctions.put(Affinity.BLOOD, this::spawnBloodParticles);
    }

    public Smite(Level worldIn, Vec3 position, CompoundTag recipe, LivingEntity shooter) {
        super((EntityType)EntityInit.SMITE_PROJECTILE.get(), worldIn);
        this.m_6034_(position.m_7096_(), position.m_7098_(), position.m_7094_());
        this.m_20242_(true);
        this.m_5602_((Entity)shooter);
        this.setSpellRecipe(recipe);
    }

    public ArrayList<Affinity> getAffinity() {
        if (this.affinities == null) {
            SpellRecipe recipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE));
            this.affinities = new ArrayList<Affinity>(recipe.getAffinity().keySet());
        }
        return this.affinities;
    }

    public void setBonusDamagePctFromHeight(float bonus) {
        this.bonusDamagePctFromHeight = bonus;
    }

    public void spawnParticles(int particleCount, float partialTick) {
        Affinity aff;
        if (this.affinities == null) {
            SpellRecipe recipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE));
            this.affinities = new ArrayList<Affinity>(recipe.getAffinity().keySet());
        }
        if (this.affinities != null && this.particleFunctions.containsKey((Object)(aff = this.affinities.get((int)(Math.random() * (double)this.affinities.size()))))) {
            this.particleFunctions.get((Object)aff).accept(particleCount, Float.valueOf(partialTick));
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPELL_RECIPE, (Object)new CompoundTag());
    }

    public void setSpellRecipe(CompoundTag recipe) {
        this.f_19804_.m_135381_(SPELL_RECIPE, (Object)recipe);
    }

    protected void entityHit(Entity entity) {
        this.applyEffect(this.m_20183_(), this.m_6350_(), entity);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected SpellRecipe getRecipe() {
        if (this._cachedSpellRecipe == null) {
            this._cachedSpellRecipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE));
        }
        return this._cachedSpellRecipe;
    }

    protected void blockHit(BlockPos pos, Direction face) {
        this.applyEffect(pos, Direction.DOWN, null);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    private void applyEffect(BlockPos impactPoint, Direction face, @Nullable Entity hitEntity) {
        if (this.getShooterAsLiving() == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        SpellSource source = new SpellSource(this.getShooterAsLiving(), InteractionHand.MAIN_HAND);
        SpellRecipe recipe = this.getRecipe();
        if (recipe.isValid() && !this.m_9236_().m_5776_()) {
            int vRadius;
            BlockState state = this.m_9236_().m_8055_(impactPoint);
            if (state.m_60734_() instanceof ISpellInteractibleBlock && ((ISpellInteractibleBlock)state.m_60734_()).onHitBySpell(this.m_9236_(), impactPoint, recipe)) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (hitEntity != null && hitEntity instanceof ISpellInteractibleEntity && ((ISpellInteractibleEntity)hitEntity).onShapeTarget(recipe, source)) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            float spellRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
            float spellVerticalRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.HEIGHT);
            SpellContext context = new SpellContext(this.m_9236_(), recipe, (Entity)this);
            int fallTicks = Math.min(Math.max(this.ticksInAir - 2, 0), 20);
            float dmgBoost = (float)fallTicks * 0.03f * (1.0f + this.bonusDamagePctFromHeight);
            recipe.iterateComponents(c -> {
                if (((SpellEffect)c.getPart()).getModifiableAttributes().stream().anyMatch(a -> a.getAttribute() == Attribute.DAMAGE)) {
                    float base = c.getValue(Attribute.DAMAGE);
                    c.setValue(Attribute.DAMAGE, base + base * dmgBoost);
                }
            });
            int radius = (int)Math.floor(spellRadius);
            if (radius < 0) {
                radius = 0;
            }
            if ((vRadius = (int)Math.floor(spellVerticalRadius) - 1) < 0) {
                vRadius = 0;
            }
            if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
                int delay = 1;
                if (radius > 0 || hitEntity == null) {
                    Spiral s = new Spiral(radius * 2, radius * 2);
                    for (Point p : s.spiral()) {
                        for (int j = vRadius; j >= -vRadius; --j) {
                            BlockPos adjusted = impactPoint.m_7918_(p.x, j, p.y);
                            int loopDelay = delay;
                            recipe.iterateComponents(c -> {
                                if (((SpellEffect)c.getPart()).targetsBlocks() && !context.hasBlockBeenAffected((SpellEffect)c.getPart(), adjusted)) {
                                    DelayedEventQueue.pushEvent(this.m_9236_(), new TimedDelayedSpellEffect("smiteLoop", (int)((float)loopDelay + c.getValue(Attribute.DELAY) * 20.0f), source, new SpellTarget(adjusted, face), (IModifiedSpellPart<SpellEffect>)c, context, false));
                                }
                            });
                        }
                        ++delay;
                    }
                }
            }
            if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
                List targets = this.m_9236_().m_6249_((Entity)this, new AABB(impactPoint).m_82363_((double)spellRadius, (double)spellVerticalRadius, (double)spellRadius).m_82363_((double)(-spellRadius), 0.0, (double)(-spellRadius)), e -> !e.m_20147_());
                if (hitEntity != null && !targets.contains(hitEntity)) {
                    targets.add(hitEntity);
                }
                for (Entity target : targets) {
                    if (target == null || target == this.getShooterAsLiving()) continue;
                    SpellCaster.ApplyComponents(recipe, source, new SpellTarget(target).doNotOffsetFace(), context);
                }
            }
            switch (recipe.getHighestAffinity()) {
                case ARCANE: {
                    this.m_9236_().m_5594_(null, impactPoint, SFX.Spell.Impact.AoE.ARCANE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.m_9236_().m_5594_(null, impactPoint, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case EARTH: {
                    this.m_9236_().m_5594_(null, impactPoint, SFX.Spell.Impact.AoE.EARTH, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case ENDER: {
                    this.m_9236_().m_5594_(null, impactPoint, SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case FIRE: 
                case HELLFIRE: {
                    this.m_9236_().m_5594_(null, impactPoint, SFX.Spell.Impact.AoE.EARTH, SoundSource.PLAYERS, 0.5f, 1.0f);
                    this.m_9236_().m_5594_(null, impactPoint, SoundEvents.f_11874_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case LIGHTNING: {
                    break;
                }
                case WATER: {
                    this.m_9236_().m_5594_(null, impactPoint, SoundEvents.f_12278_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case ICE: {
                    this.m_9236_().m_5594_(null, impactPoint, SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    this.m_9236_().m_5594_(null, impactPoint, SoundEvents.f_12482_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
                case WIND: {
                    this.m_9236_().m_5594_(null, impactPoint, SFX.Spell.Impact.AoE.WIND, SoundSource.PLAYERS, 1.0f, 1.0f);
                    break;
                }
            }
        }
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        HitResult.Type raytraceresult$type = raytraceResultIn.m_6662_();
        if (raytraceresult$type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)raytraceResultIn);
        } else if (raytraceresult$type == HitResult.Type.BLOCK) {
            BlockHitResult blockraytraceresult = (BlockHitResult)raytraceResultIn;
            this.blockHit(blockraytraceresult.m_82425_(), blockraytraceresult.m_82434_());
        }
    }

    public void onRemovedFromWorld() {
        SpellRecipe recipe;
        super.onRemovedFromWorld();
        if (this.m_9236_().m_5776_() && (recipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE))).isValid()) {
            this.spawnParticleBurst("", Float.valueOf(((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS)));
        }
    }

    private LivingEntity getShooterAsLiving() {
        Entity shooter = this.getShooter();
        if (shooter != null && shooter instanceof LivingEntity) {
            return (LivingEntity)shooter;
        }
        return null;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6097_() {
        return false;
    }

    protected float m_6380_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.0f;
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
    }

    @Nullable
    public Entity getShooter() {
        return this.shootingEntity != null && this.m_9236_() instanceof ServerLevel ? ((ServerLevel)this.m_9236_()).m_8791_(this.shootingEntity) : null;
    }

    public void m_5602_(@Nullable Entity entityIn) {
        this.shootingEntity = entityIn == null ? null : entityIn.m_20148_();
    }

    public void m_7380_(CompoundTag compound) {
        if (this.shootingEntity != null) {
            compound.m_128362_("OwnerUUID", this.shootingEntity);
        }
        compound.m_128350_("bonusFallDamagePct", this.bonusDamagePctFromHeight);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128403_("OwnerUUID")) {
            this.shootingEntity = compound.m_128342_("OwnerUUID");
        }
        if (compound.m_128441_("bonusFallDamagePct")) {
            this.bonusDamagePctFromHeight = compound.m_128457_("bonusFallDamagePct");
        }
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_20191_().m_82369_(DOWN).m_82400_(1.0), p_213871_1_ -> !p_213871_1_.m_5833_() && p_213871_1_.m_6084_() && p_213871_1_.m_6087_() && (p_213871_1_ != this.getShooter() || this.ticksInAir >= 5));
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity entity = p_213868_1_.m_82443_();
        this.entityHit(entity);
        if (!entity.m_6084_() && this.hitEntities != null) {
            this.hitEntities.add(entity);
        }
    }

    public void m_8119_() {
        SpellRecipe recipe;
        if (this.f_19797_ == 3 && !this.m_9236_().m_5776_() && (recipe = SpellRecipe.fromNBT((CompoundTag)this.f_19804_.m_135370_(SPELL_RECIPE))) != null && recipe.isValid() && recipe.getHighestAffinity() == Affinity.LIGHTNING) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SFX.Spell.Impact.AoE.LIGHTNING, SoundSource.PLAYERS, 0.5f, (float)(0.6 + Math.random() * 0.8));
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        ++this.ticksInAir;
        Vec3 Vector3d2 = this.m_20182_();
        Vec3 Vector3d3 = Vector3d2.m_82549_(DOWN);
        BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(Vector3d2, Vector3d3, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            Vector3d3 = raytraceresult.m_82450_();
        }
        while (this.m_6084_()) {
            EntityHitResult entityraytraceresult = this.rayTraceEntities(Vector3d2, Vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                Entity entity1 = this.getShooter();
                if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                }
            }
            if (raytraceresult != null && raytraceresult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.m_6532_((HitResult)raytraceresult);
                this.f_19812_ = true;
            }
            if (entityraytraceresult == null) break;
            raytraceresult = null;
        }
        float speedFactor = 0.99f;
        if (this.m_20069_()) {
            if (this.affinities.contains((Object)Affinity.FIRE)) {
                if (!this.m_9236_().m_5776_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                return;
            }
            for (int j = 0; j < 4; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            if (!this.affinities.contains((Object)Affinity.WATER)) {
                speedFactor = 0.6f;
            }
        }
        Vec3 newPos = this.m_20182_().m_82549_(DOWN.m_82490_((double)speedFactor));
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.m_20101_();
        if (this.f_19797_ > 200) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * Smite.m_20150_()) * d0;
    }

    public final int getOverrideColor() {
        Entity caster = this.getShooter();
        SpellRecipe recipe = this.getRecipe();
        if (caster == null || recipe == null) {
            return -1;
        }
        MutableInt color = new MutableInt(-1);
        caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> color.setValue(m.getParticleColorOverride()));
        if (color.getValue() == -1) {
            color.setValue(recipe.getParticleColorOverride());
        }
        return color.getValue();
    }

    public void spawnParticleBurst(String identifier, Float radius) {
        if (this.affinities == null || this.affinities.size() == 0) {
            return;
        }
        MAParticleType particle = null;
        int count = 180;
        double angleRads = 0.0;
        double step = Math.PI * 2 / (double)count;
        block12: for (int i = 0; i < count; ++i) {
            Vec3 vel;
            Vec3 dir;
            angleRads += step;
            Affinity affinity = this.affinities.get((int)Math.random() * this.affinities.size());
            switch (affinity) {
                case ARCANE: {
                    particle = (MAParticleType)((Object)ParticleInit.ARCANE.get());
                    break;
                }
                case EARTH: {
                    particle = (MAParticleType)((Object)ParticleInit.DUST.get());
                    break;
                }
                case ENDER: {
                    dir = new Vec3(Math.cos(angleRads), Math.random() * 0.1, Math.sin(angleRads)).m_82541_().m_82490_((double)(radius.floatValue() * 5.0f)).m_82549_(this.m_20182_());
                    this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (Entity)this.getShooterAsLiving()), dir.f_82479_, dir.f_82480_, dir.f_82481_, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
                    continue block12;
                }
                case FIRE: {
                    particle = (MAParticleType)((Object)ParticleInit.FLAME.get());
                    break;
                }
                case HELLFIRE: {
                    particle = (MAParticleType)((Object)ParticleInit.HELLFIRE.get());
                    break;
                }
                case LIGHTNING: {
                    dir = new Vec3(Math.cos(angleRads), (double)0.1f, Math.sin(angleRads)).m_82541_().m_82490_((double)(radius.floatValue() * 5.0f)).m_82549_(this.m_20182_());
                    this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)this.getShooterAsLiving()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), dir.f_82479_, dir.f_82480_ + 1.0, dir.f_82481_);
                    i += count / 10;
                    angleRads += step * (double)(count / 10);
                    continue block12;
                }
                case WATER: {
                    particle = (MAParticleType)((Object)ParticleInit.WATER.get());
                    break;
                }
                case ICE: {
                    particle = (MAParticleType)((Object)ParticleInit.FROST.get());
                    break;
                }
                case WIND: {
                    dir = new Vec3(Math.cos(angleRads), Math.random() * 0.1, Math.sin(angleRads)).m_82541_();
                    vel = dir.m_82490_((double)(0.3f * radius.floatValue()));
                    dir = dir.m_82490_(0.2);
                    this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_VELOCITY.get())).setScale(0.2f).setColor(10, 10, 10), (Entity)this.getShooterAsLiving()), this.m_20185_() + dir.f_82479_, this.m_20186_() + Math.random(), this.m_20189_() + dir.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
                    break;
                }
                case BLOOD: {
                    dir = new Vec3(Math.cos(angleRads), Math.random() * 0.2, Math.sin(angleRads)).m_82541_().m_82490_((double)(radius.floatValue() * 0.15f) + 0.05 * Math.random());
                    this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setGravity(0.05f).setMaxAge(16).setPhysics(true), (Entity)this.getShooterAsLiving()), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), dir.f_82479_, dir.f_82480_, dir.f_82481_);
                    continue block12;
                }
                default: {
                    particle = (MAParticleType)((Object)ParticleInit.SPARKLE_GRAVITY.get());
                }
            }
            if (particle == null) continue;
            dir = new Vec3(Math.cos(angleRads), Math.random() * 0.1, Math.sin(angleRads)).m_82541_();
            vel = dir.m_82490_((double)(0.3f * radius.floatValue()));
            dir = dir.m_82490_(0.2);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType(particle), (Entity)this.getShooterAsLiving()), this.m_20185_() + dir.f_82479_, this.m_20186_() + Math.random(), this.m_20189_() + dir.f_82481_, vel.f_82479_, vel.f_82480_, vel.f_82481_);
        }
    }

    public void spawnArcaneParticles(int particleCount, float partialTick) {
        for (int j = 0; j < particleCount; ++j) {
            Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_((double)partialTick * Math.random()));
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE.get())), (Entity)this.getShooterAsLiving()), pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public void spawnEnderParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_((double)partialTick * Math.random()));
        float particle_spread = 0.5f;
        for (int j = 0; j < particleCount; ++j) {
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER.get())), (Entity)this.getShooterAsLiving()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + -2.0, pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    public void spawnEarthParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_((double)partialTick * Math.random()));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, -0.5, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), (Entity)this.getShooterAsLiving()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public void spawnWaterParticles(int particleCount, float partialTick) {
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_(Math.random()));
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.WATER.get())), (Entity)this.getShooterAsLiving()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public void spawnBloodParticles(int particleCount, float partialTick) {
        float particle_spread = 0.25f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_(Math.random()));
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, 0.0, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setGravity(0.05f).setMaxAge(16).setPhysics(true), (Entity)this.getShooterAsLiving()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public void spawnFireParticles(int particleCount, float partialTick) {
        for (int j = 0; j < particleCount; ++j) {
            Vec3 pos = this.m_20182_().m_82520_(0.0, -Math.random(), 0.0);
            Vec3 velocity = new Vec3(0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FLAME.get())), (Entity)this.getShooterAsLiving()), pos.f_82479_, pos.f_82480_, pos.f_82481_, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public void spawnHellfireParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_((double)partialTick * Math.random()));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.HELLFIRE.get())), (Entity)this.getShooterAsLiving()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public void spawnWindParticles(int particleCount, float partialTick) {
        for (int i = 0; i < particleCount; ++i) {
            Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_((double)partialTick * Math.random()));
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), (Entity)this.getShooterAsLiving()), pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)0.6f * Math.random() + (double)0.1f, (double)-0.2f, 0.25);
        }
    }

    public void spawnFrostParticles(int particleCount, float partialTick) {
        Vec3 pos = this.m_20182_().m_82549_(DOWN.m_82490_((double)partialTick * Math.random()));
        float particle_spread = 0.05f;
        for (int j = 0; j < particleCount; ++j) {
            Vec3 velocity = new Vec3((double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f, (double)-0.05f + Math.random() * (double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.FROST.get())), (Entity)this.getShooterAsLiving()), pos.f_82479_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82480_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), pos.f_82481_ + ((double)(-particle_spread) + Math.random() * (double)particle_spread * 2.0), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    public void spawnLightningParticles(int particleCount, float partialTick) {
        BlockPos projected_impact = BlockPos.m_274446_((Position)this.m_20182_());
        for (int count = 0; this.m_9236_().m_46859_(projected_impact) && count < 30; ++count) {
            projected_impact = projected_impact.m_7495_();
        }
        this.m_9236_().m_7106_((ParticleOptions)this.getRecipe().colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)this.getShooterAsLiving()), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), (double)projected_impact.m_123342_(), this.m_20189_());
    }

    private static class Spiral {
        private static final Point ORIGIN = new Point(0, 0);
        private final int width;
        private final int height;
        private Point point;
        private Direction direction = Direction.E;
        private List<Point> list = new ArrayList<Point>();

        public Spiral(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public List<Point> spiral() {
            this.point = ORIGIN;
            int steps = 1;
            while (this.list.size() < this.width * this.height) {
                this.advance(steps);
                this.advance(steps);
                ++steps;
            }
            return this.list;
        }

        private void advance(int n) {
            for (int i = 0; i < n; ++i) {
                if (this.inBounds(this.point)) {
                    this.list.add(this.point);
                }
                this.point = this.direction.advance(this.point);
            }
            this.direction = this.direction.next();
        }

        private boolean inBounds(Point p) {
            return Spiral.between(-this.width / 2, this.width / 2, p.x) && Spiral.between(-this.height / 2, this.height / 2, p.y);
        }

        private static boolean between(int low, int high, int n) {
            return low <= n && n <= high;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum Direction {
            E(1, 0){

                @Override
                Direction next() {
                    return N;
                }
            }
            ,
            N(0, 1){

                @Override
                Direction next() {
                    return W;
                }
            }
            ,
            W(-1, 0){

                @Override
                Direction next() {
                    return S;
                }
            }
            ,
            S(0, -1){

                @Override
                Direction next() {
                    return E;
                }
            };

            private int dx;
            private int dy;

            Point advance(Point point) {
                return new Point(point.x + this.dx, point.y + this.dy);
            }

            abstract Direction next();

            private Direction(int dx, int dy) {
                this.dx = dx;
                this.dy = dy;
            }
        }
    }
}

