/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.base.ChanneledSpellEntity;
import com.mna.particles.types.movers.ParticleOrbitMover;
import com.mna.particles.types.movers.ParticleVelocityMover;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.ModifiedSpellPart;
import com.mna.spells.crafting.SpellRecipe;
import com.mna.tools.math.MathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellFissure
extends ChanneledSpellEntity {
    public SpellFissure(EntityType<? extends SpellFissure> type, Level world) {
        super(type, world);
    }

    public SpellFissure(LivingEntity caster, ISpellDefinition spell, Level world) {
        super((EntityType<? extends ChanneledSpellEntity>)((EntityType)EntityInit.SPELL_FISSURE.get()), caster, spell, world);
        this.m_6034_(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
    }

    public float getStepHeight() {
        return 2.0f;
    }

    @Override
    public void m_8119_() {
        SpellRecipe recipe = this.getSpell();
        if (!this.m_9236_().m_5776_() && !recipe.isValid()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        LivingEntity caster = this.getCaster();
        if (caster == null || !caster.m_6084_() || !caster.m_9236_().m_46472_().equals(this.m_9236_().m_46472_())) {
            if (!this.m_9236_().m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ >= this.getMaxAge()) {
            if (!this.m_9236_().m_5776_()) {
                this.applyEffect(caster.m_21211_(), recipe, caster, (ServerLevel)this.m_9236_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (caster.m_21212_() <= 0 || caster.m_21211_().m_41619_()) {
            if (!this.m_9236_().m_5776_()) {
                this.applyEffect(caster.m_21211_(), recipe, caster, (ServerLevel)this.m_9236_());
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (!this.snapToGround()) {
            return;
        }
        this.updateRotation(caster);
        this.m_6853_(true);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles();
            this.playSounds();
        }
    }

    private boolean snapToGround() {
        BlockPos curPos = this.m_20183_();
        int count = 0;
        if (this.m_9236_().m_46859_(curPos)) {
            do {
                ++count;
                curPos = curPos.m_7495_();
                if (this.m_9236_().m_46859_(curPos)) continue;
                this.m_6034_(this.m_20185_(), curPos.m_123342_() + 1, this.m_20189_());
                return true;
            } while (count < 3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return false;
        }
        return true;
    }

    private void updateRotation(LivingEntity caster) {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        Vec3 source = caster.m_146892_();
        Vec3 target = caster.m_146892_().m_82549_(caster.m_20156_().m_82541_().m_82490_(64.0));
        ClipContext clipContext = new ClipContext(source, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)caster);
        BlockHitResult bhr = this.m_9236_().m_45547_(clipContext);
        if (bhr.m_6662_() == HitResult.Type.BLOCK) {
            this.m_7618_(EntityAnchorArgument.Anchor.FEET, bhr.m_82450_());
        } else {
            this.m_19884_(caster.m_146909_(), caster.m_146908_());
        }
        this.m_20256_(this.m_20156_().m_82541_().m_82490_((double)this.getShapeAttribute(Attribute.SPEED)));
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, LivingEntity caster, ServerLevel world) {
        float spellRadius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
        SpellContext context = new SpellContext(this.m_9236_(), recipe, this);
        SpellSource source = new SpellSource(caster, InteractionHand.MAIN_HAND);
        Direction face = Direction.UP;
        HashMap<SpellEffect, ComponentApplicationResult> results = new HashMap<SpellEffect, ComponentApplicationResult>();
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
            int radius = (int)Math.floor(spellRadius);
            if (radius < 0) {
                radius = 0;
            }
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        BlockPos adjusted = this.m_20183_().m_7495_().m_7918_(i, j, k);
                        HashMap<SpellEffect, ComponentApplicationResult> loopRes = SpellCaster.ApplyComponents(recipe, source, new SpellTarget(adjusted, face).doNotOffsetFace(), context);
                        SpellCaster.mergeComponentResults(results, loopRes);
                    }
                }
            }
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
            float radius = ((ModifiedSpellPart)recipe.getShape()).getValue(Attribute.RADIUS);
            List targets = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_((double)radius), e -> !e.m_20147_());
            for (Entity target : targets) {
                if (target == null || target == caster) continue;
                HashMap<SpellEffect, ComponentApplicationResult> loopRes = SpellCaster.ApplyComponents(recipe, source, new SpellTarget(target), context);
                SpellCaster.mergeComponentResults(results, loopRes);
            }
        }
        if (results.size() > 0) {
            List<SpellEffect> appliedEffects = results.entrySet().stream().map(e -> ((ComponentApplicationResult)((Object)((Object)e.getValue()))).is_success ? (SpellEffect)e.getKey() : null).filter(e -> e != null).collect(Collectors.toList());
            SpellCaster.spawnClientFX(this.m_9236_(), this.m_20182_(), new Vec3(0.0, 1.0, 0.0), source, appliedEffects);
        }
    }

    @Override
    protected void spawnParticles() {
        block3: {
            Vec3 pos;
            BlockPos belowPos;
            block4: {
                super.spawnParticles();
                belowPos = this.m_20183_().m_7495_();
                if (this.m_9236_().m_46859_(belowPos)) break block3;
                pos = this.m_20182_();
                FluidState flState = this.m_9236_().m_6425_(belowPos);
                if (flState.m_76178_()) break block4;
                ParticleOptions particle = flState.m_76189_();
                if (particle == null) break block3;
                for (int i = 0; i < 2; ++i) {
                    this.m_9236_().m_7106_(particle, pos.f_82479_ - 1.0 + 2.0 * Math.random(), pos.f_82480_, pos.f_82481_ - 1.0 + 2.0 * Math.random(), 0.0, 0.0, 0.0);
                }
                break block3;
            }
            BlockState below = this.m_9236_().m_8055_(belowPos);
            ItemStack belowStack = new ItemStack((ItemLike)below.m_60734_());
            if (belowStack.m_41619_()) {
                belowStack = new ItemStack((ItemLike)Blocks.f_50069_);
            }
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ITEM.get())).setStack(belowStack).setScale(0.15f).setMover(new ParticleVelocityMover(0.0, 0.2f, 0.0, true)).setGravity(0.05f), pos.f_82479_ - 1.0 + 2.0 * Math.random(), pos.f_82480_, pos.f_82481_ - 1.0 + 2.0 * Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void spawnAirParticles(SpellRecipe recipe) {
        Vec3 pos = this.m_20182_();
        for (int i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setColor(10, 10, 10).setScale(0.1f), (Entity)this.getCaster()), pos.f_82479_ - 1.0 + 2.0 * Math.random(), pos.f_82480_, pos.f_82481_ - 1.0 + 2.0 * Math.random(), (double)0.1f, (double)0.1f, 1.25);
        }
    }

    @Override
    protected void spawnEarthParticles(SpellRecipe recipe) {
        Vec3 pos = this.m_20182_();
        for (int i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DUST.get())), (Entity)this.getCaster()).setScale(0.1f).setGravity(0.05f), pos.f_82479_ - 1.0 + 2.0 * Math.random(), pos.f_82480_, pos.f_82481_ - 1.0 + 2.0 * Math.random(), 0.0, (double)0.1f, 0.0);
        }
    }

    @Override
    protected void spawnFireParticles(SpellRecipe recipe, boolean hellfire, boolean lightning) {
        Vec3 pos = this.m_20182_();
        for (int i = 0; i < 5; ++i) {
            Vec3 pStart;
            if (hellfire) {
                pStart = new Vec3(pos.f_82479_ - 1.0 + 2.0 * Math.random(), pos.f_82480_, pos.f_82481_ - 1.0 + 2.0 * Math.random());
                this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType(((MAParticleType)((Object)ParticleInit.HELLFIRE.get())).setScale(0.1f).setMover(new ParticleOrbitMover(pStart.f_82479_, pStart.f_82480_, pStart.f_82481_, 0.1f, 0.1f, 1.25))), (Entity)this.getCaster()), pStart.f_82479_, pStart.f_82480_, pStart.f_82481_, 0.0, 0.0, 0.0);
                continue;
            }
            if (lightning) {
                pStart = new Vec3(pos.f_82479_ - 1.0 + 2.0 * Math.random(), pos.f_82480_, pos.f_82481_ - 1.0 + 2.0 * Math.random());
                Vec3 pEnd = pStart.m_82520_(0.0, Math.random() + 0.5, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.LIGHTNING_BOLT.get())), (Entity)this.getCaster()), pStart.f_82479_, pStart.f_82480_, pStart.f_82481_, pEnd.f_82479_, pEnd.f_82480_, pEnd.f_82481_);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType(((MAParticleType)((Object)ParticleInit.FLAME_ORBIT.get())).setScale(0.1f)), (Entity)this.getCaster()), pos.f_82479_ - 1.0 + 2.0 * Math.random(), pos.f_82480_, pos.f_82481_ - 1.0 + 2.0 * Math.random(), (double)0.1f, (double)0.1f, 1.25);
        }
    }

    @Override
    protected void spawnWaterParticles(SpellRecipe recipe, boolean ice) {
        Vec3 pos = this.m_20182_();
        for (int i = 0; i < 5; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)(ice ? (ParticleType)ParticleInit.FROST.get() : (ParticleType)ParticleInit.WATER.get())), (Entity)this.getCaster()), pos.f_82479_ - 0.5 + Math.random(), pos.f_82480_ + Math.random() * 0.1, pos.f_82481_ - 0.5 + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void spawnEnderParticles(SpellRecipe recipe, boolean blood) {
        Vec3 pos = this.m_20182_();
        for (int i = 0; i < 5; ++i) {
            if (blood) {
                Vec3 velocity = new Vec3((double)MathUtils.RandomBetween(-0.05f, 0.05f), (double)MathUtils.RandomBetween(0.15f, 0.25f), (double)MathUtils.RandomBetween(-0.05f, 0.05f));
                this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setPhysics(true).setGravity(0.05f), (Entity)this.getCaster()), pos.f_82479_ - 0.5 + Math.random(), pos.f_82480_ + Math.random() * 0.1, pos.f_82481_ - 0.5 + Math.random(), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                continue;
            }
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ENDER_VELOCITY.get())), (Entity)this.getCaster()), pos.f_82479_ - 0.5 + Math.random(), pos.f_82480_ + Math.random() * 0.1, pos.f_82481_ - 0.5 + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void spawnArcaneParticles(SpellRecipe recipe) {
        Vec3 pos = this.m_20182_();
        for (int i = 0; i < 2; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)recipe.colorParticle(new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.ARCANE_MAGELIGHT.get())), (Entity)this.getCaster()), pos.f_82479_ - 0.5 + Math.random(), pos.f_82480_ + Math.random() * 0.1, pos.f_82481_ - 0.5 + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

