/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.sorcery.targeting;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.targeting.SpellWall;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpellWave
extends SpellWall {
    public SpellWave(EntityType<? extends SpellWave> entityTypeIn, Level worldIn) {
        super((EntityType<? extends SpellWall>)entityTypeIn, worldIn);
    }

    public SpellWave(LivingEntity caster, ISpellDefinition spell, Level world, boolean axisLock) {
        super((EntityType<? extends SpellWall>)((EntityType)EntityInit.SPELL_WAVE.get()), caster, spell, world, axisLock);
        this.m_6034_(caster.m_20185_(), caster.m_20186_(), caster.m_20189_());
        if (axisLock) {
            Vec3 motion = Vec3.m_82498_((float)0.0f, (float)caster.m_6350_().m_122435_()).m_82541_().m_82490_((double)this.getShapeAttribute(Attribute.SPEED));
            this.m_20256_(motion);
            if (caster.m_6047_()) {
                this.m_146884_(this.m_20182_().m_82549_(motion.m_82541_()).m_82520_(0.0, -0.5, 0.0));
            } else {
                this.m_146884_(this.m_20182_().m_82549_(motion.m_82541_()));
            }
        } else {
            float x = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float y = -Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            float z = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180)));
            Vec3 motion = new Vec3((double)x, (double)y, (double)z).m_82541_().m_82490_((double)this.getShapeAttribute(Attribute.SPEED));
            this.m_20256_(motion);
        }
    }

    @Override
    public void m_8119_() {
        this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
        super.m_8119_();
    }

    @Override
    protected boolean actAsChanneled() {
        return true;
    }

    @Override
    protected void applyEffect(ItemStack stack, SpellRecipe recipe, LivingEntity caster, ServerLevel world) {
        float radius_h = this.getShapeAttributeByAge(Attribute.WIDTH);
        float radius_v = this.getShapeAttributeByAge(Attribute.HEIGHT);
        SpellSource source = new SpellSource(caster, caster.m_7655_());
        SpellContext context = new SpellContext((Level)world, recipe, this);
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsEntities())) {
            for (Entity e : this.targetEntities(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(e), context);
            }
        }
        if (recipe.getComponents().stream().anyMatch(c -> ((SpellEffect)c.getPart()).targetsBlocks())) {
            for (BlockPos p : this.targetBlocks(radius_h, radius_v)) {
                SpellCaster.ApplyComponents(recipe, source, new SpellTarget(p, null), context);
            }
        }
    }

    @Override
    protected void spawnAirParticles(SpellRecipe recipe) {
        Vec3 jitter = new Vec3((double)-0.1f + Math.random() * (double)0.2f, 0.0, (double)-0.1f + Math.random() * (double)0.2f);
        this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.AIR_VELOCITY.get()), this.m_20184_().m_82490_(0.75).m_82549_(jitter), p -> p.setScale(0.2f).setColor(10, 10, 10));
    }

    @Override
    protected void spawnArcaneParticles(SpellRecipe recipe) {
        this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.ARCANE.get()), this.m_20184_().m_82490_(0.75), null);
    }

    @Override
    protected void spawnEnderParticles(SpellRecipe recipe, boolean blood) {
        if (blood) {
            this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.DROPLET.get()), this.m_20184_().m_82490_(0.75).m_82520_(0.0, 0.25, 0.0), p -> {
                p.setColor(Affinity.BLOOD);
                p.setGravity(0.05f);
                p.setPhysics(true);
                p.setMaxAge(14);
            });
        } else {
            this.spawnParticlesAlongRadius(recipe, (MAParticleType)((Object)ParticleInit.ENDER_VELOCITY.get()), this.m_20184_().m_82490_(0.75), null);
        }
    }

    @Override
    protected void spawnFireParticles(SpellRecipe recipe, boolean hellfire, boolean lightning) {
        if (!lightning) {
            this.spawnParticlesAlongRadius(recipe, hellfire ? (MAParticleType)((Object)ParticleInit.HELLFIRE.get()) : (MAParticleType)((Object)ParticleInit.FLAME.get()), this.m_20184_(), false, false, null);
        } else {
            this.spawnLightningParticlesAlongRadius(recipe, this.m_20184_().m_82549_(new Vec3(-0.5 + Math.random(), Math.random(), -0.5 + Math.random())));
        }
    }

    @Override
    protected void spawnWaterParticles(SpellRecipe recipe, boolean frost) {
        this.spawnParticlesAlongRadius(recipe, frost ? (MAParticleType)((Object)ParticleInit.FROST.get()) : (MAParticleType)((Object)ParticleInit.WATER.get()), this.m_20184_().m_82490_(0.75), null);
    }

    @Override
    protected int getApplicationRate() {
        return 1;
    }
}

