/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.summon;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.entities.EntityInit;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BloodGolem
extends Monster
implements GeoEntity {
    protected AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int nonRotatedDeathTime = 0;

    public BloodGolem(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BloodGolem(Level pLevel) {
        this((EntityType<? extends Monster>)((EntityType)EntityInit.BLOOD_GOLEM.get()), pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && SummonUtils.getSummoner((LivingEntity)this) == null) {
            this.m_146870_();
            return;
        }
        if (this.m_9236_().m_5776_() && !this.m_21224_()) {
            Vec3 fwd = this.m_20156_().m_82541_().m_82490_((double)0.4f);
            Vec3 side = this.m_20156_().m_82541_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82490_((double)0.9f);
            int particleCount = this.f_20911_ ? 5 : 1;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 particleVelocity = this.f_20911_ ? this.m_20156_().m_82520_(0.0, 0.25, 0.0) : Vec3.f_82478_;
                Vec3 particlePos = this.m_20182_().m_82520_((MathUtils.RandomBetween(-fwd.f_82479_, fwd.f_82479_) + MathUtils.RandomBetween(-side.f_82479_, side.f_82479_)) * this.m_20191_().m_82362_(), (double)MathUtils.RandomBetween(0.25f, 1.25f) * this.m_20191_().m_82376_(), (MathUtils.RandomBetween(-fwd.f_82481_, fwd.f_82481_) + MathUtils.RandomBetween(-side.f_82481_, side.f_82481_)) * this.m_20191_().m_82385_());
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setGravity(0.05f).setPhysics(true), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
            }
        }
    }

    protected void m_6153_() {
        ++this.nonRotatedDeathTime;
        if (this.nonRotatedDeathTime >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            float damage = (float)this.m_21133_(Attributes.f_22281_);
            float knockback = (float)this.m_21133_(Attributes.f_22282_);
            float preAttackHealth = living.m_21223_();
            boolean didHurtTarget = living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
            if (didHurtTarget) {
                if (knockback > 0.0f) {
                    living.m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                    this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (pEntity instanceof Player) {
                    Player player = (Player)pEntity;
                    this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
                this.m_21335_(pEntity);
                if (living.m_6336_() != MobType.f_21641_ && living.m_6072_()) {
                    float postAttackHealth = living.m_21223_();
                    float actualDamage = preAttackHealth - postAttackHealth;
                    LivingEntity summoner = SummonUtils.getSummoner((LivingEntity)this);
                    if (summoner != null) {
                        summoner.m_5634_(actualDamage / 4.0f);
                    }
                    this.m_5634_(actualDamage);
                }
            }
            return didHurtTarget;
        }
        return super.m_7327_(pEntity);
    }

    private void m_21424_(Player pPlayer, ItemStack pMobItemStack, ItemStack pPlayerItemStack) {
        if (!pMobItemStack.m_41619_() && !pPlayerItemStack.m_41619_() && pMobItemStack.m_41720_() instanceof AxeItem && pPlayerItemStack.m_150930_(Items.f_42740_)) {
            float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
            if (this.f_19796_.m_188501_() < f) {
                pPlayer.m_36335_().m_41524_(Items.f_42740_, 100);
                this.m_9236_().m_7605_((Entity)pPlayer, (byte)30);
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, (double)0.8f).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, state -> this.handleAnimState((AnimationState<BloodGolem>)state));
        registrar.add(new AnimationController[]{controller});
    }

    protected PlayState handleAnimState(AnimationState<BloodGolem> state) {
        RawAnimation builder = RawAnimation.begin();
        if (this.m_21224_()) {
            builder.thenPlayAndHold("animation.blood_golem.die");
        } else if (this.f_19797_ < 26) {
            builder.thenPlayAndHold("animation.blood_golem.summon");
        } else {
            if (this.f_20911_) {
                switch (this.f_20912_) {
                    case MAIN_HAND: {
                        builder.thenPlay("animation.blood_golem.swing_right");
                        break;
                    }
                    case OFF_HAND: {
                        builder.thenPlay("animation.blood_golem.swing_left");
                    }
                }
            }
            if (this.m_20184_().m_82520_(0.0, -this.m_20184_().f_82480_, 0.0).m_82553_() > (double)0.02f) {
                builder.thenLoop("animation.blood_golem.walk");
            } else {
                builder.thenLoop("animation.blood_golem.idle");
            }
        }
        return state.setAndContinue(builder);
    }

    protected SoundEvent m_7515_() {
        return SFX.Entity.BloodGolem.IDLE;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.BloodGolem.DEATH;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SFX.Entity.BloodGolem.HIT;
    }
}

