/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.summon;

import com.mna.api.affinity.Affinity;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.entities.EntityInit;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BloodTendril
extends Monster
implements GeoEntity,
OwnableEntity {
    private static final EntityDataAccessor<Direction> SWING_DIRECTION = SynchedEntityData.m_135353_(BloodTendril.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    protected AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int swing_count = 0;
    private int nonRotatedDeathTime = 0;
    private int duration = 0;
    private boolean dealingDamage = false;
    private LivingEntity summoner;
    private List<LivingEntity> knownTargets = new ArrayList<LivingEntity>();

    public BloodTendril(Level pLevel) {
        this((EntityType<? extends Monster>)((EntityType)EntityInit.BLOOD_TENDRIL.get()), pLevel);
    }

    public BloodTendril(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BloodTendril setSummoner(LivingEntity summoner, int duration) {
        this.summoner = summoner;
        this.duration = duration;
        return this;
    }

    public void m_8119_() {
        this.m_7618_(EntityAnchorArgument.Anchor.FEET, this.m_20182_().m_82549_(new Vec3(1.0, 0.0, 0.0)));
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.summoner == null) {
                this.m_146870_();
                return;
            }
            if (this.f_19797_ > this.duration) {
                if (this.m_6084_() && !this.m_9236_().m_5776_()) {
                    this.m_6469_(this.m_269291_().m_269341_(), 99999.0f);
                }
                return;
            }
            if (this.swing_count > 0) {
                --this.swing_count;
                if (this.swing_count == 6) {
                    this.tryHurtTarget();
                }
                if (this.swing_count == 0) {
                    this.f_19804_.m_135381_(SWING_DIRECTION, (Object)Direction.UP);
                    this.m_6710_(null);
                }
            } else {
                if (this.m_5448_() != null && (this.m_5448_().m_21224_() || this.m_5448_().m_213877_())) {
                    this.m_6710_(null);
                }
                if (this.f_19797_ % 20 == 0) {
                    this.reassessTargets();
                }
                this.pickTarget();
            }
        } else if (!this.m_21224_()) {
            Vec3 fwd = new Vec3(0.25, 0.0, 0.0);
            Vec3 velRange = Vec3.f_82478_;
            boolean isSwinging = true;
            Direction swingDir = (Direction)this.f_19804_.m_135370_(SWING_DIRECTION);
            switch (swingDir) {
                case EAST: {
                    velRange = new Vec3(0.1, 0.0, 0.25);
                    break;
                }
                case NORTH: {
                    fwd = new Vec3(0.0, 0.0, -0.25);
                    velRange = new Vec3(0.25, 0.0, 0.1);
                    break;
                }
                case SOUTH: {
                    fwd = new Vec3(0.0, 0.0, 0.25);
                    velRange = new Vec3(0.25, 0.0, 0.1);
                    break;
                }
                case WEST: {
                    fwd = new Vec3(-0.25, 0.0, 0.0);
                    velRange = new Vec3(0.1, 0.0, 0.25);
                    break;
                }
                default: {
                    isSwinging = false;
                }
            }
            Vec3 side = fwd.m_82541_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(0.25);
            int particleCount = isSwinging ? 5 : 1;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 particleVelocity = isSwinging ? fwd.m_82520_(MathUtils.RandomBetween(-velRange.f_82479_, velRange.f_82479_), 0.25, MathUtils.RandomBetween(-velRange.f_82481_, velRange.f_82481_)) : Vec3.f_82478_;
                Vec3 particlePos = this.m_20182_().m_82520_((MathUtils.RandomBetween(-fwd.f_82479_, fwd.f_82479_) + MathUtils.RandomBetween(-side.f_82479_, side.f_82479_)) * this.m_20191_().m_82362_(), MathUtils.RandomBetween(0.25, isSwinging ? 0.75 : 0.5) * this.m_20191_().m_82376_(), (MathUtils.RandomBetween(-fwd.f_82481_, fwd.f_82481_) + MathUtils.RandomBetween(-side.f_82481_, side.f_82481_)) * this.m_20191_().m_82385_());
                this.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.DROPLET.get())).setColor(Affinity.BLOOD).setGravity(isSwinging ? 0.05f : 0.01f).setPhysics(true), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleVelocity.f_82479_, particleVelocity.f_82480_, particleVelocity.f_82481_);
            }
        }
    }

    protected void m_6153_() {
        ++this.nonRotatedDeathTime;
        if (this.nonRotatedDeathTime >= 20 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    private void tryHurtTarget() {
        if (this.m_5448_() == null) {
            return;
        }
        double targetDist = 2.0 * this.m_20191_().m_82376_();
        if (this.m_5448_().m_20280_((Entity)this) > targetDist) {
            return;
        }
        this.dealingDamage = true;
        this.m_7327_((Entity)this.m_5448_());
        this.dealingDamage = false;
    }

    public float m_146908_() {
        if (this.dealingDamage) {
            Direction dir = (Direction)this.f_19804_.m_135370_(SWING_DIRECTION);
            switch (dir) {
                case EAST: {
                    return 270.0f;
                }
                case NORTH: {
                    return 180.0f;
                }
                case SOUTH: {
                    return 0.0f;
                }
                case WEST: {
                    return 90.0f;
                }
            }
        }
        return super.m_146908_();
    }

    private void reassessTargets() {
        this.knownTargets.clear();
        this.knownTargets.addAll(this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(32.0), e -> e != this && e != this.summoner && e instanceof LivingEntity && !SummonUtils.isTargetFriendly(e, this.summoner)).stream().map(e -> (LivingEntity)e).toList());
    }

    private void pickTarget() {
        this.knownTargets.removeIf(e -> e == null || e.m_21224_() || !e.m_6084_());
        if (this.knownTargets.size() == 0) {
            return;
        }
        LivingEntity closest = null;
        double closestDist = Double.MAX_VALUE;
        for (LivingEntity target : this.knownTargets) {
            double dist = target.m_20280_((Entity)this);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closest = target;
        }
        double targetDist = 2.0 * this.m_20191_().m_82376_();
        if (closestDist < targetDist) {
            this.m_6710_(closest);
            this.swingAtTarget();
        }
    }

    private void swingAtTarget() {
        if (this.m_5448_() == null) {
            return;
        }
        Vec3 delta = this.m_20182_().m_82546_(this.m_5448_().m_20182_());
        if (Math.abs(delta.f_82479_) > Math.abs(delta.f_82481_)) {
            if (delta.f_82479_ < 0.0) {
                this.f_19804_.m_135381_(SWING_DIRECTION, (Object)Direction.EAST);
            } else {
                this.f_19804_.m_135381_(SWING_DIRECTION, (Object)Direction.WEST);
            }
        } else if (delta.f_82481_ < 0.0) {
            this.f_19804_.m_135381_(SWING_DIRECTION, (Object)Direction.SOUTH);
        } else {
            this.f_19804_.m_135381_(SWING_DIRECTION, (Object)Direction.NORTH);
        }
    }

    protected SoundEvent m_7515_() {
        return SFX.Entity.BloodTendril.IDLE;
    }

    protected SoundEvent m_5592_() {
        return SFX.Entity.BloodTendril.DEATH;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SFX.Spell.Impact.Single.BLOOD;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, state -> this.handleAnimState((AnimationState<BloodTendril>)state));
        registrar.add(new AnimationController[]{controller});
    }

    protected PlayState handleAnimState(AnimationState<BloodTendril> state) {
        RawAnimation builder = RawAnimation.begin();
        if (this.m_21224_()) {
            builder.thenPlayAndHold("animation.blood_tendril.die");
        } else {
            if (this.f_19797_ < 20) {
                builder.thenPlay("animation.blood_tendril.summon");
            } else {
                Direction swing = (Direction)this.f_19804_.m_135370_(SWING_DIRECTION);
                switch (swing) {
                    case NORTH: {
                        builder.thenPlay("animation.blood_tendril.swing_north");
                        break;
                    }
                    case SOUTH: {
                        builder.thenPlay("animation.blood_tendril.swing_south");
                        break;
                    }
                    case EAST: {
                        builder.thenPlay("animation.blood_tendril.swing_east");
                        break;
                    }
                    case WEST: {
                        builder.thenPlay("animation.blood_tendril.swing_west");
                        break;
                    }
                }
            }
            builder.thenLoop("animation.blood_tendril.idle");
        }
        return state.setAndContinue(builder);
    }

    protected void m_8099_() {
    }

    public void m_7023_(Vec3 pTravelVector) {
    }

    public void m_20334_(double pX, double pY, double pZ) {
    }

    public void m_20256_(Vec3 pDeltaMovement) {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWING_DIRECTION, (Object)Direction.UP);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
        if (pKey == SWING_DIRECTION) {
            this.swing_count = 10;
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.m_9236_().m_5776_()) {
            List existing = this.m_9236_().m_45976_(BloodTendril.class, this.m_20191_().m_82400_(6.0));
            existing.sort((a, b) -> b.f_19797_ - a.f_19797_);
            int removeCount = existing.size() - 4;
            for (int i = 0; i < removeCount; ++i) {
                ((BloodTendril)((Object)existing.get(i))).m_146870_();
            }
        }
    }

    public UUID m_21805_() {
        return null;
    }

    public LivingEntity m_269323_() {
        return this.summoner;
    }

    public static AttributeSupplier.Builder getGlobalAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22283_, 40.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
    }
}

