/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class MAExplosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private final boolean fire;
    private Explosion.BlockInteraction blockInteraction;
    private final Random random = new Random();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private final float damage;
    @Nullable
    private final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();
    private final Vec3 position;

    public static MAExplosion make(@Nullable LivingEntity caster, ServerLevel world, double x, double y, double z, float radius, float damage, boolean doFire, Explosion.BlockInteraction mode, DamageSource source) {
        MAExplosion explosion = new MAExplosion((Level)world, (Entity)caster, source, new ExplosionDamageCalculator(), x, y, z, radius, doFire, mode, damage);
        if (ForgeEventFactory.onExplosionStart((Level)world, (Explosion)explosion)) {
            explosion.blockInteraction = Explosion.BlockInteraction.KEEP;
        }
        explosion.m_46061_();
        explosion.m_46075_(false);
        if (mode == Explosion.BlockInteraction.KEEP) {
            explosion.m_46080_();
        }
        for (ServerPlayer serverplayerentity : world.m_6907_()) {
            if (!(serverplayerentity.m_20275_(x, y, x) < 4096.0)) continue;
            serverplayerentity.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.m_46081_(), explosion.m_46078_().get(serverplayerentity)));
        }
        world.m_6263_(null, x, y, z, SoundEvents.f_11913_, SoundSource.NEUTRAL, (float)(0.9 + Math.random() * 0.2), (float)(0.9 + Math.random() * 0.2));
        return explosion;
    }

    public MAExplosion(Level level, @Nullable Entity source, DamageSource damagesource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean doFire, Explosion.BlockInteraction interactionMode, float damage) {
        super(level, source, damagesource, damageCalculator, x, y, z, radius, doFire, interactionMode);
        this.damage = damage;
        this.level = level;
        this.source = source;
        this.radius = radius;
        this.x = x;
        this.y = y;
        this.z = z;
        this.fire = doFire;
        this.blockInteraction = interactionMode;
        this.damageSource = damagesource;
        this.damageCalculator = damageCalculator == null ? this.m_46062_(source) : damageCalculator;
        this.position = new Vec3(this.x, this.y, this.z);
    }

    private ExplosionDamageCalculator m_46062_(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity);
    }

    public static float m_46064_(Vec3 vector, Entity entity) {
        AABB axisalignedbb = entity.m_20191_();
        double d0 = 1.0 / ((axisalignedbb.f_82291_ - axisalignedbb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.f_82292_ - axisalignedbb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f_82293_ - axisalignedbb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            float f = 0.0f;
            while (f <= 1.0f) {
                float f1 = 0.0f;
                while (f1 <= 1.0f) {
                    float f2 = 0.0f;
                    while (f2 <= 1.0f) {
                        double d5 = Mth.m_14139_((double)f, (double)axisalignedbb.f_82288_, (double)axisalignedbb.f_82291_);
                        double d6 = Mth.m_14139_((double)f1, (double)axisalignedbb.f_82289_, (double)axisalignedbb.f_82292_);
                        double d7 = Mth.m_14139_((double)f2, (double)axisalignedbb.f_82290_, (double)axisalignedbb.f_82293_);
                        Vec3 vector3d = new Vec3(d5 + d3, d6, d7 + d4);
                        if (entity.m_9236_().m_45547_(new ClipContext(vector3d, vector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                        f2 = (float)((double)f2 + d2);
                    }
                    f1 = (float)((double)f1 + d1);
                }
                f = (float)((double)f + d0);
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void m_46061_() {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        FluidState fluidstate;
                        BlockState blockstate;
                        BlockPos blockpos = BlockPos.m_274561_((double)d4, (double)d6, (double)d8);
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate = this.level.m_8055_(blockpos), fluidstate = this.level.m_6425_(blockpos));
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float f2 = this.radius * 2.0f;
        int k1 = Mth.m_14107_((double)(this.x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(this.x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(this.y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(this.y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(this.z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(this.z + (double)f2 + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)f2);
        Vec3 vector3d = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || !((d12 = (double)(Mth.m_14116_((float)((float)entity.m_20238_(vector3d))) / f2)) <= 1.0) || (d13 = (double)Mth.m_14116_((float)((float)((d5 = entity.m_20185_() - this.x) * d5 + (d7 = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * d7 + (d9 = entity.m_20189_() - this.z) * d9)))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = MAExplosion.m_46064_(vector3d, entity);
            double d10 = (1.0 - d12) * d14;
            entity.m_6469_(this.m_46077_(), this.damage);
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.m_20256_(entity.m_20184_().m_82520_(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof Player) || (playerentity = (Player)entity).m_5833_() || playerentity.m_7500_() && playerentity.m_150110_().f_35935_) continue;
            this.hitPlayers.put(playerentity, new Vec3(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    public void m_46075_(boolean p_77279_1_) {
        boolean flag;
        if (this.level.m_5776_()) {
            this.level.m_7785_(this.x, this.y, this.z, SoundEvents.f_11913_, SoundSource.BLOCKS, 4.0f, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
        }
        boolean bl = flag = this.blockInteraction != Explosion.BlockInteraction.KEEP;
        if (p_77279_1_) {
            if (!(this.radius < 2.0f) && flag) {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag1 = this.m_252906_() instanceof Player;
            Util.m_214673_(this.toBlow, (RandomSource)this.level.f_46441_);
            for (BlockPos blockpos : this.toBlow) {
                Level $$9;
                BlockState blockstate = this.level.m_8055_(blockpos);
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && ($$9 = this.level) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)$$9;
                    BlockEntity blockentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                    LootParams.Builder lootparams$builder = new LootParams.Builder(serverlevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.source);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        lootparams$builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.m_222967_(serverlevel, blockpos, ItemStack.f_41583_, flag1);
                    blockstate.m_287290_(lootparams$builder).forEach(p_46074_ -> MAExplosion.m_46067_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_46074_, blockpos1));
                }
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.m_8055_(blockpos2).m_60795_() || !this.level.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.level, blockpos2.m_7495_())) continue;
                this.level.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)blockpos2));
            }
        }
    }

    private static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> p_229976_0_, ItemStack p_229976_1_, BlockPos p_229976_2_) {
        int i = p_229976_0_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_229976_0_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)p_229976_1_)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)p_229976_1_, (int)16);
            p_229976_0_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_229976_1_.m_41619_()) continue;
            return;
        }
        p_229976_0_.add((Object)Pair.of((Object)p_229976_1_, (Object)p_229976_2_));
    }

    public DamageSource m_46077_() {
        return this.damageSource;
    }

    public Map<Player, Vec3> m_46078_() {
        return this.hitPlayers;
    }

    public Entity m_253049_() {
        Entity entity;
        if (this.source == null) {
            return null;
        }
        if (this.source instanceof PrimedTnt) {
            return ((PrimedTnt)this.source).m_19749_();
        }
        if (this.source instanceof LivingEntity) {
            return this.source;
        }
        if (this.source instanceof Projectile && (entity = ((Projectile)this.source).m_19749_()) instanceof LivingEntity) {
            return entity;
        }
        return null;
    }

    public void m_46080_() {
        this.toBlow.clear();
    }

    public List<BlockPos> m_46081_() {
        return this.toBlow;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    @Nullable
    public Entity getExploder() {
        return this.source;
    }

    public static enum Mode {
        NONE,
        BREAK,
        DESTROY;

    }
}

