/*
 * Decompiled with CFR 0.152.
 */
package com.mna.entities.utility;

import com.mna.entities.EntityInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class StationaryBlock
extends FallingBlockEntity
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Integer> MAXAGE = SynchedEntityData.m_135353_(StationaryBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public StationaryBlock(Level worldIn, double x, double y, double z, BlockState fallingBlockState) {
        this((EntityType<? extends FallingBlockEntity>)((EntityType)EntityInit.STATIONARY_BLOCK_ENTITY.get()), worldIn);
        this.f_19850_ = true;
        this.m_6034_(x, y + (double)((1.0f - this.m_20206_()) / 2.0f), z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.m_31959_(this.m_20183_());
        this.f_31946_ = fallingBlockState;
        this.m_20242_(true);
        this.m_20334_(0.0, 0.0, 0.0);
    }

    public StationaryBlock(EntityType<? extends FallingBlockEntity> type, Level world) {
        super(type, world);
    }

    public void m_8119_() {
        if (this.f_31946_.m_60795_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            Block block = this.f_31946_.m_60734_();
            if (this.f_31942_++ == 0) {
                BlockPos blockpos = this.m_20183_();
                if (this.m_9236_().m_8055_(blockpos).m_60713_(block)) {
                    this.m_9236_().m_7471_(blockpos, false);
                } else if (!this.m_9236_().m_5776_()) {
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                    return;
                }
            }
            if (this.f_31942_ > (Integer)this.f_19804_.m_135370_(MAXAGE)) {
                BlockPos myPosition = this.m_20183_();
                this.restoreBlock(myPosition, block);
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private void restoreBlock(BlockPos myPosition, Block block) {
        BlockState blockstate = this.m_9236_().m_8055_(myPosition);
        this.m_20256_(this.m_20184_().m_82542_(0.7, 0.5, 0.7));
        if (!blockstate.m_60713_(Blocks.f_50110_)) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            boolean flag2 = blockstate.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.m_9236_(), myPosition, Direction.UP, ItemStack.f_41583_, Direction.UP));
            boolean flag4 = this.f_31946_.m_60710_((LevelReader)this.m_9236_(), myPosition);
            if (flag2 && flag4) {
                if (this.f_31946_.m_61138_((Property)BlockStateProperties.f_61362_) && this.m_9236_().m_6425_(myPosition).m_76152_() == Fluids.f_76193_) {
                    this.f_31946_ = (BlockState)this.f_31946_.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
                }
                if (this.m_9236_().m_7731_(myPosition, this.f_31946_, 3)) {
                    BlockEntity tileentity;
                    if (block instanceof FallingBlock) {
                        ((FallingBlock)block).m_48792_(this.m_9236_(), myPosition, this.f_31946_, blockstate, (FallingBlockEntity)this);
                    }
                    if (this.f_31944_ != null && this.f_31946_.m_155947_() && (tileentity = this.m_9236_().m_7702_(myPosition)) != null) {
                        CompoundTag compoundnbt = tileentity.m_187480_();
                        for (String s : this.f_31944_.m_128431_()) {
                            Tag inbt = this.f_31944_.m_128423_(s);
                            if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                            compoundnbt.m_128365_(s, inbt.m_6426_());
                        }
                        tileentity.m_142466_(compoundnbt);
                        tileentity.m_6596_();
                    }
                } else if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_19998_((ItemLike)block);
                }
            } else if (this.f_31943_ && this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)block);
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAXAGE, (Object)50);
    }

    public void setMaxAge(int age) {
        this.f_19804_.m_135381_(MAXAGE, (Object)age);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(Block.m_49956_((BlockState)this.m_31980_()));
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int stateId = additionalData.readInt();
        this.f_31946_ = Block.m_49803_((int)stateId);
        if (this.f_31946_ == null) {
            this.f_31946_ = Blocks.f_49992_.m_49966_();
        }
    }
}

