/*
 * Decompiled with CFR 0.152.
 */
package com.mna.events;

import com.mna.ManaAndArtifice;
import com.mna.effects.EffectInit;
import com.mna.effects.harmful.EffectDisjunction;
import com.mna.effects.particles.EffectWithCustomClientParticles;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.DidYouKnowHelper;
import com.mna.tools.EntityUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mna", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PotionEventHandler {
    @SubscribeEvent
    public static void onPotionRemoved(MobEffectEvent.Remove event) {
        PotionEventHandler.handlePotionRemoved(event.getEffect(), event.getEntity());
        if (event.getEffect() == EffectInit.REDUCE.get()) {
            event.getEntity().m_6210_();
        }
    }

    @SubscribeEvent
    public static void onPotionExpired(MobEffectEvent.Expired event) {
        PotionEventHandler.handlePotionRemoved(event.getEffectInstance().m_19544_(), event.getEntity());
        if (event.getEffectInstance().m_19544_() == EffectInit.REDUCE.get()) {
            event.getEntity().m_6210_();
        }
    }

    private static void handlePotionRemoved(MobEffect effect, LivingEntity entity) {
        if (effect == EffectInit.BIND_WOUNDS.get() && entity == ManaAndArtifice.instance.proxy.getClientPlayer() && entity.m_21223_() < entity.m_21233_() && entity.m_9236_().m_5776_()) {
            DidYouKnowHelper.CheckAndShowDidYouKnow(ManaAndArtifice.instance.proxy.getClientPlayer(), "helptip.mna.bind_wounds");
        }
        if (effect == EffectInit.MIST_FORM.get()) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                ManaAndArtifice.instance.proxy.setFlightEnabled(player, false);
                player.m_150110_().f_35935_ = false;
                player.f_19794_ = false;
                player.setForcedPose(null);
                EntityUtil.removeInvisibility(entity);
                player.m_6210_();
                player.getPersistentData().m_128405_("mna_remove_flight", 10);
            }
        } else if (effect == EffectInit.MIND_VISION.get() || effect == EffectInit.POSSESSION.get()) {
            if (entity instanceof ServerPlayer) {
                ServerMessageDispatcher.sendPlayerMindVisionMessage((ServerPlayer)entity, null);
                entity.getPersistentData().m_128473_("posessed_entity_id");
            }
        } else if (effect == EffectInit.LEVITATION.get()) {
            if (entity instanceof Player) {
                ((Player)entity).getPersistentData().m_128405_("mna_remove_flight", 10);
            }
        } else if (effect == EffectInit.GREATER_INVISIBILITY.get()) {
            entity.getPersistentData().m_128405_("mna_remove_ginvis", 10);
        } else if (effect == EffectInit.CAMOUFLAGE.get()) {
            entity.getPersistentData().m_128473_("mna:camoflage_percent");
            entity.getPersistentData().m_128405_("mna_remove_ginvis", 10);
        }
        if (effect instanceof EffectWithCustomClientParticles) {
            ((EffectWithCustomClientParticles)effect).setFlags(entity, false);
        }
    }

    @SubscribeEvent
    public static void onPotionAdded(MobEffectEvent.Added event) {
        if (event.getEffectInstance().m_19544_() == EffectInit.MIST_FORM.get() && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            ManaAndArtifice.instance.proxy.setFlightEnabled(player, true);
            player.m_150110_().f_35935_ = true;
            player.f_19794_ = true;
            player.setForcedPose(Pose.FALL_FLYING);
            player.m_6842_(true);
            player.m_6210_();
        }
        if (event.getEffectInstance().m_19544_() == EffectInit.REDUCE.get()) {
            event.getEntity().m_6210_();
            event.getEntity().m_21195_((MobEffect)EffectInit.ENLARGE.get());
        }
        if (event.getEffectInstance().m_19544_() == EffectInit.ENLARGE.get()) {
            event.getEntity().m_6210_();
            event.getEntity().m_21195_((MobEffect)EffectInit.REDUCE.get());
        }
        if (event.getEffectInstance().m_19544_() instanceof EffectWithCustomClientParticles) {
            ((EffectWithCustomClientParticles)event.getEffectInstance().m_19544_()).setFlags(event.getEntity(), true);
        }
    }

    @SubscribeEvent
    public static void onLivingChangedEquipment(LivingEquipmentChangeEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.f_35974_.size(); ++i) {
            if (i == inventory.f_35977_) continue;
            EffectDisjunction.RemoveDisjunction(inventory.m_8020_(i));
        }
        if (player.f_36096_ != null) {
            EffectDisjunction.RemoveDisjunction(player.f_36096_.m_142621_());
        }
        EffectDisjunction.RemoveDisjunction(event.getFrom());
        if (event.getEntity().m_21023_((MobEffect)EffectInit.DISJUNCTION.get())) {
            EffectDisjunction.ApplyDisjunction(event.getTo(), event.getEntity().m_21124_((MobEffect)EffectInit.DISJUNCTION.get()).m_19564_());
        }
    }
}

