/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.block;

import com.mna.api.affinity.Affinity;
import com.mna.api.blocks.tile.PowerStatus;
import com.mna.api.blocks.tile.TileEntityWithInventory;
import com.mna.blocks.tileentities.wizard_lab.WizardLabTile;
import java.util.HashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class SimpleWizardLabContainer<T extends AbstractContainerMenu, V extends WizardLabTile>
extends AbstractContainerMenu {
    protected boolean closed = false;
    protected final V tile;
    protected final IItemHandler tileItemHandler;
    protected final Player user;

    public SimpleWizardLabContainer(MenuType<? extends SimpleWizardLabContainer<?, ?>> type, int i, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(type, i, playerInventory, (WizardLabTile)playerInventory.f_35978_.m_9236_().m_7702_(packetBuffer.m_130135_()));
    }

    public SimpleWizardLabContainer(MenuType<? extends SimpleWizardLabContainer<?, ?>> type, int i, Inventory playerInv, V tile) {
        super(type, i);
        this.user = playerInv.f_35978_;
        this.tile = tile;
        this.tileItemHandler = new InvWrapper(tile);
        this.initializeSlots(playerInv);
    }

    private void initializeSlots(Inventory playerInventory) {
        int xpos;
        this.addInventorySlots();
        for (xpos = 0; xpos < 3; ++xpos) {
            for (int ypos = 0; ypos < 9; ++ypos) {
                this.m_38897_(new Slot((Container)playerInventory, ypos + xpos * 9 + 9, this.playerInventoryXStart() + ypos * 18, this.playerInventoryYStart() + xpos * 18));
            }
        }
        for (xpos = 0; xpos < 9; ++xpos) {
            this.m_38897_(new Slot((Container)playerInventory, xpos, this.playerInventoryXStart() + xpos * 18, this.playerInventoryYStart() + 58));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    protected int playerInventoryYStart() {
        return 88;
    }

    protected int playerInventoryXStart() {
        return 48;
    }

    protected final int getInventorySize() {
        return ((TileEntityWithInventory)((Object)this.tile)).m_6643_();
    }

    protected abstract int addInventorySlots();

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.getInventorySize() ? !this.m_38903_(itemstack1, this.getInventorySize(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.getInventorySize(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public boolean canActivate() {
        if (this.tile == null) {
            return false;
        }
        return ((WizardLabTile)this.tile).canStart(this.user);
    }

    public boolean m_6366_(Player player, int buttonIndex) {
        return ((WizardLabTile)this.tile).clickMenuButton(player, buttonIndex);
    }

    public float getProgress() {
        return ((WizardLabTile)this.tile).getPctComplete();
    }

    public boolean isActive() {
        return ((WizardLabTile)this.tile).isActive();
    }

    public int getXPCost() {
        return ((WizardLabTile)this.tile).getXPCost(this.user);
    }

    public HashMap<Affinity, PowerStatus> powerRequirementStatus() {
        return ((WizardLabTile)this.tile).powerRequirementStatus();
    }
}

