/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.entity;

import com.mna.gui.containers.ContainerInit;
import com.mna.items.ItemInit;
import com.mna.items.ritual.ThaumaturgicLink;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.ClientSideMerchant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.MerchantResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;

public class ContainerWanderingWizard
extends AbstractContainerMenu {
    private final Merchant merchant;
    private final MerchantContainer merchantInventory;
    private boolean finalized = false;

    public ContainerWanderingWizard(int id, Inventory playerInventoryIn, FriendlyByteBuf buffer) {
        this(id, playerInventoryIn, (Merchant)new ClientSideMerchant(playerInventoryIn.f_35978_));
    }

    public ContainerWanderingWizard(int id, Inventory inv, Merchant merchant) {
        super((MenuType)ContainerInit.WANDERING_WIZARD.get(), id);
        this.merchant = merchant;
        this.merchantInventory = new MerchantContainer(merchant);
        this.m_38897_(new Slot((Container)this.merchantInventory, 0, 154, 6));
        this.m_38897_(new Slot((Container)this.merchantInventory, 1, 179, 6));
        this.m_38897_((Slot)new MerchantResultSlot(inv.f_35978_, merchant, this.merchantInventory, 2, 234, 6));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inv, j + i * 9 + 9, 48 + j * 18, 174 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)inv, k, 48 + k * 18, 232));
        }
    }

    public void m_6199_(Container inventoryIn) {
        this.merchantInventory.m_40024_();
        super.m_6199_(inventoryIn);
    }

    public void setCurrentRecipeIndex(int currentRecipeIndex) {
        this.merchantInventory.m_40020_(currentRecipeIndex);
    }

    public boolean m_6875_(Player playerIn) {
        return this.merchant.m_7962_() == playerIn;
    }

    public boolean m_5882_(ItemStack stack, Slot slotIn) {
        return false;
    }

    private void playMerchantYesSound() {
        if (this.merchant instanceof Entity) {
            Level level = ((Entity)this.merchant).m_9236_();
            if (!level.f_46443_) {
                Entity entity = (Entity)this.merchant;
                level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.merchant.m_7596_(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 2) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
                this.playMerchantYesSound();
            } else if (index != 0 && index != 1 ? (index >= 3 && index < 30 ? !this.m_38903_(itemstack1, 30, 39, false) : index >= 30 && index < 39 && !this.m_38903_(itemstack1, 3, 30, false)) : !this.m_38903_(itemstack1, 3, 39, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.merchant.m_7189_((Player)null);
        if (!playerIn.m_9236_().m_5776_()) {
            if (!playerIn.m_6084_() || playerIn instanceof ServerPlayer && ((ServerPlayer)playerIn).m_9232_()) {
                ItemStack itemstack = this.merchantInventory.m_8016_(0);
                if (!itemstack.m_41619_()) {
                    playerIn.m_36176_(itemstack, false);
                }
                if (!(itemstack = this.merchantInventory.m_8016_(1)).m_41619_()) {
                    playerIn.m_36176_(itemstack, false);
                }
            } else {
                playerIn.m_150109_().m_150079_(this.merchantInventory.m_8016_(0));
                playerIn.m_150109_().m_150079_(this.merchantInventory.m_8016_(1));
            }
        }
    }

    public void setClientSideOffers(MerchantOffers offers) {
        MerchantOffers existing = this.merchant.m_6616_();
        offers.forEach(o -> existing.add(o));
    }

    public void setXp(int xp) {
        this.merchant.m_6621_(xp);
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public MerchantOffers getOffers() {
        return this.merchant.m_6616_();
    }

    public void setCurrentTradeRecipeItems(int selectedIndex) {
        if (this.getOffers().size() > selectedIndex) {
            ItemStack itemstack1;
            ItemStack itemstack = this.merchantInventory.m_8020_(0);
            if (!itemstack.m_41619_()) {
                if (!this.m_38903_(itemstack, 3, 39, true)) {
                    return;
                }
                this.merchantInventory.m_6836_(0, itemstack);
            }
            if (!(itemstack1 = this.merchantInventory.m_8020_(1)).m_41619_()) {
                if (!this.m_38903_(itemstack1, 3, 39, true)) {
                    return;
                }
                this.merchantInventory.m_6836_(1, itemstack1);
            }
            if (this.merchantInventory.m_8020_(0).m_41619_() && this.merchantInventory.m_8020_(1).m_41619_()) {
                ItemStack itemstack2 = ((MerchantOffer)this.getOffers().get(selectedIndex)).m_45358_();
                this.pullItemFromPlayerInventory(0, itemstack2);
                ItemStack itemstack3 = ((MerchantOffer)this.getOffers().get(selectedIndex)).m_45364_();
                this.pullItemFromPlayerInventory(1, itemstack3);
            }
        }
    }

    private void pullItemFromPlayerInventory(int p_217053_1_, ItemStack p_217053_2_) {
        if (!p_217053_2_.m_41619_()) {
            for (int i = 3; i < 39; ++i) {
                ItemStack itemstack = ((Slot)this.f_38839_.get(i)).m_7993_();
                if (itemstack.m_41619_() || !ItemStack.m_41728_((ItemStack)p_217053_2_, (ItemStack)itemstack)) continue;
                ItemStack itemstack1 = this.merchantInventory.m_8020_(p_217053_1_);
                int j = itemstack1.m_41619_() ? 0 : itemstack1.m_41613_();
                int k = Math.min(p_217053_2_.m_41741_() - j, itemstack.m_41613_());
                ItemStack itemstack2 = itemstack.m_41777_();
                int l = j + k;
                itemstack.m_41774_(k);
                itemstack2.m_41764_(l);
                this.merchantInventory.m_6836_(p_217053_1_, itemstack2);
                if (l >= p_217053_2_.m_41741_()) break;
            }
        }
    }

    public int calculateIndexFor(MerchantOffer offer, int index, String currentSearchTerm) {
        if (currentSearchTerm == "" || currentSearchTerm == null) {
            return index;
        }
        ResourceLocation oLoc = ((ThaumaturgicLink)((Object)ItemInit.THAUMATURGIC_LINK.get())).getLocationKey(offer.m_45368_());
        if (oLoc == null) {
            return index;
        }
        for (int i = 0; i < this.getOffers().size(); ++i) {
            MerchantOffer cur = (MerchantOffer)this.getOffers().get(i);
            ResourceLocation curLoc = ((ThaumaturgicLink)((Object)ItemInit.THAUMATURGIC_LINK.get())).getLocationKey(cur.m_45368_());
            if (curLoc == null || !curLoc.equals((Object)oLoc)) continue;
            return i;
        }
        return -1;
    }
}

