/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.containers.item;

import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.gui.SingleItemSlot;
import com.mna.cantrips.CantripRegistry;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.gui.containers.ContainerInit;
import com.mna.items.manaweaving.ItemManaweaverWand;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.mutable.MutableInt;

public class ContainerCantrips
extends AbstractContainerMenu {
    private Container inventory;
    private int NUM_SLOTS = 0;
    private HashMap<ResourceLocation, SingleItemSlot> slots_per_cantrip = new HashMap();

    public ContainerCantrips(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, ((IPlayerMagic)playerInventory.f_35978_.getCapability(PlayerMagicProvider.MAGIC).orElse(null)).getCantripData().getAsInventory());
    }

    public ContainerCantrips(int i, Inventory playerInv, Container grimoireInv) {
        super((MenuType)ContainerInit.CANTRIPS.get(), i);
        this.inventory = grimoireInv;
        this.initializeSlots(playerInv);
    }

    protected void initializeSlots(Inventory playerInv) {
        MutableInt cantrip_index = new MutableInt(0);
        CantripRegistry.INSTANCE.getCantrips(playerInv.f_35978_).stream().forEach(c -> {
            if (!c.isStackLocked()) {
                int x = 9;
                int y = 33;
                SingleItemSlot slot = new SingleItemSlot((IItemHandler)new InvWrapper(this.inventory), this.NUM_SLOTS, x, y, c.getValidDynamicItem());
                slot.setActive(false);
                this.m_38897_((Slot)slot);
                this.slots_per_cantrip.put(c.getId(), slot);
                ++this.NUM_SLOTS;
            }
            cantrip_index.increment();
        });
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)playerInv, j1 + l * 9 + 9, 25 + j1 * 18, 174 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)playerInv, i1, 25 + i1 * 18, 232));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void enableSlotsForCantrip(ResourceLocation cantrip) {
        this.slots_per_cantrip.values().forEach(al -> al.setActive(false));
        if (this.cantripHasSlot(cantrip)) {
            this.slots_per_cantrip.get(cantrip).setActive(true);
        }
    }

    public boolean cantripHasSlot(ResourceLocation cantrip) {
        return this.slots_per_cantrip.containsKey(cantrip);
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        try {
            if (this.m_38853_(slotId).m_7993_().m_41720_() instanceof ItemManaweaverWand) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return true;
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.NUM_SLOTS ? !this.m_38903_(itemstack1, this.NUM_SLOTS, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.NUM_SLOTS, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }
}

