/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.radial;

import com.google.common.collect.Lists;
import com.mna.KeybindInit;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.spells.parts.Modifier;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.events.ClientEventHandler;
import com.mna.gui.radial.GenericRadialMenu;
import com.mna.gui.radial.components.BlitRadialMenuItem;
import com.mna.gui.radial.components.IRadialMenuHost;
import com.mna.gui.radial.components.RadialMenuItem;
import com.mna.items.ItemInit;
import com.mna.network.ClientMessageDispatcher;
import com.mna.recipes.RecipeInit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ModifierRadialSelect
extends Screen {
    private ItemStack stackEquipped;
    private List<Modifier> knownModifiers;
    private boolean needsRecheckStacks = true;
    private final List<BlitRadialMenuItem> cachedMenuItems = Lists.newArrayList();
    private final GenericRadialMenu menu;
    private Minecraft mc;
    private final boolean offhand;

    public ModifierRadialSelect(boolean offhand) {
        super((Component)Component.m_237113_((String)"RADIAL MENU"));
        this.offhand = offhand;
        this.mc = Minecraft.m_91087_();
        this.knownModifiers = new ArrayList<Modifier>();
        this.stackEquipped = this.getHandItem();
        if (this.stackEquipped.m_41720_() == ItemInit.MODIFIER_BOOK.get()) {
            int tier = ((IPlayerProgression)this.mc.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).resolve().get()).getTier();
            this.knownModifiers.addAll(this.mc.f_91074_.m_9236_().m_7465_().m_44013_((RecipeType)RecipeInit.MODIFIER_TYPE.get()).stream().filter(m -> m.getTier() <= tier).map(m -> (Modifier)m.getComponent()).collect(Collectors.toList()));
        } else {
            this.m_7379_();
        }
        this.menu = new GenericRadialMenu(Minecraft.m_91087_(), new IRadialMenuHost(){

            @Override
            public void renderTooltip(GuiGraphics pGuiGraphics, ItemStack stack, int mouseX, int mouseY) {
            }

            @Override
            public void renderTooltip(GuiGraphics pGuiGraphics, Component text, int mouseX, int mouseY) {
            }

            @Override
            public Screen getScreen() {
                return ModifierRadialSelect.this;
            }

            @Override
            public Font getFontRenderer() {
                return ModifierRadialSelect.this.f_96547_;
            }
        }){

            @Override
            public void onClickOutside() {
                this.close();
            }
        };
    }

    private ItemStack getHandItem() {
        return this.offhand ? this.mc.f_91074_.m_21206_() : this.mc.f_91074_.m_21205_();
    }

    @SubscribeEvent
    public static void overlayEvent(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ instanceof ModifierRadialSelect) {
            event.setCanceled(true);
        }
    }

    public void m_7861_() {
        super.m_7861_();
        ClientEventHandler.wipeOpen();
    }

    public void m_86600_() {
        super.m_86600_();
        this.menu.tick();
        if (this.menu.isClosed()) {
            Minecraft.m_91087_().m_91152_(null);
            ClientEventHandler.wipeOpen();
        }
        if (!this.menu.isReady() || this.knownModifiers == null || this.knownModifiers.size() == 0) {
            return;
        }
        ItemStack inHand = this.getHandItem();
        if (inHand.m_41720_() != ItemInit.MODIFIER_BOOK.get()) {
            this.knownModifiers.clear();
        }
        if (this.knownModifiers.size() == 0) {
            Minecraft.m_91087_().m_91152_(null);
        } else if (!ClientEventHandler.isKeyDown((KeyMapping)KeybindInit.RadialMenuOpen.get())) {
            this.processClick(false);
        }
    }

    public boolean m_6348_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        this.processClick(true);
        return super.m_6348_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
    }

    protected void processClick(boolean triggeredByMouse) {
        this.menu.clickItem();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (this.knownModifiers == null || this.knownModifiers.size() == 0) {
            return;
        }
        ItemStack inHand = this.getHandItem();
        if (inHand.m_41720_() != ItemInit.MODIFIER_BOOK.get()) {
            return;
        }
        if (this.needsRecheckStacks) {
            this.cachedMenuItems.clear();
            for (int i = 0; i < this.knownModifiers.size(); ++i) {
                final Modifier m = this.knownModifiers.get(i);
                BlitRadialMenuItem item = new BlitRadialMenuItem(this.menu, i, m.getGuiIcon(), 0, 0, 16, 16, 16, 16, (Component)Component.m_237115_((String)m.getRegistryName().toString())){

                    @Override
                    public boolean onClick() {
                        ClientMessageDispatcher.sendSelectedModifierMessage(m, ModifierRadialSelect.this.offhand);
                        ModifierRadialSelect.this.menu.close();
                        return true;
                    }
                };
                item.setVisible(true);
                this.cachedMenuItems.add(item);
            }
            this.menu.clear();
            this.menu.addAll(this.cachedMenuItems);
            this.needsRecheckStacks = false;
        }
        if (this.cachedMenuItems.stream().noneMatch(RadialMenuItem::isVisible)) {
            this.menu.setCentralText((Component)Component.m_237115_((String)"gui.mna.spellbook.empty"));
        } else {
            this.menu.setCentralText(null);
        }
        this.menu.draw(pGuiGraphics, partialTicks, mouseX, mouseY);
    }

    public boolean m_7043_() {
        return false;
    }
}

