/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.widgets.lodestar;

import com.mna.api.entities.construct.ai.parameter.ConstructAITaskParameter;
import com.mna.api.entities.construct.ai.parameter.ConstructTaskIntegerParameter;
import com.mna.gui.widgets.lodestar.LodestarParameter;
import com.mna.tools.math.MathUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;

public class IntegerParameterInput
extends LodestarParameter<Integer> {
    public static final int PIP_U = 250;
    public static final int PIP_V = 244;
    public static final int PIP_HEIGHT = 6;
    public static final int BAR_U = 216;
    public static final int BAR_V = 250;
    public static final int BAR_HEIGHT = 6;
    public static final int BAR_OFFSET = 16;
    public static final int BAR_WIDTH = 40;
    public static final int V = 66;
    private boolean isDragging = false;
    private int min = 0;
    private int max = 100;

    public IntegerParameterInput(boolean lowTier, int x, int y, Button.OnPress pressHandler, Component tooltip) {
        super(lowTier, x, y, 66, 0, pressHandler, tooltip);
    }

    public IntegerParameterInput(boolean lowTier, int x, int y, int defaultValue, int min, int max, Button.OnPress pressHandler, Component tooltip) {
        super(lowTier, x, y, 66, defaultValue, pressHandler, tooltip);
        this.min = min;
        this.max = max;
        if (this.max < this.min + 1) {
            this.max = this.min + 1;
        }
    }

    @Override
    public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean wasHovered = this.f_93622_;
        this.f_93622_ = false;
        pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        super.m_87963_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        float pct = (float)((Integer)this.value - this.min) / (float)(this.max - this.min);
        pGuiGraphics.m_280163_(this.f_94223_, this.m_252754_() + 16, this.m_252907_() + this.f_93619_ - 6, 216.0f, 250.0f, 40, 6, 256, 256);
        pGuiGraphics.m_280163_(this.f_94223_, this.m_252754_() + 16 + (int)(34.0f * pct), this.m_252907_() + this.f_93619_ - 6, 250.0f, 244.0f, 6, 6, 256, 256);
        MutableComponent tc = Component.m_237113_((String)((Integer)this.value).toString());
        int valWidth = this.mc.f_91062_.m_92852_((FormattedText)tc);
        Font font = this.mc.f_91062_;
        int n = this.m_252754_() + 36 - valWidth / 2;
        int n2 = this.m_252907_() + this.f_93619_ / 2;
        Objects.requireNonNull(this.mc.f_91062_);
        pGuiGraphics.m_280430_(font, (Component)tc, n, n2 - 9 / 2, FastColor.ARGB32.m_13660_((int)255, (int)205, (int)223, (int)225));
        if (wasHovered) {
            this.f_93622_ = true;
            pGuiGraphics.m_280557_(this.mc.f_91062_, (Component)tc, pMouseX, pMouseY);
        }
    }

    public void m_5716_(double mouse_x, double mouse_y) {
        super.m_5716_(mouse_x, mouse_y);
        if (mouse_y >= (double)(this.m_252907_() + this.f_93619_ - 6) && mouse_y <= (double)(this.m_252907_() + this.f_93619_)) {
            this.isDragging = true;
            this.setValueFromMouse(mouse_x);
        }
        this.m_93692_(true);
    }

    public boolean m_6348_(double mouse_x, double mouse_y, int button) {
        this.isDragging = false;
        this.m_93692_(false);
        return super.m_6348_(mouse_x, mouse_y, button);
    }

    protected void m_7212_(double mouse_x, double mouse_y, double delta_x, double delta_y) {
        if (this.isDragging) {
            this.setValueFromMouse(mouse_x);
        }
        super.m_7212_(mouse_x, mouse_y, delta_x, delta_y);
    }

    private void setValueFromMouse(double mouse_x) {
        double pct = (mouse_x - (double)(this.m_252754_() + 16)) / 40.0;
        int value = this.min + (int)((double)(this.max - this.min) * pct);
        value = MathUtils.clamp(value, this.min, this.max);
        this.setValue(value);
    }

    @Override
    public void saveTo(ConstructAITaskParameter param) {
        if (param instanceof ConstructTaskIntegerParameter) {
            ((ConstructTaskIntegerParameter)param).setValue((Integer)this.value);
        }
    }

    @Override
    public void loadFrom(ConstructAITaskParameter param) {
        if (param instanceof ConstructTaskIntegerParameter) {
            this.value = ((ConstructTaskIntegerParameter)param).getValue();
        }
    }

    @Override
    public List<Component> getTooltipItems() {
        List<Component> baseTT = super.getTooltipItems();
        baseTT.add((Component)Component.m_237113_((String)" "));
        baseTT.add((Component)Component.m_237113_((String)((Integer)this.value).toString()));
        return baseTT;
    }
}

