/*
 * Decompiled with CFR 0.152.
 */
package com.mna.gui.widgets.lodestar;

import com.mna.gui.GuiTextures;
import com.mna.gui.block.GuiLodestarV2;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class LodestarGroup
extends AbstractWidget {
    private static final int border_thickness = 1;
    private final Minecraft mc = Minecraft.m_91087_();
    private String desiredLabel;
    private String renderedLabel;
    private int labelWidth;
    private boolean labelTruncated = false;
    private final BiConsumer<LodestarGroup, Boolean> clickHandler;
    private double clickX;
    private double clickY;
    private double clickXOffset;
    private double clickYOffset;
    private boolean lowTier;
    public boolean scaling = false;

    public LodestarGroup(int pX, int pY, int pWidth, int pHeight, boolean lowTier, BiConsumer<LodestarGroup, Boolean> clickHandler) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_());
        this.clickHandler = clickHandler;
        this.lowTier = lowTier;
        this.setLabel("Group");
    }

    public void m_5716_(double mouse_x, double mouse_y) {
        this.clickX = mouse_x;
        this.clickY = mouse_y;
        this.clickXOffset = mouse_x - (double)this.m_252754_();
        this.clickYOffset = mouse_y - (double)this.m_252907_();
        if (this.clickXOffset > (double)(this.f_93618_ - 4) && this.clickYOffset > (double)(this.f_93619_ - 4)) {
            this.scaling = true;
        }
        boolean for_delete = false;
        if (mouse_x >= (double)(this.m_252754_() + this.m_5711_() - 8) && mouse_x <= (double)(this.m_252754_() + this.m_5711_()) && mouse_y >= (double)this.m_252907_() && mouse_y <= (double)(this.m_252907_() + 8)) {
            for_delete = true;
        }
        if (this.clickHandler != null) {
            this.clickHandler.accept(this, for_delete);
        }
    }

    public CompoundTag toCompoundTag(int guiTop, int guiLeft) {
        CompoundTag output = new CompoundTag();
        output.m_128405_("x", this.m_252754_() - guiLeft);
        output.m_128405_("y", this.m_252907_() - guiTop);
        output.m_128405_("w", this.m_5711_());
        output.m_128405_("h", this.m_93694_());
        output.m_128359_("l", this.desiredLabel);
        return output;
    }

    public static LodestarGroup fromCompound(CompoundTag tag, int guiTop, int guiLeft, boolean lowTier, BiConsumer<LodestarGroup, Boolean> clickHandler) {
        if (!(tag.m_128441_("x") && tag.m_128441_("y") && tag.m_128441_("w") && tag.m_128441_("h") && tag.m_128441_("l"))) {
            return null;
        }
        int x = tag.m_128451_("x") + guiLeft;
        int y = tag.m_128451_("y") + guiTop;
        int w = tag.m_128451_("w");
        int h = tag.m_128451_("h");
        String l = tag.m_128461_("l");
        LodestarGroup group = new LodestarGroup(x, y, w, h, lowTier, clickHandler);
        group.setLabel(l);
        return group;
    }

    public void setLabel(String newLabel) {
        this.desiredLabel = newLabel;
        this.labelTruncated = false;
        int maxLabelWidth = this.f_93618_ - 4;
        this.labelWidth = this.mc.f_91062_.m_92895_((String)newLabel);
        while (this.labelWidth > maxLabelWidth && ((String)newLabel).length() >= 5) {
            newLabel = ((String)newLabel).substring(0, ((String)newLabel).length() - 4) + "...";
            this.labelWidth = this.mc.f_91062_.m_92895_((String)newLabel);
            this.labelTruncated = true;
        }
        this.renderedLabel = newLabel;
    }

    protected void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.enableBlend();
        pGuiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.m_5711_() + 1, this.m_252907_() + this.m_93694_() + 1, this.lowTier ? -14477819 : -14935012);
        int n = this.m_252754_() - 1;
        int n2 = this.m_252907_();
        Objects.requireNonNull(this.mc.f_91062_);
        pGuiGraphics.m_280509_(n, n2 - 9 - 1 - 1, this.m_252754_() + this.labelWidth + 1 + 2, this.m_252907_(), this.lowTier ? -14477819 : -14935012);
        pGuiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), this.lowTier ? -6780822 : -14013910);
        int n3 = this.m_252754_() - 1 + 1;
        int n4 = this.m_252907_();
        Objects.requireNonNull(this.mc.f_91062_);
        pGuiGraphics.m_280509_(n3, n4 - 9 - 1, this.m_252754_() + this.labelWidth + 1 + 1, this.m_252907_(), this.lowTier ? -6780822 : -14013910);
        Font font = this.mc.f_91062_;
        int n5 = this.m_252754_() + 1;
        int n6 = this.m_252907_();
        Objects.requireNonNull(this.mc.f_91062_);
        pGuiGraphics.m_280488_(font, this.renderedLabel, n5, n6 - 9, -1);
        if (this.labelTruncated && this.isMouseOverLabel((float)pMouseX / GuiLodestarV2.Zoom, (float)pMouseY / GuiLodestarV2.Zoom)) {
            this.mc.f_91080_.m_257959_(Tooltip.m_257868_((Minecraft)this.mc, (Component)Component.m_237113_((String)this.desiredLabel)));
        }
        if (this.m_5953_((float)pMouseX / GuiLodestarV2.Zoom, (float)pMouseY / GuiLodestarV2.Zoom)) {
            pGuiGraphics.m_280218_(GuiTextures.Blocks.LODESTAR_MAIN, this.m_252754_() + this.m_5711_() - 8, this.m_252907_(), 0, 224, 8, 8);
            pGuiGraphics.m_280509_(this.m_252754_() + this.m_5711_() - 4, this.m_252907_() + this.m_93694_() - 4, this.m_252754_() + this.m_5711_(), this.m_252907_() + this.m_93694_(), -14477819);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMouseOverLabel(double pMouseX, double pMouseY) {
        if (!this.f_93623_) return false;
        if (!this.f_93624_) return false;
        if (!(pMouseX >= (double)this.m_252754_())) return false;
        if (!(pMouseX <= (double)(this.m_252754_() + this.labelWidth))) return false;
        int n = this.m_252907_();
        Objects.requireNonNull(this.mc.f_91062_);
        if (!(pMouseY >= (double)(n - 9))) return false;
        if (!(pMouseY <= (double)this.m_252907_())) return false;
        return true;
    }

    protected boolean m_93680_(double pMouseX, double pMouseY) {
        return super.m_93680_(pMouseX, pMouseY) || this.isMouseOverLabel(pMouseX, pMouseY);
    }

    public void resize(int width, int height) {
        this.f_93618_ = Math.max(width, 50);
        this.f_93619_ = Math.max(height, 50);
        this.setLabel(this.desiredLabel);
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    public double getClickX() {
        return this.clickX;
    }

    public double getClickY() {
        return this.clickY;
    }

    public double getClickXOffset() {
        return this.clickXOffset;
    }

    public double getClickYOffset() {
        return this.clickYOffset;
    }

    public String getLabel() {
        return this.desiredLabel;
    }
}

