/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.gui.GuiTextures;
import com.mna.guide.recipe.ICyclingRecipeRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class Recipe3x3
extends RecipeRendererBase
implements ICyclingRecipeRenderer<Recipe3x3> {
    private CraftingRecipe[] recipes;
    static final int POINT_RENDER_SIZE = 13;

    public Recipe3x3(int x, int y) {
        super(x, y);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        if (pattern.isPresent()) {
            this.recipes = new CraftingRecipe[]{(CraftingRecipe)pattern.get()};
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.Recipe.CRAFT_3X3;
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.length == 0) {
            return;
        }
        ClientLevel level = this.minecraft.f_91073_;
        if (level == null) {
            return;
        }
        RegistryAccess access = level.m_9598_();
        if (access == null) {
            return;
        }
        CraftingRecipe recipe = this.recipes[this.getIndex()];
        if (recipe instanceof ShapedRecipe) {
            this.renderShapedRecipe(pGuiGraphics, x, y, (ShapedRecipe)recipe, access);
        } else if (recipe instanceof ShapelessRecipe) {
            this.renderShapelessRecipe(pGuiGraphics, x, y, (ShapelessRecipe)recipe, access);
        }
    }

    private void renderShapedRecipe(GuiGraphics pGuiGraphics, int x, int y, ShapedRecipe recipe, RegistryAccess access) {
        if (recipe.getRecipeWidth() > 3 || recipe.getRecipeHeight() > 3) {
            return;
        }
        int startX = (int)((float)this.m_252754_() / this.scale + 35.0f);
        int startY = (int)((float)this.m_252907_() / this.scale + 90.0f);
        int pointSizeX = 54;
        int pointSizeY = 50;
        int padding = 6;
        for (int j = 0; j < recipe.getRecipeHeight(); ++j) {
            for (int i = 0; i < recipe.getRecipeWidth(); ++i) {
                Ingredient ingredient;
                List<ItemStack> stacks;
                int ingredientIndex = j * recipe.getRecipeWidth() + i;
                if (ingredientIndex >= recipe.m_7527_().size() || (stacks = Arrays.asList((ingredient = (Ingredient)recipe.m_7527_().get(ingredientIndex)).m_43908_())).size() <= 0) continue;
                this.renderItemStack(pGuiGraphics, stacks, startX + (pointSizeX + padding) * i, startY + (pointSizeY + padding) * j, 2.0f);
            }
        }
        this.renderItemStack(pGuiGraphics, recipe.m_8043_(access), (int)((float)this.m_252754_() / this.scale + 93.0f), (int)((float)this.m_252907_() / this.scale + 23.0f), 2.0f);
    }

    private void renderShapelessRecipe(GuiGraphics pGuiGraphics, int x, int y, ShapelessRecipe recipe, RegistryAccess access) {
        if (recipe.m_7527_().size() > 9) {
            return;
        }
        int startX = (int)((float)this.m_252754_() / this.scale + 35.0f);
        int startY = (int)((float)this.m_252907_() / this.scale + 90.0f);
        int pointSizeX = 54;
        int pointSizeY = 50;
        int padding = 6;
        int count = 0;
        for (Ingredient ingredient : recipe.m_7527_()) {
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length > 0) {
                this.renderItemStack(pGuiGraphics, Arrays.asList(stacks), startX + (pointSizeX + padding) * Math.floorDiv(count, 3), startY + (pointSizeY + padding) * (count % 3), 2.0f);
            }
            ++count;
        }
        this.renderItemStack(pGuiGraphics, recipe.m_8043_(access), (int)((float)this.m_252754_() / this.scale + 93.0f), (int)((float)this.m_252907_() / this.scale + 23.0f), 2.0f);
        Font fr = this.minecraft.f_91062_;
        String lineFormatted = I18n.m_118938_((String)"gui.mna.shapeless", (Object[])new Object[0]);
        pGuiGraphics.m_280056_(fr, lineFormatted, this.m_252754_() + this.f_93618_ / 2 - fr.m_92895_(lineFormatted) / 2, this.m_252907_() + 67, 0x404040, false);
    }

    @Override
    public int getTier() {
        return 1;
    }

    @Override
    public void init_cycling(ResourceLocation[] rLocs) {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (ResourceLocation rLoc : rLocs) {
            Optional pattern = this.minecraft.f_91073_.m_7465_().m_44043_(rLoc);
            if (!pattern.isPresent()) continue;
            recipes.add((CraftingRecipe)pattern.get());
        }
        this.recipes = recipes.toArray(new CraftingRecipe[0]);
    }

    @Override
    public int countRecipes() {
        return this.recipes.length;
    }
}

