/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.guide.recipe.ICyclingRecipeRenderer;
import com.mna.recipes.eldrin.EldrinAltarRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeEldrinAltar
extends RecipeRendererBase
implements ICyclingRecipeRenderer<RecipeEldrinAltar> {
    private EldrinAltarRecipe[] patterns;

    public RecipeEldrinAltar(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    public void init_cycling(ResourceLocation[] rLocs) {
        ArrayList<EldrinAltarRecipe> patternList = new ArrayList<EldrinAltarRecipe>();
        for (ResourceLocation rLoc : rLocs) {
            Optional<Recipe<?>> pattern = this.resolveRecipe(rLoc);
            if (!pattern.isPresent() || !(pattern.get() instanceof EldrinAltarRecipe)) continue;
            patternList.add((EldrinAltarRecipe)pattern.get());
        }
        this.patterns = patternList.toArray(new EldrinAltarRecipe[0]);
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional<Recipe<?>> pattern = this.resolveRecipe(recipeLocation);
        this.patterns = pattern.isPresent() && pattern.get() instanceof EldrinAltarRecipe ? new EldrinAltarRecipe[]{(EldrinAltarRecipe)pattern.get()} : null;
    }

    private Optional<? extends Recipe<?>> resolveRecipe(ResourceLocation recipeLocation) {
        Optional resolved = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        if (!resolved.isPresent()) {
            if (recipeLocation.m_135827_().equals("mna") && !recipeLocation.m_135815_().startsWith("eldrin_altar/")) {
                recipeLocation = new ResourceLocation(recipeLocation.m_135827_(), "eldrin_altar/" + recipeLocation.m_135815_());
            }
            resolved = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        }
        return resolved;
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return GuiTextures.Recipe.ELDRIN;
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int index = this.getIndex();
        if (this.patterns.length == 0) {
            return;
        }
        EldrinAltarRecipe pattern = this.patterns[index];
        if (pattern == null) {
            return;
        }
        int cX = (int)((float)this.m_252754_() / this.scale + (float)(this.f_93618_ / 2 - 23));
        int cY = (int)((float)this.m_252907_() / this.scale + (float)(this.f_93619_ / 2 + 25));
        float radians = -1.5707964f;
        float radianStep = 0.7853982f;
        int ingredDist = 64;
        int affStep = 30;
        int affY = (int)((float)this.m_252907_() / this.scale + (float)(this.f_93619_ - 30));
        Font fr = this.minecraft.f_91062_;
        ItemStack output = pattern.getResultItem();
        this.renderItemStack(pGuiGraphics, output, cX, (int)((float)this.m_252907_() / this.scale + 45.0f), 1.0f);
        int loopCount = 0;
        for (int i = 0; i < pattern.getRequiredItems().length; ++i) {
            List<ItemStack> items = MATags.smartLookupItem(pattern.getRequiredItems()[i]).stream().map(item -> new ItemStack((ItemLike)item)).collect(Collectors.toList());
            if (items == null || items.size() == 0) continue;
            int ingredX = cX + (int)Math.round(Math.cos(radians) * (double)ingredDist);
            int ingredY = cY + (int)Math.round(Math.sin(radians) * (double)ingredDist);
            if (loopCount++ == 0) {
                ingredX = cX;
                ingredY = cY;
            }
            if (loopCount == 2 || loopCount == 4) {
                ingredX = (int)((float)ingredX + 6.0f * this.scale);
            } else if (loopCount == 6 || loopCount == 8) {
                ingredX = (int)((float)ingredX - 6.0f * this.scale);
            }
            this.renderItemStack(pGuiGraphics, items, ingredX, ingredY, 1.0f);
            radians += radianStep;
        }
        MutableInt count = new MutableInt(0);
        int affPosX = (int)((float)this.m_252754_() / this.scale + (float)this.f_93618_ - 40.0f);
        pattern.getPowerRequirements().forEach((a, v) -> {
            ItemStack guiStack = GuiTextures.affinityIcons.get(a);
            int rY = affY - count.getAndIncrement() * affStep - 5;
            this.renderItemStack(pGuiGraphics, guiStack, affPosX, rY, 1.0f);
            String vText = String.format("%.0f", v);
            pGuiGraphics.m_280056_(fr, vText, affPosX, rY + 16, FastColor.ARGB32.m_13660_((int)255, (int)a.getColor()[0], (int)a.getColor()[1], (int)a.getColor()[2]), false);
        });
        this.renderByproducts(pGuiGraphics, this.m_5711_() / 2 + 10, 26, pattern, true);
        int tier = pattern.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        MutableComponent name = Component.m_237115_((String)pattern.getResultItem().m_41778_().toString());
        MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
        int stringWidth = this.minecraft.f_91062_.m_92852_((FormattedText)name);
        int textX = x + this.f_93618_ / 2 - stringWidth / 2;
        int textY = y + 5;
        pGuiGraphics.m_280614_(fr, (Component)name, textX, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
        pGuiGraphics.m_280614_(fr, (Component)tierPrompt, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, y + 15, color, false);
        if (pattern.getFactionRequirement() != null) {
            int xPadding = 3;
            this.renderFactionIcon(pGuiGraphics, pattern.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    @Override
    public int getTier() {
        if (this.patterns == null) {
            return 1;
        }
        int minTier = 5;
        for (EldrinAltarRecipe pattern : this.patterns) {
            if (pattern.getTier() >= minTier) continue;
            minTier = pattern.getTier();
        }
        return minTier;
    }

    @Override
    public int countRecipes() {
        return this.patterns.length;
    }
}

