/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.recipes.multiblock.MultiblockDefinition;
import com.mna.tools.render.MultiblockRenderer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeMaterialsList
extends RecipeRendererBase {
    private MultiblockDefinition _recipe;
    private List<List<ItemStack>> _ingredients;
    private static final int ITEMSTACK_WIDTH = 16;
    private boolean visualizeHovered = false;

    public RecipeMaterialsList(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this._recipe == null) {
            return;
        }
        if (this._ingredients == null) {
            this._ingredients = this._recipe.getItemsList((Level)this.minecraft.f_91073_);
        }
        if (this._ingredients == null) {
            return;
        }
        int rX = (int)(16.0f * this.scale);
        float f = (float)this.m_252907_() / this.scale + 35.0f;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int rY = (int)(f + 9.0f);
        int column_width = (int)(24.0f * this.scale);
        for (List<ItemStack> stacks : this._ingredients) {
            this.renderItemStack(pGuiGraphics, stacks, x + rX, rY, 1.0f);
            if (!((float)(rX = (int)((float)rX + (16.0f / this.scale + (float)column_width))) >= (float)this.f_93618_ - 16.0f * this.scale - (float)column_width)) continue;
            rY += 20;
            rX = (int)(16.0f * this.scale);
        }
        int tier = this._recipe.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        MutableComponent name = Component.m_237115_((String)"mna:multiblock_recipe").m_7220_((Component)Component.m_237115_((String)this._recipe.m_6423_().toString()));
        MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
        int tierWidth = this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt);
        int tierX = x + this.f_93618_ / 2 - tierWidth / 2;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)name, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)name) / 2, y + 10, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)tierPrompt, tierX, y + 20, color, false);
        int n = x + this.f_93618_ / 2;
        Objects.requireNonNull(this.minecraft.f_91062_);
        this.drawVisualizeButton(pGuiGraphics, n, y + 20 + 9, mouseX, mouseY);
    }

    private void drawVisualizeButton(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY) {
        Objects.requireNonNull(this.minecraft.f_91062_);
        int width = 9;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int height = 9;
        pGuiGraphics.m_280163_(GuiTextures.Widgets.VISUALIZE_MULTIBLOCK, x -= width / 2, y, 0.0f, 0.0f, width, height, width, height);
        this.visualizeHovered = false;
        if (mouseX >= x && mouseX <= x + width && mouseY >= y && mouseY <= y + height) {
            this.visualizeHovered = true;
            List<Component> toolTip = Arrays.asList(Component.m_237115_((String)"gui.mna:visualize_multiblock"));
            this.getTooltipFunction().accept(toolTip);
        }
    }

    public boolean m_6375_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (this.visualizeHovered) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            MultiblockRenderer.setMultiblock(this._recipe, (Component)Component.m_237115_((String)this._recipe.m_6423_().toString()), false);
            this.minecraft.m_91152_(null);
            return true;
        }
        return super.m_6375_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return null;
    }

    @Override
    protected void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof MultiblockDefinition) {
            this._recipe = (MultiblockDefinition)pattern.get();
        }
    }

    @Override
    public int getTier() {
        return 0;
    }
}

