/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.recipe;

import com.mna.api.guidebook.RecipeRendererBase;
import com.mna.api.tools.MATags;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.gui.GuiTextures;
import com.mna.network.ClientMessageDispatcher;
import com.mna.recipes.manaweaving.TransmutationRecipe;
import com.mna.tools.loot.LootDrop;
import com.mna.tools.loot.LootTableCache;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

public class RecipeTransmute
extends RecipeRendererBase {
    private TransmutationRecipe recipe;
    private List<ItemStack> targetBlock;
    private List<ItemStack> replaceBlock;
    private List<LootDrop> drops;
    private boolean waitingForServer = false;
    private ResourceLocation lootTableID = null;

    public RecipeTransmute(int xIn, int yIn) {
        super(xIn, yIn);
    }

    @Override
    protected void drawForeground(GuiGraphics pGuiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipe == null || this.targetBlock == null && this.drops == null) {
            return;
        }
        if (this.targetBlock != null && this.targetBlock.size() > 0) {
            this.renderItemStack(pGuiGraphics, this.targetBlock, (int)((float)this.m_252754_() / this.scale + 33.0f), (int)((float)this.m_252907_() / this.scale + 119.0f), 1.05f);
        }
        if (this.replaceBlock != null && this.replaceBlock.size() > 0) {
            this.renderReplaceBlock(pGuiGraphics);
        } else if (this.waitingForServer || this.drops != null && this.drops.size() > 0) {
            this.renderDrops(pGuiGraphics, x, y);
        }
        int tier = this.recipe.getTier();
        MutableInt playerTier = new MutableInt(0);
        this.minecraft.f_91074_.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> playerTier.setValue(p.getTier()));
        int color = tier <= playerTier.getValue() ? FastColor.ARGB32.m_13660_((int)255, (int)0, (int)128, (int)0) : FastColor.ARGB32.m_13660_((int)255, (int)255, (int)0, (int)0);
        MutableComponent name = Component.m_237115_((String)this.recipe.getResultItem().m_41778_().toString());
        MutableComponent tierPrompt = Component.m_237110_((String)"gui.mna.item-tier", (Object[])new Object[]{tier});
        MutableComponent tooltipPrompt = Component.m_237115_((String)"cantrip.mna.transmute.jei");
        int stringWidth = this.minecraft.f_91062_.m_92852_((FormattedText)tooltipPrompt);
        int textX = x + this.f_93618_ / 2 - stringWidth / 2;
        int textY = y + 25;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)tooltipPrompt, textX, textY, color, false);
        stringWidth = this.minecraft.f_91062_.m_92852_((FormattedText)name);
        textX = x + this.f_93618_ / 2 - stringWidth / 2;
        textY = y + 5;
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)name, textX, textY, FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255), false);
        pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)tierPrompt, x + this.f_93618_ / 2 - this.minecraft.f_91062_.m_92852_((FormattedText)tierPrompt) / 2, y + 15, color, false);
        if (this.recipe.getFactionRequirement() != null) {
            int xPadding = 3;
            this.renderFactionIcon(pGuiGraphics, this.recipe.getFactionRequirement(), textX + stringWidth + xPadding, textY);
        }
    }

    private void renderReplaceBlock(GuiGraphics pGuiGraphics) {
        this.renderItemStack(pGuiGraphics, this.replaceBlock, (int)((float)this.m_252754_() / this.scale + 168.0f), (int)((float)this.m_252907_() / this.scale + 119.0f), 1.05f);
    }

    private void renderDrops(GuiGraphics pGuiGraphics, int x, int y) {
        int xPos = 32;
        int yPos = 176;
        if (this.waitingForServer) {
            List<LootDrop> drops;
            MutableComponent c = Component.m_237115_((String)"gui.mna.waiting-for-server");
            pGuiGraphics.m_280614_(this.minecraft.f_91062_, (Component)c, (int)((float)this.m_252754_() / this.scale + (float)(this.m_5711_() / 2) - (float)(this.minecraft.f_91062_.m_92852_((FormattedText)c) / 2)), (int)((float)this.m_252907_() / this.scale + (float)yPos + 3.0f), 0xFF0000, false);
            if (this.minecraft.f_91073_.m_46467_() % 20L == 0L && (drops = LootTableCache.getLoot(this.recipe.getLootTable())) != null) {
                this.drops = drops;
                this.waitingForServer = false;
            }
        } else {
            for (LootDrop drop : this.drops) {
                if (drop.minDrop == drop.maxDrop) {
                    this.renderItemStack(pGuiGraphics, drop.item, (int)((float)this.m_252754_() / this.scale + (float)xPos), (int)((float)this.m_252907_() / this.scale + (float)yPos), 0.0f, 0.0f, 1.05f, drop.getTooltipText());
                    String s = drop.toString();
                    int width = this.minecraft.f_91062_.m_92895_(s);
                    pGuiGraphics.m_280056_(this.minecraft.f_91062_, s, x + xPos - width / 2 + 10, y + yPos + 14, 0x404040, false);
                } else {
                    this.renderItemStack(pGuiGraphics, drop.item, (int)((float)this.m_252754_() / this.scale + (float)xPos), (int)((float)this.m_252907_() / this.scale + (float)yPos), 0.0f, 0.0f, 1.05f, drop.getTooltipText());
                    pGuiGraphics.m_280056_(this.minecraft.f_91062_, drop.toString(), (int)((float)this.m_252754_() + (float)xPos * this.scale), (int)((float)this.m_252907_() + (float)yPos * this.scale), 0x404040, false);
                }
                if ((xPos += 20) < 180) continue;
                xPos = 32;
                yPos += 24;
            }
        }
    }

    @Override
    protected ResourceLocation backgroundTexture() {
        return this.replaceBlock != null ? GuiTextures.Recipe.TRANSMUTATION_SINGLE : GuiTextures.Recipe.TRANSMUTATION_MULTI;
    }

    @Override
    public void init_internal(ResourceLocation recipeLocation) {
        Optional pattern = this.minecraft.f_91073_.m_7465_().m_44043_(recipeLocation);
        if (pattern.isPresent() && pattern.get() instanceof TransmutationRecipe) {
            this.recipe = (TransmutationRecipe)pattern.get();
            if (this.recipe != null) {
                this.targetBlock = MATags.smartLookupItem(this.recipe.getTargetBlock()).stream().map(i -> new ItemStack((ItemLike)i)).collect(Collectors.toList());
                if (this.recipe.getReplaceBlock() != null) {
                    this.replaceBlock = MATags.smartLookupItem(this.recipe.getReplaceBlock()).stream().map(i -> new ItemStack((ItemLike)i)).collect(Collectors.toList());
                } else if (this.recipe.getLootTable() != null) {
                    List<LootDrop> cached = LootTableCache.getLoot(this.recipe.getLootTable());
                    if (cached == null) {
                        this.waitingForServer = true;
                        ClientMessageDispatcher.requestLootTableDrops(this.recipe.getLootTable());
                    } else {
                        this.drops = cached;
                    }
                }
            }
        }
    }

    @Override
    public int getTier() {
        return this.recipe != null ? this.recipe.getTier() : 1;
    }
}

