/*
 * Decompiled with CFR 0.152.
 */
package com.mna.guide.sections;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mna.ManaAndArtifice;
import com.mna.gui.widgets.guide.TextWidget;
import com.mna.guide.interfaces.IEntrySection;
import com.mna.guide.sections.SectionBase;
import com.mna.tools.TextConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextSection
extends SectionBase {
    protected float SCALE_FACTOR = 1.0f;
    protected boolean CENTER = false;
    protected int PADDING = 5;
    protected int LINE_HEIGHT = 11;
    protected NonNullList<FormattedCharSequence> lines = NonNullList.m_122779_();
    protected String rawText = "";
    protected boolean formatted = false;
    protected boolean newPage = false;
    protected boolean addPadding = false;
    protected String linkPath = null;
    protected String linkType = null;

    @Override
    public Collection<IEntrySection> parse(JsonObject element, int startY, int maxHeight, int maxWidth, int page) {
        MutableComponent parsed = null;
        if (element.has("json")) {
            JsonElement subElem = element.get("json");
            if (subElem.isJsonArray()) {
                JsonArray elemArray = subElem.getAsJsonArray();
                if (elemArray.get(0).getAsJsonObject().get("color") != null) {
                    JsonArray newArray = new JsonArray();
                    JsonObject empty = new JsonObject();
                    empty.add("text", (JsonElement)new JsonPrimitive(""));
                    newArray.add((JsonElement)empty);
                    for (int i = 0; i < elemArray.size(); ++i) {
                        newArray.add(elemArray.get(i));
                    }
                    elemArray = newArray;
                }
                this.rawText = elemArray.toString();
                parsed = Component.Serializer.m_130714_((String)this.rawText);
                this.formatted = true;
            }
        } else if (element.has("value")) {
            this.rawText = element.get("value").getAsString();
        } else {
            throw new JsonParseException("Text section must contain either value or json element");
        }
        if (element.has("newPage")) {
            this.newPage = element.get("newPage").getAsBoolean();
        }
        if (element.has("link")) {
            JsonObject linkelem = element.get("link").getAsJsonObject();
            if (linkelem.has("path") && linkelem.has("type")) {
                this.linkPath = element.get("path").getAsString();
                this.linkType = element.get("type").getAsString();
                if (this.linkType != "recipe" && this.linkType != "entry") {
                    ManaAndArtifice.LOGGER.warn("Codex LINK directive has invalid type " + this.linkType + ".  Will be discarded.");
                    this.linkPath = null;
                    this.linkType = null;
                }
            } else {
                ManaAndArtifice.LOGGER.warn("Codex LINK directive missing path or type node.  Will be discarded.");
            }
        }
        if (this.newPage && startY != 10) {
            ++page;
            startY = 10;
            maxHeight = 168;
        }
        Minecraft m = Minecraft.m_91087_();
        Font fr = m.f_91062_;
        Objects.requireNonNull(fr);
        this.LINE_HEIGHT = (int)Math.ceil(9.0f * this.SCALE_FACTOR);
        int maxLineWidth = (int)Math.floor((float)maxWidth / this.SCALE_FACTOR);
        List split_lines = this.formatted ? fr.m_92923_((FormattedText)parsed, maxLineWidth) : Language.m_128107_().m_128112_(fr.m_92865_().m_92432_(this.rawText, maxLineWidth, Style.f_131099_));
        return this.createTextLinesRecursive(split_lines, startY, maxHeight, page);
    }

    private Collection<IEntrySection> createTextLinesRecursive(List<FormattedCharSequence> split_lines, int startY, int maxHeight, int page) {
        NonNullList output = NonNullList.m_122779_();
        output.add((Object)this);
        if (startY + this.LINE_HEIGHT > maxHeight) {
            ++page;
            startY = 10;
        }
        this.setPage(page);
        int totalHeight = split_lines.size() * this.LINE_HEIGHT + this.PADDING;
        if (totalHeight + startY <= maxHeight) {
            this.lines.addAll(split_lines);
            this.addPadding = true;
        } else if (totalHeight + startY - this.PADDING <= maxHeight) {
            this.lines.addAll(split_lines);
            this.addPadding = false;
        } else {
            int lines_on_current_page = (int)Math.floor((maxHeight - startY) / this.LINE_HEIGHT) - 1;
            this.lines.addAll(split_lines.subList(0, lines_on_current_page));
            List<FormattedCharSequence> subList = split_lines.subList(lines_on_current_page, split_lines.size());
            TextSection newTS = new TextSection();
            output.addAll(newTS.createTextLinesRecursive(subList, 10, 168, page + 1));
        }
        return output;
    }

    @Override
    public Collection<AbstractWidget> getWidgets(AbstractContainerScreen<?> screen, int sectionX, int sectionY, int maxWidth, int maxHeight, Consumer<List<Component>> tooltipFunction, BiConsumer<String, Boolean> showRecipe, BiConsumer<String, Boolean> showEntry) {
        ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        Minecraft m = Minecraft.m_91087_();
        Font fr = m.f_91062_;
        int y = sectionY;
        for (FormattedCharSequence line : this.lines) {
            int pX = sectionX;
            TextConsumer tc = new TextConsumer();
            line.m_13731_((FormattedCharSink)tc);
            int lineWidth = (int)((float)fr.m_92895_(tc.getString()) * this.SCALE_FACTOR);
            if (this.CENTER) {
                pX += (maxWidth - lineWidth) / 2;
            }
            widgets.add(new TextWidget(pX, y, lineWidth, this.LINE_HEIGHT, line, this.overrideColor, this.SCALE_FACTOR, (List<Component>)this.tooltip, tooltipFunction, t -> {
                if (this.linkPath != null && this.linkType != null) {
                    if (this.linkType == "recipe") {
                        showRecipe.accept(this.linkPath, true);
                    } else {
                        showEntry.accept(this.linkPath, true);
                    }
                }
            }));
            y += this.LINE_HEIGHT;
        }
        return widgets;
    }

    @Override
    public int getHeight(int maxHeight) {
        int height = this.lines.size() * this.LINE_HEIGHT;
        if (this.addPadding) {
            height += this.PADDING;
        }
        return height;
    }

    @Override
    public int getWidth(int maxWidth) {
        return (int)((float)maxWidth / this.SCALE_FACTOR);
    }

    @Override
    public boolean canWrap() {
        return true;
    }

    @Override
    public boolean newPage() {
        return this.newPage;
    }

    @Override
    public void setPadding(int i) {
        this.PADDING = i;
    }

    public String getRawText() {
        return this.rawText;
    }
}

