/*
 * Decompiled with CFR 0.152.
 */
package com.mna.inventory.stack_extension;

import com.mna.ManaAndArtifice;
import com.mna.inventory.stack_extension.SlotInfoTable;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Logger;

public class ItemStackEntry {
    public static Codec<ItemStackEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").forGetter(o -> o.stack), (App)Codec.LONG.fieldOf("count").forGetter(o -> o.count), (App)SlotInfoTable.CODEC.optionalFieldOf("info").forGetter(o -> o.info == null || o.info.isEmpty() ? Optional.empty() : Optional.of(o.info))).apply((Applicative)instance, (a, b, c) -> new ItemStackEntry((ItemStack)a, (long)b, c.orElse(new SlotInfoTable()))));
    public static ItemStackEntry EMPTY = new ItemStackEntry(ItemStack.f_41583_);
    private ItemStack stack;
    private long count;
    private SlotInfoTable info;

    public ItemStackEntry(ItemStack stack) {
        this.stack = stack;
        this.count = stack.m_41613_();
        this.info = null;
    }

    private ItemStackEntry(ItemStack stack, long count, SlotInfoTable info) {
        this.stack = stack;
        this.count = count;
        this.info = info;
    }

    public ItemStack getStackOriginal() {
        return this.stack;
    }

    public ItemStack getStackCopy() {
        ItemStack copy = this.stack.m_41777_();
        copy.m_41764_((int)this.count);
        return copy;
    }

    public ItemStack extract(int count) {
        if ((long)count > this.count) {
            count = (int)this.count;
        }
        if (this.stack.m_41613_() == count) {
            this.count = 0L;
            ItemStack result = this.stack;
            this.stack = ItemStack.f_41583_;
            return result;
        }
        ItemStack copy = this.getStackCopy();
        copy.m_41764_(count);
        this.count -= (long)count;
        return copy;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
        this.stack.m_41764_((int)this.count);
    }

    public void grow(long count) {
        this.count += count;
        this.stack.m_41764_((int)this.count);
    }

    public SlotInfoTable getInfo() {
        return this.info;
    }

    public boolean isEmpty() {
        if (this.stack.m_41619_()) {
            return true;
        }
        return this.count == 0L && this.info.isEmpty();
    }

    public Tag serialize() {
        return (Tag)((DataResult)NbtOps.f_128958_.withEncoder(CODEC).apply(this)).getOrThrow(false, arg_0 -> ((Logger)ManaAndArtifice.LOGGER).error(arg_0));
    }

    public static ItemStackEntry deserialize(Tag tag) {
        if (tag == null) {
            return EMPTY;
        }
        return (ItemStackEntry)CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).getOrThrow(false, arg_0 -> ((Logger)ManaAndArtifice.LOGGER).error(arg_0));
    }
}

