/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.armor;

import com.mna.api.items.ITieredItem;
import com.mna.api.tools.RLoc;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.items.armor.IBrokenArmorReplaceable;
import com.mna.items.armor.ISetItem;
import com.mna.items.base.IManaRepairable;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DyeableMageArmor
extends DyeableArmorItem
implements ISetItem,
ITieredItem<DyeableMageArmor>,
IBrokenArmorReplaceable<DyeableMageArmor>,
IManaRepairable {
    private static final ResourceLocation mage_armor_set_bonus = RLoc.create("mage_armor_set_bonus");
    private static final String mage_armor_set_bonus_key = "mage_armor_set_bonus";
    private final float manaPerRepairTick;
    private final float repairPerTick;
    private int _tier = -1;

    public DyeableMageArmor(ArmorMaterial armorMaterial, ArmorItem.Type slot, Item.Properties properties, float manaPerRepairTick, float repairPerTick) {
        super(armorMaterial, slot, properties);
        this.manaPerRepairTick = manaPerRepairTick;
        this.repairPerTick = repairPerTick;
    }

    @Override
    public float manaPerRepairTick() {
        return this.manaPerRepairTick;
    }

    @Override
    public float repairPerTick() {
        return this.repairPerTick;
    }

    @Override
    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IManaRepairable.super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return IBrokenArmorReplaceable.super.damageItem(stack, amount * 3, entity, onBroken);
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41737_("display");
        return compoundnbt != null && compoundnbt.m_128425_("color", 99) ? compoundnbt.m_128451_("color") : -13495757;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ISetItem.super.addSetTooltip(tooltip);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ResourceLocation getSetIdentifier() {
        return mage_armor_set_bonus;
    }

    @Override
    public void applySetBonus(LivingEntity living, EquipmentSlot ... setSlots) {
        if (living instanceof Player) {
            ((Player)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.getCastingResource().addModifier(mage_armor_set_bonus_key, 200.0f);
                m.getCastingResource().addRegenerationModifier(mage_armor_set_bonus_key, -0.25f);
            });
        }
    }

    @Override
    public void removeSetBonus(LivingEntity living, EquipmentSlot ... setSlots) {
        if (living instanceof Player) {
            ((Player)living).getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                m.getCastingResource().removeModifier(mage_armor_set_bonus_key);
                m.getCastingResource().removeRegenerationModifier(mage_armor_set_bonus_key);
            });
        }
    }

    @Override
    public int itemsForSetBonus() {
        return 3;
    }

    @Override
    public int getCachedTier() {
        return this._tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this._tier = tier;
    }
}

