/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.api.capabilities.CurioItemCapability;
import com.mna.api.faction.IFaction;
import com.mna.api.items.IFactionSpecific;
import com.mna.api.items.TieredItem;
import com.mna.effects.EffectInit;
import com.mna.factions.Factions;
import java.util.ArrayList;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ArcaneCrown
extends TieredItem
implements IFactionSpecific {
    public ArcaneCrown() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC));
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)ArmorItem.f_40376_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        EquipmentSlot slotType = EquipmentSlot.HEAD;
        ItemStack equippedItem = playerIn.m_6844_(slotType);
        if (equippedItem.m_41619_()) {
            playerIn.m_8061_(slotType, heldItem.m_41777_());
            heldItem.m_41764_(0);
            return InteractionResultHolder.m_19090_((Object)heldItem);
        }
        return InteractionResultHolder.m_19100_((Object)heldItem);
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        return entity instanceof Player && stack.m_41720_() == this && armorType == EquipmentSlot.HEAD;
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        this.tickEffect(player, world);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        return CurioItemCapability.createProvider(new ICurio(){

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof Player) {
                    ArcaneCrown.this.tickEffect((Player)livingEntity, livingEntity.m_9236_());
                }
            }

            public ItemStack getStack() {
                return stack;
            }
        });
    }

    @Override
    public float getMaxIre() {
        return 5.0E-4f;
    }

    @Override
    public IFaction getFaction() {
        return Factions.COUNCIL;
    }

    private void tickEffect(Player player, Level world) {
        MobEffectInstance dispelExhaustion;
        MobEffectInstance manaBoost;
        if (!(world.f_46443_ || (manaBoost = player.m_21124_((MobEffect)EffectInit.MANA_BOOST.get())) != null && manaBoost.m_19557_() >= 10 && manaBoost.m_19564_() >= 1)) {
            player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.MANA_BOOST.get(), 100, 1, false, false, false));
            this.usedByPlayer(player);
        }
        if ((dispelExhaustion = player.m_21124_((MobEffect)EffectInit.DISPEL_EXHAUSTION.get())) == null) {
            int effectsRemoved = 0;
            this.usedByPlayer(player);
            ArrayList<MobEffect> toRemove = new ArrayList<MobEffect>();
            for (MobEffectInstance inst : player.m_21220_()) {
                if (inst.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
                toRemove.add(inst.m_19544_());
            }
            for (MobEffect e : toRemove) {
                if (!player.m_21195_(e)) continue;
                ++effectsRemoved;
            }
            if (effectsRemoved > 0 && !world.f_46443_) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.DISPEL_EXHAUSTION.get(), 6000, 0, false, false, false));
            }
        }
    }
}

