/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice;

import com.mna.api.items.TieredBlockItem;
import com.mna.api.spells.targeting.SpellTargetHelper;
import com.mna.blocks.artifice.FluidJugBlock;
import com.mna.items.renderers.fluid_jugs.FluidJugItemRenderer;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class FluidJug
extends TieredBlockItem {
    public static final int CAPACITY = 16000;

    public FluidJug(FluidJugBlock forBlock) {
        super((Block)forBlock, new Item.Properties().m_41487_(1));
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new FluidJugItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_(), FluidJug.this.isInfinite() ? FluidJugItemRenderer.jug_artifact : FluidJugItemRenderer.jug_base));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerItemStack(stack, 16000);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        FluidStack fluidStack = this.getFluidTagData(stack);
        if (!fluidStack.isEmpty()) {
            int mb = fluidStack.getAmount();
            Component name = fluidStack.getDisplayName();
            tooltip.add((Component)Component.m_237110_((String)"block.mna.fluid_jug.contents", (Object[])new Object[]{mb, name}));
        }
    }

    public FluidStack getFluidTagData(ItemStack stack) {
        Optional contained = FluidUtil.getFluidContained((ItemStack)stack);
        if (contained.isPresent() && !((FluidStack)contained.get()).isEmpty()) {
            return (FluidStack)contained.get();
        }
        return FluidStack.EMPTY;
    }

    public boolean isInfinite() {
        return ((FluidJugBlock)this.m_40614_()).is_infinite();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_().m_6047_()) {
            return super.m_6225_(context);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        FluidStack flStack = this.getFluidTagData(itemstack);
        BlockHitResult rayTraceResult = FluidJug.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        EntityHitResult cowHit = SpellTargetHelper.rayTraceEntities(world, (Entity)player, player.m_146892_(), player.m_146892_().m_82549_(player.m_20156_().m_82490_(player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()))), player.m_20191_().m_82400_(player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get())), e -> e instanceof Cow && e.m_6084_());
        if (cowHit != null) {
            FluidStack insertStack = new FluidStack((Fluid)ForgeMod.MILK.get(), 1000);
            if (flStack.getFluid().m_6212_((Fluid)ForgeMod.MILK.get()) || flStack.isEmpty()) {
                LazyOptional handler = FluidUtil.getFluidHandler((ItemStack)itemstack);
                if (handler.isPresent()) {
                    IFluidHandlerItem handlerResolved = (IFluidHandlerItem)handler.resolve().get();
                    handlerResolved.fill(insertStack, IFluidHandler.FluidAction.EXECUTE);
                }
                return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.f_46443_);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (rayTraceResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        BlockPos blockpos = rayTraceResult.m_82425_();
        Direction direction = rayTraceResult.m_82434_();
        BlockPos offsetPos = blockpos.m_121945_(direction);
        if (world.m_7966_(player, blockpos) && player.m_36204_(offsetPos, direction, itemstack)) {
            FluidState worldFluid = world.m_6425_(blockpos);
            if (!worldFluid.m_76178_() && (flStack.isEmpty() || worldFluid.m_192917_(flStack.getFluid())) && (this.isInfinite() || flStack.getAmount() < 16000)) {
                return this.pickupFluid(world, blockpos, itemstack, player, direction);
            }
            if (worldFluid.m_76178_() && !flStack.isEmpty()) {
                return this.placeFluid(world, blockpos, offsetPos, player, rayTraceResult, itemstack, hand);
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private InteractionResultHolder<ItemStack> pickupFluid(Level world, BlockPos blockpos, ItemStack itemstack, Player player, Direction dir) {
        FluidActionResult res = FluidUtil.tryPickUpFluid((ItemStack)itemstack, (Player)player, (Level)world, (BlockPos)blockpos, (Direction)dir);
        if (res.success) {
            return InteractionResultHolder.m_19092_((Object)res.result, (boolean)world.f_46443_);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private InteractionResultHolder<ItemStack> placeFluid(Level world, BlockPos blockpos, BlockPos offsetPos, Player player, BlockHitResult rayTraceResult, ItemStack itemstack, InteractionHand hand) {
        FluidStack myFluid = this.getFluidTagData(itemstack);
        BlockState worldState = world.m_8055_(blockpos);
        BlockPos resolvedOffset = this.canBlockContainFluid(world, blockpos, worldState, myFluid) ? blockpos : offsetPos;
        FluidActionResult res = FluidUtil.tryPlaceFluid((Player)player, (Level)world, (InteractionHand)hand, (BlockPos)resolvedOffset, (ItemStack)itemstack, (FluidStack)myFluid);
        if (res.success) {
            return InteractionResultHolder.m_19092_((Object)res.result, (boolean)world.f_46443_);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    private boolean canBlockContainFluid(Level worldIn, BlockPos posIn, BlockState blockstate, FluidStack myFluid) {
        return blockstate.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)blockstate.m_60734_()).m_6044_((BlockGetter)worldIn, posIn, blockstate, myFluid.getFluid());
    }
}

