/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.artifice.curio;

import com.mna.api.items.ChargeableItem;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.api.sound.SFX;
import com.mna.network.ServerMessageDispatcher;
import com.mna.tools.SummonUtils;
import com.mna.tools.math.MathUtils;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ItemEldritchOrb
extends ChargeableItem {
    private final ArrayList<Enchantment> allowedEnchantments = new ArrayList();

    public ItemEldritchOrb() {
        super(new Item.Properties(), 1000.0f);
        this.allowedEnchantments.clear();
        this.allowedEnchantments.add(Enchantments.f_44979_);
        this.allowedEnchantments.add(Enchantments.f_44990_);
        this.allowedEnchantments.add(Enchantments.f_44980_);
        this.allowedEnchantments.add(Enchantments.f_44959_);
        this.allowedEnchantments.add(Enchantments.f_44978_);
        this.allowedEnchantments.add(Enchantments.f_44960_);
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)book);
        for (Enchantment ench : enchantments.keySet()) {
            if (this.allowedEnchantments.contains(ench)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return this.allowedEnchantments.contains(enchantment);
    }

    public boolean shoot(Player caster, ItemStack orb) {
        if (caster.m_9236_().m_5776_()) {
            return false;
        }
        List targets = caster.m_9236_().m_45976_(Mob.class, caster.m_20191_().m_82400_(5.0)).stream().filter(e -> e.m_6084_() && e.m_21574_().m_148306_((Entity)caster) && !SummonUtils.isTargetFriendly((Entity)e, (LivingEntity)caster)).collect(Collectors.toList());
        if (targets.size() <= 0) {
            return false;
        }
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)orb);
        int numTargets = enchants.containsKey(Enchantments.f_44959_) ? (Integer)enchants.get(Enchantments.f_44959_) + 1 : 1;
        for (int i = 0; i < numTargets; ++i) {
            Mob target = (Mob)targets.get((int)Math.floor(Math.random() * (double)targets.size()));
            Vector3f translation = new Vector3f(1.0f, 2.0f, 0.0f);
            translation.rotate((Quaternionfc)Axis.f_252392_.m_252977_((float)((double)(MathUtils.lerpf(caster.f_20886_, caster.f_20885_, 0.0f) / 180.0f) * Math.PI)));
            ServerMessageDispatcher.sendParticleSpawn(caster.m_20185_() + (double)translation.x(), caster.m_20186_() + (double)translation.y(), caster.m_20189_() + (double)translation.z(), target.m_20183_().m_123341_(), (float)target.m_20183_().m_123342_() + target.m_20206_() / 2.0f, target.m_20183_().m_123343_(), 0, 64.0f, (ResourceKey<Level>)caster.m_9236_().m_46472_(), (MAParticleType)((Object)ParticleInit.LIGHTNING_BOLT.get()));
            caster.m_9236_().m_5594_(null, caster.m_20183_(), SFX.Spell.Cast.ARCANE, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.applyOrbEnchantmentEffects(caster, target, enchants);
            target.m_6469_(target.m_269291_().m_269075_(caster), 1.0f);
        }
        return true;
    }

    private void applyOrbEnchantmentEffects(Player caster, Mob target, Map<Enchantment, Integer> enchants) {
        for (Map.Entry<Enchantment, Integer> e : enchants.entrySet()) {
            if ((target instanceof Spider || target instanceof Silverfish || target instanceof Endermite) && e.getKey() == Enchantments.f_44979_) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, e.getValue().intValue()));
                continue;
            }
            if (target.m_21222_() && e.getKey() == Enchantments.f_44978_) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, e.getValue().intValue()));
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, e.getValue().intValue()));
                continue;
            }
            if (e.getKey() == Enchantments.f_44990_) {
                target.m_20254_(e.getValue() + 1);
                continue;
            }
            if (e.getKey() != Enchantments.f_44980_) continue;
            Vec3 dir = caster.m_20182_().m_82546_(target.m_20182_()).m_82541_();
            target.m_147240_((double)((float)e.getValue().intValue() / 3.0f), dir.f_82479_, dir.f_82481_);
        }
    }

    @Override
    protected float manaPerRechargeTick() {
        return 10.0f;
    }

    @Override
    protected boolean tickEffect(ItemStack stack, Player player, Level world, int slot, float mana, boolean selected) {
        long delay;
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
        long l = delay = enchants.containsKey(Enchantments.f_44960_) ? (long)(20 - (Integer)enchants.get(Enchantments.f_44960_)) : 20L;
        return world.m_46467_() % delay == 0L && this.shoot(player, stack);
    }
}

