/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.constructs.parts.arms;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.ItemConstructPart;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ConstructPartAxeArmRight
extends ItemConstructPart {
    protected static final Map<Block, Block> STRIPPABLES = new ImmutableMap.Builder().put((Object)Blocks.f_50011_, (Object)Blocks.f_50044_).put((Object)Blocks.f_49999_, (Object)Blocks.f_50010_).put((Object)Blocks.f_50043_, (Object)Blocks.f_50049_).put((Object)Blocks.f_50004_, (Object)Blocks.f_50009_).put((Object)Blocks.f_50015_, (Object)Blocks.f_50048_).put((Object)Blocks.f_50003_, (Object)Blocks.f_50008_).put((Object)Blocks.f_50013_, (Object)Blocks.f_50046_).put((Object)Blocks.f_50001_, (Object)Blocks.f_50006_).put((Object)Blocks.f_50014_, (Object)Blocks.f_50047_).put((Object)Blocks.f_50002_, (Object)Blocks.f_50007_).put((Object)Blocks.f_50012_, (Object)Blocks.f_50045_).put((Object)Blocks.f_50000_, (Object)Blocks.f_50005_).put((Object)Blocks.f_50686_, (Object)Blocks.f_50687_).put((Object)Blocks.f_50688_, (Object)Blocks.f_50689_).put((Object)Blocks.f_50695_, (Object)Blocks.f_50696_).put((Object)Blocks.f_50697_, (Object)Blocks.f_50698_).build();
    private final TagKey<Block> blocks = BlockTags.f_144280_;
    protected final float speed;
    private final float attackDamageBaseline;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ConstructPartAxeArmRight(ConstructMaterial material, float damage, float speed) {
        super(material, ConstructSlot.RIGHT_ARM, 8);
        this.speed = material.getEquivalentTier().m_6624_();
        this.attackDamageBaseline = damage + material.getEquivalentTier().m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamageBaseline, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @Override
    public ConstructCapability[] getEnabledCapabilities() {
        return new ConstructCapability[]{ConstructCapability.MELEE_ATTACK, ConstructCapability.CHOP_WOOD};
    }

    @Override
    public float getAttackDamage() {
        return this.getMaterial().getDamageBonus() * 1.25f;
    }

    @Override
    public int getAttackSpeedModifier() {
        return 10;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos blockpos = ctx.m_8083_();
        Player player = ctx.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(ctx, ToolActions.AXE_STRIP, false));
        Optional<BlockState> optional1 = Optional.ofNullable(blockstate.getToolModifiedState(ctx, ToolActions.AXE_SCRAPE, false));
        Optional<BlockState> optional2 = Optional.ofNullable(blockstate.getToolModifiedState(ctx, ToolActions.AXE_WAX_OFF, false));
        ItemStack itemstack = ctx.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        if (optional3.isPresent()) {
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, itemstack);
            }
            level.m_7731_(blockpos, (BlockState)optional3.get(), 11);
            if (player != null) {
                itemstack.m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(ctx.m_43724_()));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public static BlockState getAxeStrippingState(BlockState originalState) {
        Block block = STRIPPABLES.get(originalState.m_60734_());
        return block != null ? (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)originalState.m_61143_((Property)RotatedPillarBlock.f_55923_))) : null;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction);
    }

    public float m_8102_(ItemStack p_41004_, BlockState p_41005_) {
        return p_41005_.m_204336_(this.blocks) ? this.speed : 1.0f;
    }

    public boolean m_7579_(ItemStack p_40994_, LivingEntity p_40995_, LivingEntity p_40996_) {
        p_40994_.m_41622_(2, p_40996_, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack p_40998_, Level p_40999_, BlockState p_41000_, BlockPos p_41001_, LivingEntity p_41002_) {
        if (!p_40999_.f_46443_ && p_41000_.m_60800_((BlockGetter)p_40999_, p_41001_) != 0.0f) {
            p_40998_.m_41622_(1, p_41002_, p_40992_ -> p_40992_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40990_) {
        return p_40990_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_40990_);
    }

    @Deprecated
    public boolean m_8096_(BlockState p_150816_) {
        if (TierSortingRegistry.isTierSorted((Tier)this.getMaterial().getEquivalentTier())) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getMaterial().getEquivalentTier(), (BlockState)p_150816_) && p_150816_.m_204336_(this.blocks);
        }
        int i = this.getMaterial().getEquivalentTier().m_6604_();
        if (i < 3 && p_150816_.m_204336_(BlockTags.f_144284_)) {
            return false;
        }
        if (i < 2 && p_150816_.m_204336_(BlockTags.f_144285_)) {
            return false;
        }
        return i < 1 && p_150816_.m_204336_(BlockTags.f_144286_) ? false : p_150816_.m_204336_(this.blocks);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(this.blocks) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getMaterial().getEquivalentTier(), (BlockState)state);
    }
}

