/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.constructs.parts.arms;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mna.api.entities.construct.ConstructCapability;
import com.mna.api.entities.construct.ConstructMaterial;
import com.mna.api.entities.construct.ConstructSlot;
import com.mna.api.entities.construct.ItemConstructPart;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ConstructPartHammerArmRight
extends ItemConstructPart {
    private final TagKey<Block> blocks = BlockTags.f_144282_;
    protected final float speed;
    private final float attackDamageBaseline;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ConstructPartHammerArmRight(ConstructMaterial material, float damage, float speed) {
        super(material, ConstructSlot.RIGHT_ARM, 2);
        this.speed = material.getEquivalentTier().m_6624_();
        this.attackDamageBaseline = damage + material.getEquivalentTier().m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamageBaseline, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)speed, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @Override
    public ConstructCapability[] getEnabledCapabilities() {
        return new ConstructCapability[]{ConstructCapability.MELEE_ATTACK, ConstructCapability.SMITH, ConstructCapability.MINE};
    }

    @Override
    public float getAttackDamage() {
        return this.getMaterial().getDamageBonus();
    }

    @Override
    public int getAttackSpeedModifier() {
        return 15;
    }

    @Override
    public float getKnockbackBonus() {
        return 2.0f;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction);
    }

    public float m_8102_(ItemStack p_41004_, BlockState p_41005_) {
        return p_41005_.m_204336_(this.blocks) ? this.speed : 1.0f;
    }

    public boolean m_7579_(ItemStack p_40994_, LivingEntity p_40995_, LivingEntity p_40996_) {
        p_40994_.m_41622_(2, p_40996_, p_41007_ -> p_41007_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack p_40998_, Level p_40999_, BlockState p_41000_, BlockPos p_41001_, LivingEntity p_41002_) {
        if (!p_40999_.f_46443_ && p_41000_.m_60800_((BlockGetter)p_40999_, p_41001_) != 0.0f) {
            p_40998_.m_41622_(1, p_41002_, p_40992_ -> p_40992_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_40990_) {
        return p_40990_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_40990_);
    }

    @Deprecated
    public boolean m_8096_(BlockState p_150816_) {
        if (TierSortingRegistry.isTierSorted((Tier)this.getMaterial().getEquivalentTier())) {
            return TierSortingRegistry.isCorrectTierForDrops((Tier)this.getMaterial().getEquivalentTier(), (BlockState)p_150816_) && p_150816_.m_204336_(this.blocks);
        }
        int i = this.getMaterial().getEquivalentTier().m_6604_();
        if (i < 3 && p_150816_.m_204336_(BlockTags.f_144284_)) {
            return false;
        }
        if (i < 2 && p_150816_.m_204336_(BlockTags.f_144285_)) {
            return false;
        }
        return i < 1 && p_150816_.m_204336_(BlockTags.f_144286_) ? false : p_150816_.m_204336_(this.blocks);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(this.blocks) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.getMaterial().getEquivalentTier(), (BlockState)state);
    }
}

