/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.ritual;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.items.ITieredItem;
import com.mna.api.rituals.IRitualReagent;
import com.mna.api.rituals.RitualBlockPos;
import com.mna.api.rituals.RitualEffect;
import com.mna.api.tools.MATags;
import com.mna.blocks.BlockInit;
import com.mna.blocks.ritual.ChalkRuneBlock;
import com.mna.blocks.tileentities.ChalkRuneTile;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.rituals.Ritual;
import com.mna.gui.containers.providers.NamedRitualKit;
import com.mna.inventory.InventoryRitualKit;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.base.IRadialMenuItem;
import com.mna.items.base.ItemBagBase;
import com.mna.items.filters.ItemFilterGroup;
import com.mna.items.manaweaving.ItemManaweaveBottle;
import com.mna.items.ritual.PractitionersPatch;
import com.mna.items.ritual.PractitionersPouchPatches;
import com.mna.items.ritual.PurifiedVinteumDust;
import com.mna.items.ritual.WizardChalk;
import com.mna.items.runes.ItemRuneMarking;
import com.mna.recipes.manaweaving.ManaweavingPattern;
import com.mna.recipes.rituals.RitualRecipe;
import com.mna.rituals.MatchedRitual;
import com.mna.rituals.contexts.RitualCheckContext;
import com.mna.tools.InventoryUtilities;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class PractitionersPouch
extends ItemBagBase
implements IRadialMenuItem,
ITieredItem<PractitionersPouch>,
DyeableLeatherItem {
    private static final String TAG_MASTER = "ritual_kit_data";
    private static final String KEY_INDEX = "ritual_kit_index";
    private static final String TAG_RITUAL_RLOC = "ritual_rloc";
    private static final String TAG_RITUAL_ROTATION = "ritual_rotation";
    private static final String TAG_RITUAL_POSITION_COUNT = "ritual_position_count";
    private static final String TAG_RITUAL_POSITION_PREFIX = "position_";
    private static final String TAG_RITUAL_REAGENT_COUNT = "ritual_reagent_count";
    private static final String TAG_RITUAL_REAGENT_PREFIX = "reagent_";
    private static final String TAG_PATCHES = "patches";
    public static final int MAX_RITUALS = 8;
    public static final int MAX_PATCHES = 4;
    private int tier;
    public static String NBT_ID = "mna:ritual_bag_data";

    private boolean storeRitual(MatchedRitual match, Level world, ItemStack stack) {
        int i;
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(TAG_RITUAL_RLOC, match.getRitual().m_6423_().toString());
        ArrayList<ItemStack> reagents = new ArrayList<ItemStack>();
        ArrayList<BlockPos> reagent_positions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> rune_positions = new ArrayList<BlockPos>();
        for (RitualBlockPos rbp : match.getPositions()) {
            BlockPos pos = rbp.getBlockPos().m_121996_((Vec3i)match.getCenter());
            rune_positions.add(pos);
            IRitualReagent reagent = rbp.getReagent();
            if (reagent == null || reagent.isEmpty()) continue;
            ChalkRuneTile tecr = (ChalkRuneTile)world.m_7702_(match.getCenter().m_7918_(pos.m_123341_(), 0, pos.m_123343_()));
            if (tecr == null) {
                return false;
            }
            ItemStack tecrStack = tecr.m_8020_(0);
            if (tecrStack.m_41619_()) {
                if (reagent.isOptional()) continue;
                return false;
            }
            ItemStack tecrCopy = tecrStack.m_41777_();
            tecrCopy.m_41698_("ritual_tags").m_128379_("noConsumeReagent", !reagent.shouldConsumeReagent());
            reagents.add(tecrCopy);
            reagent_positions.add(new BlockPos(pos.m_123341_(), 0, pos.m_123343_()));
        }
        compound.m_128405_(TAG_RITUAL_POSITION_COUNT, rune_positions.size());
        for (i = 0; i < rune_positions.size(); ++i) {
            CompoundTag positionData = new CompoundTag();
            positionData.m_128405_("x", ((BlockPos)rune_positions.get(i)).m_123341_());
            positionData.m_128405_("y", ((BlockPos)rune_positions.get(i)).m_123342_());
            positionData.m_128405_("z", ((BlockPos)rune_positions.get(i)).m_123343_());
            compound.m_128365_(TAG_RITUAL_POSITION_PREFIX + i, (Tag)positionData);
        }
        compound.m_128405_(TAG_RITUAL_REAGENT_COUNT, reagents.size());
        for (i = 0; i < reagents.size(); ++i) {
            CompoundTag reagentData = new CompoundTag();
            reagentData.m_128405_("x", ((BlockPos)reagent_positions.get(i)).m_123341_());
            reagentData.m_128405_("y", ((BlockPos)reagent_positions.get(i)).m_123342_());
            reagentData.m_128405_("z", ((BlockPos)reagent_positions.get(i)).m_123343_());
            ((ItemStack)reagents.get(i)).m_41739_(reagentData);
            compound.m_128365_(TAG_RITUAL_REAGENT_PREFIX + i, (Tag)reagentData);
        }
        Component baseDisplayName = new ItemStack((ItemLike)stack.m_41720_()).m_41786_();
        MutableComponent stc = Component.m_237113_((String)"").m_7220_(baseDisplayName).m_130946_(": ");
        stc = stc.m_7220_((Component)Component.m_237115_((String)match.getRitual().m_6423_().toString())).m_130940_(ChatFormatting.GOLD);
        stack.m_41714_((Component)stc);
        CompoundTag mainCompound = stack.m_41784_();
        ListTag list = null;
        list = mainCompound.m_128425_(TAG_MASTER, 9) ? mainCompound.m_128437_(TAG_MASTER, 10) : new ListTag();
        int index = PractitionersPouch.getIndex(stack);
        while (list.size() < 8) {
            list.add((Object)new CompoundTag());
        }
        list.set(index, (Tag)compound);
        mainCompound.m_128365_(TAG_MASTER, (Tag)list);
        return true;
    }

    private boolean placeRitual(ItemStack stack, BlockPos center, Level world, MatchedRitual inWorld) {
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        List<BlockPos> positions = this.getReagentLocations(stack);
        List<BlockPos> rune_positions = this.getRuneLocations(stack);
        if (reagents.size() != positions.size()) {
            return false;
        }
        if (inWorld != null) {
            Direction inWorldRotation = inWorld.getRotation();
            Direction storedRotation = this.getStoredRitualRotation(stack, world);
            if (inWorldRotation == null || storedRotation == null) {
                return false;
            }
            positions = this.rotateFromTo(positions, storedRotation, inWorldRotation);
            rune_positions = this.rotateFromTo(rune_positions, storedRotation, inWorldRotation);
        }
        return this._placeRitual(stack, center, world, reagents, positions, rune_positions, inWorld == null);
    }

    private boolean _placeRitual(ItemStack stack, BlockPos center, Level world, List<ItemStack> reagents, List<BlockPos> positions, List<BlockPos> rune_positions, boolean offset) {
        for (BlockPos runePos : rune_positions) {
            BlockPlaceContext bpc;
            BlockPos pos = center.m_7918_(runePos.m_123341_(), offset ? 1 : 0, runePos.m_123343_());
            BlockState existing = world.m_8055_(pos);
            if (existing.m_60629_(bpc = new BlockPlaceContext(world, null, InteractionHand.MAIN_HAND, stack, new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, true)))) {
                world.m_46597_(pos, (BlockState)((BlockState)((BlockState)((Block)BlockInit.CHALK_RUNE.get()).m_49966_().m_61124_((Property)ChalkRuneBlock.RUNEINDEX, (Comparable)Integer.valueOf((int)Math.floor(Math.random() * (double)(ChalkRuneBlock.RUNEINDEX.m_6908_().size() - 1))))).m_61124_((Property)ChalkRuneBlock.METAL, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            } else if (existing.m_60734_() == BlockInit.CHALK_RUNE.get()) {
                world.m_46597_(pos, (BlockState)existing.m_61124_((Property)ChalkRuneBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            } else {
                return false;
            }
            ChalkRuneTile rune = (ChalkRuneTile)world.m_7702_(pos);
            if (rune == null) {
                return false;
            }
            int count = 0;
            for (BlockPos reagent_pos : positions) {
                if (reagent_pos.m_123341_() == runePos.m_123341_() && reagent_pos.m_123343_() == runePos.m_123343_()) {
                    if (reagents.get(count).m_41619_()) break;
                    boolean ghost = false;
                    ItemStack runeStack = reagents.get(count).m_41777_();
                    if (runeStack.m_41698_("ritual_tags").m_128471_("noConsumeReagent")) {
                        ghost = true;
                    }
                    runeStack.m_41749_("ritual_tags");
                    rune.setReadOnly(false);
                    rune.setGhostItem(false);
                    rune.m_6836_(0, runeStack.m_41777_());
                    rune.setGhostItem(ghost);
                    break;
                }
                ++count;
            }
            rune.setReadOnly(true);
        }
        return true;
    }

    @Nullable
    protected Entity activateRitual(Player caster, ItemStack stack, RitualRecipe ritual, BlockPos center, Level world) {
        Pair<Direction, NonNullList<RitualBlockPos>> matched = ritual.matchInWorld(center, world);
        if (matched == null) {
            return null;
        }
        IPlayerProgression progression = (IPlayerProgression)caster.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        float speed = 1.0f - 0.2f * (float)(progression.getTier() - ritual.getTier());
        int numSpeedPatches = this.getPatchLevel(stack, PractitionersPouchPatches.SPEED);
        float speedReduction = 0.3f * (float)Math.min(numSpeedPatches, 3);
        speed -= speed * speedReduction;
        InventoryRitualKit inv = new InventoryRitualKit(stack);
        Ritual ritualEntity = new Ritual((EntityType<? extends Ritual>)((EntityType)EntityInit.RITUAL_ENTITY.get()), world);
        ritualEntity.m_6034_((float)center.m_123341_() + 0.5f, center.m_123342_(), (float)center.m_123343_() + 0.5f);
        ritualEntity.setRitualBlockLocations((NonNullList<RitualBlockPos>)((NonNullList)matched.getSecond()));
        ritualEntity.setSpeed(speed);
        ritualEntity.setRitualName(ritual.m_6423_());
        ritualEntity.setForceConsumeReagents(true);
        ritualEntity.setCasterUUID(caster.m_20148_());
        if (this.getPatchLevel(stack, PractitionersPouchPatches.WEAVE) > 0) {
            ArrayList<Pair<IItemHandler, Direction>> inventories = new ArrayList<Pair<IItemHandler, Direction>>();
            Pair<IItemHandler, Direction> remoteInv = this.resolveRemoteInventory(stack, caster.m_9236_());
            if (remoteInv != null) {
                inventories.add(remoteInv);
            }
            if (this.getPatchLevel(stack, PractitionersPouchPatches.RIFT) > 0) {
                caster.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> inventories.add(new Pair((Object)new InvWrapper((Container)m.getRiftInventory()), (Object)Direction.UP)));
            }
            inventories.add(new Pair((Object)inv, (Object)Direction.UP));
            ritualEntity.preConsumePatterns(this.consumePatternItems(inventories, ritual));
        }
        if (ritualEntity.confirmRitualReagents()) {
            world.m_7967_((Entity)ritualEntity);
        }
        return ritualEntity;
    }

    private ArrayList<ItemStack> getReagents(ItemStack stack) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        CompoundTag nbt = PractitionersPouch.getCurrentCompound(stack, PractitionersPouch.getIndex(stack));
        if (nbt == null || !nbt.m_128441_(TAG_RITUAL_REAGENT_COUNT)) {
            return out;
        }
        int count = nbt.m_128451_(TAG_RITUAL_REAGENT_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.m_128441_(TAG_RITUAL_REAGENT_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundTag reagent_data = nbt.m_128469_(TAG_RITUAL_REAGENT_PREFIX + i);
            ItemStack reagent = ItemStack.m_41712_((CompoundTag)reagent_data);
            if (reagent == null) {
                out.clear();
                return out;
            }
            out.add(reagent);
        }
        return out;
    }

    private ArrayList<BlockPos> getReagentLocations(ItemStack stack) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        CompoundTag nbt = PractitionersPouch.getCurrentCompound(stack, PractitionersPouch.getIndex(stack));
        if (nbt == null || !nbt.m_128441_(TAG_RITUAL_REAGENT_COUNT)) {
            return out;
        }
        int count = nbt.m_128451_(TAG_RITUAL_REAGENT_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.m_128441_(TAG_RITUAL_REAGENT_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundTag reagent_data = nbt.m_128469_(TAG_RITUAL_REAGENT_PREFIX + i);
            if (!(reagent_data.m_128441_("x") && reagent_data.m_128441_("y") && reagent_data.m_128441_("z"))) {
                out.clear();
                return out;
            }
            out.add(new BlockPos(reagent_data.m_128451_("x"), reagent_data.m_128451_("y"), reagent_data.m_128451_("z")));
        }
        return out;
    }

    private ArrayList<BlockPos> getRuneLocations(ItemStack stack) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        CompoundTag nbt = PractitionersPouch.getCurrentCompound(stack, PractitionersPouch.getIndex(stack));
        if (nbt == null || !nbt.m_128441_(TAG_RITUAL_POSITION_COUNT)) {
            return out;
        }
        int count = nbt.m_128451_(TAG_RITUAL_POSITION_COUNT);
        for (int i = 0; i < count; ++i) {
            if (!nbt.m_128441_(TAG_RITUAL_POSITION_PREFIX + i)) {
                out.clear();
                return out;
            }
            CompoundTag position_data = nbt.m_128469_(TAG_RITUAL_POSITION_PREFIX + i);
            if (!(position_data.m_128441_("x") && position_data.m_128441_("y") && position_data.m_128441_("z"))) {
                out.clear();
                return out;
            }
            out.add(new BlockPos(position_data.m_128451_("x"), position_data.m_128451_("y"), position_data.m_128451_("z")));
        }
        return out;
    }

    private Direction getStoredRitualRotation(ItemStack stack, Level world) {
        int idx = PractitionersPouch.getIndex(stack);
        CompoundTag nbt = PractitionersPouch.getCurrentCompound(stack, idx);
        if (nbt == null) {
            return Direction.NORTH;
        }
        if (nbt.m_128441_(TAG_RITUAL_ROTATION)) {
            return Direction.values()[nbt.m_128451_(TAG_RITUAL_ROTATION)];
        }
        RitualRecipe recipe = PractitionersPouch.getRitual(world, stack);
        ArrayList<BlockPos> runeLocs = this.getRuneLocations(stack);
        if (recipe == null || runeLocs == null) {
            return Direction.NORTH;
        }
        Direction calculatedRotation = recipe.getMatchedDirection(runeLocs);
        if (calculatedRotation == null) {
            calculatedRotation = Direction.NORTH;
        }
        nbt.m_128405_(TAG_RITUAL_ROTATION, calculatedRotation.ordinal());
        return calculatedRotation;
    }

    private List<BlockPos> rotateFromTo(List<BlockPos> original, Direction from, Direction to) {
        if (from == to) {
            return original;
        }
        return original.stream().map(bp -> this.rotateBlockPos((BlockPos)bp, from, to)).collect(Collectors.toList());
    }

    private BlockPos rotateBlockPos(BlockPos pos, Direction from, Direction to) {
        BlockPos output = pos;
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            output = new BlockPos(-output.m_123343_(), output.m_123342_(), output.m_123341_());
        }
        return output;
    }

    private boolean consumeItem(ItemStack stack, InventoryRitualKit inventory, Container riftInv, IItemHandler remoteInv, Direction remoteFace, boolean save) {
        boolean removed = false;
        if (!removed && riftInv != null) {
            removed = InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandler)new InvWrapper(riftInv));
        }
        if (!removed && remoteInv != null) {
            removed = InventoryUtilities.removeItemFromInventory(stack, true, true, remoteInv, remoteFace);
        }
        if (!removed) {
            removed = InventoryUtilities.removeItemFromInventory(stack, true, true, (IItemHandler)inventory);
        }
        if (save) {
            inventory.writeItemStack();
        }
        return removed;
    }

    private boolean containsItem(ItemStack stack, InventoryRitualKit inventory, Container riftInv, IItemHandler remoteInv, Direction remoteFace) {
        if (riftInv != null && InventoryUtilities.hasStackInInventory(stack, true, true, (IItemHandler)new InvWrapper(riftInv))) {
            return true;
        }
        if (remoteInv != null && InventoryUtilities.hasStackInInventory(stack, true, true, remoteInv, remoteFace)) {
            return true;
        }
        return InventoryUtilities.hasStackInInventory(stack, true, true, (IItemHandler)inventory);
    }

    private boolean ritualReagentsPresent(ItemStack stack, Container riftInv, IItemHandler remoteInv, Direction remoteFace) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        ArrayList<ItemStack> combinedReagents = new ArrayList<ItemStack>();
        for (ItemStack reagent : reagents) {
            boolean found = false;
            for (ItemStack listStack : combinedReagents) {
                if (listStack.m_41720_() != reagent.m_41720_()) continue;
                listStack.m_41764_(listStack.m_41613_() + 1);
                found = true;
                break;
            }
            if (found) continue;
            combinedReagents.add(reagent.m_41777_());
        }
        for (ItemStack reagent : combinedReagents) {
            int totalCount = 0;
            ItemStack searchCopy = reagent.m_41777_();
            if (searchCopy.m_41782_()) {
                searchCopy.m_41783_().m_128473_("ritual_tags");
                if (searchCopy.m_41783_().m_128431_().size() == 0) {
                    searchCopy.m_41751_(null);
                }
            }
            if (riftInv != null) {
                totalCount += InventoryUtilities.countItem(searchCopy, (IItemHandler)new InvWrapper(riftInv), remoteFace, true, true);
            }
            if (remoteInv != null) {
                totalCount += InventoryUtilities.countItem(searchCopy, remoteInv, remoteFace, true, true);
            }
            if ((totalCount += InventoryUtilities.countItem(searchCopy, (IItemHandler)inventory, remoteFace, true, true)) >= searchCopy.m_41613_()) continue;
            return false;
        }
        return true;
    }

    private boolean chalkPresent(ItemStack stack, Container riftInv, IItemHandler remoteInv, Direction remoteFace, int requiredUses) {
        ItemStack invStack;
        int i;
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        int foundUses = 0;
        if (riftInv != null) {
            for (i = 0; i < riftInv.m_6643_(); ++i) {
                invStack = riftInv.m_8020_(i);
                if (!(invStack.m_41720_() instanceof WizardChalk)) continue;
                foundUses += invStack.m_41776_() - invStack.m_41773_();
            }
        }
        if (remoteInv != null) {
            for (i = 0; i < remoteInv.getSlots(); ++i) {
                invStack = remoteInv.extractItem(i, 1, true);
                if (!(invStack.m_41720_() instanceof WizardChalk)) continue;
                foundUses += invStack.m_41776_() - invStack.m_41773_();
            }
        }
        for (i = 0; i < inventory.getSlots(); ++i) {
            invStack = inventory.getStackInSlot(i);
            if (!(invStack.m_41720_() instanceof WizardChalk)) continue;
            foundUses += invStack.m_41776_() - invStack.m_41773_();
        }
        return foundUses >= requiredUses;
    }

    private boolean ritualCatalystPresent(ItemStack pouchStack, Container riftInv, IItemHandler remoteInv, Direction remoteFace) {
        InventoryRitualKit inventory = new InventoryRitualKit(pouchStack);
        List<ItemStack> stacks = MATags.getItemTagContents(MATags.Items.Dusts.PURIFIED_VINTEUM).stream().map(i -> new ItemStack((ItemLike)i)).toList();
        for (ItemStack checkStack : stacks) {
            if (!this.containsItem(checkStack, inventory, riftInv, remoteInv, remoteFace)) continue;
            return true;
        }
        return false;
    }

    private boolean consumeChalk(ItemStack stack, IItemHandlerModifiable riftInv, IItemHandler remoteInv, Direction remoteFace, int amount) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        int remaining = amount;
        if (remaining > 0 && riftInv != null) {
            remaining = this.consumeChalkFromInventory(riftInv, remaining);
        }
        if (remaining > 0 && remoteInv != null) {
            remaining = this.consumeChalkFromInventory(remoteInv, remoteFace, remaining);
        }
        if (remaining > 0 && inventory != null) {
            remaining = this.consumeChalkFromInventory(inventory, remaining);
            inventory.writeItemStack();
        }
        return remaining == 0;
    }

    private List<ResourceLocation> consumePatternItems(List<Pair<IItemHandler, Direction>> inventories, RitualRecipe recipe) {
        String[] requiredPatterns = recipe.getManaweavePatterns();
        ArrayList<ResourceLocation> consumedPatterns = new ArrayList<ResourceLocation>();
        block0: for (String pattern : requiredPatterns) {
            ResourceLocation rLoc = new ResourceLocation(pattern);
            for (int i = 0; i < inventories.size(); ++i) {
                IItemHandler inventory = (IItemHandler)inventories.get(i).getFirst();
                if (inventory == null || !this.consumePatternJar(inventory, rLoc)) continue;
                consumedPatterns.add(rLoc);
                continue block0;
            }
        }
        return consumedPatterns;
    }

    public boolean consumePatternJar(IItemHandler inventory, ResourceLocation rLoc) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ManaweavingPattern pattern;
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.m_41619_() || !ItemManaweaveBottle.hasPattern(stack) || !(pattern = ItemManaweaveBottle.getPattern(stack)).m_6423_().equals((Object)rLoc) || inventory.extractItem(i, 1, false).m_41619_()) continue;
            if (inventory instanceof ItemInventoryBase) {
                ((ItemInventoryBase)inventory).writeItemStack();
            }
            return true;
        }
        return false;
    }

    private int consumeChalkFromInventory(IItemHandlerModifiable inventory, int amount) {
        int remaining = amount;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack inventoryStack = inventory.getStackInSlot(i);
            if (!(inventoryStack.m_41720_() instanceof WizardChalk)) continue;
            int uses = inventoryStack.m_41776_() - inventoryStack.m_41773_();
            if (uses > remaining) {
                inventoryStack.m_41721_(inventoryStack.m_41773_() + remaining);
                inventory.setStackInSlot(i, inventoryStack);
                return 0;
            }
            if (uses == remaining) {
                inventory.setStackInSlot(i, ItemStack.f_41583_);
                return 0;
            }
            remaining -= uses;
            inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
        return remaining;
    }

    private int consumeChalkFromInventory(IItemHandler handler, Direction remoteFace, int amount) {
        int remaining = amount;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack inventoryStack = handler.extractItem(i, 1, true);
            if (!(inventoryStack.m_41720_() instanceof WizardChalk)) continue;
            int uses = inventoryStack.m_41776_() - inventoryStack.m_41773_();
            if (uses > remaining) {
                inventoryStack = handler.extractItem(i, 1, false);
                inventoryStack.m_41721_(inventoryStack.m_41773_() + remaining);
                inventoryStack = handler.insertItem(i, inventoryStack, false);
                if (!inventoryStack.m_41619_()) break;
                return 0;
            }
            if (uses == remaining) {
                handler.extractItem(i, 1, false);
                return 0;
            }
            remaining -= uses;
            handler.extractItem(i, 1, false);
        }
        return remaining;
    }

    private boolean consumeRitualReagents(RitualRecipe recipe, Container riftInv, IItemHandler remoteInv, Direction remoteFace, ItemStack stack) {
        InventoryRitualKit inventory = new InventoryRitualKit(stack);
        ArrayList<ItemStack> reagents = this.getReagents(stack);
        for (ItemStack reagent : reagents) {
            ItemStack searchCopy = reagent.m_41777_();
            if (searchCopy.m_41782_()) {
                if (searchCopy.m_41698_("ritual_tags").m_128471_("noConsumeReagent")) continue;
                searchCopy.m_41783_().m_128473_("ritual_tags");
                if (searchCopy.m_41783_().m_128456_()) {
                    searchCopy.m_41751_(null);
                }
            }
            this.consumeItem(searchCopy, inventory, riftInv, remoteInv, remoteFace, false);
        }
        this.consumeItem(new ItemStack((ItemLike)ItemInit.PURIFIED_VINTEUM_DUST.get()), inventory, riftInv, remoteInv, remoteFace, false);
        inventory.writeItemStack();
        return true;
    }

    public boolean hasRoomForItem(ItemStack bag, ItemStack stack) {
        InventoryRitualKit inv = new InventoryRitualKit(bag);
        return inv.canMergeItem(stack);
    }

    public ItemStack insertItem(ItemStack bag, ItemStack stack) {
        InventoryRitualKit inv = new InventoryRitualKit(bag);
        ItemStack resultantStack = inv.addItem(stack);
        inv.writeItemStack();
        return resultantStack;
    }

    public boolean shouldVoidItem(ItemStack bag, ItemStack stack) {
        InventoryRitualKit inv = new InventoryRitualKit(bag);
        return inv.shouldVoidItem(stack);
    }

    private CompoundTag getPatchTag(ItemStack stack) {
        return stack.m_41698_(TAG_PATCHES);
    }

    public boolean isPatchValid(ItemStack stack, PractitionersPouchPatches patch, int level) {
        int existingLevel = this.getPatchLevel(stack, patch);
        if (existingLevel >= level) {
            return false;
        }
        if (existingLevel < level) {
            return true;
        }
        return this.getAppliedPatches(stack).length < 4;
    }

    public boolean addPatch(ItemStack stack, PractitionersPouchPatches patch, int level) {
        if (this.isPatchValid(stack, patch, level)) {
            this.getPatchTag(stack).m_128405_(patch.name(), Math.min(level, patch.getLevels()));
            return true;
        }
        return false;
    }

    public int getPatchLevel(ItemStack stack, PractitionersPouchPatches patch) {
        CompoundTag patchTag = this.getPatchTag(stack);
        if (patchTag.m_128441_(patch.name())) {
            return patchTag.m_128451_(patch.name());
        }
        return 0;
    }

    public PractitionersPouchPatches[] getAppliedPatches(ItemStack stack) {
        CompoundTag patchTag = this.getPatchTag(stack);
        List<PractitionersPouchPatches> patchList = patchTag.m_128431_().stream().map(s -> {
            try {
                return PractitionersPouchPatches.valueOf(s);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(p -> p != null).collect(Collectors.toList());
        return patchList.toArray(new PractitionersPouchPatches[0]);
    }

    public int countAppliedPatchesForLimit(ItemStack stack, ItemStack patchStack) {
        if (patchStack.m_41720_() instanceof PractitionersPatch && ((PractitionersPatch)patchStack.m_41720_()).getPatch() == PractitionersPouchPatches.SPEED) {
            return 0;
        }
        CompoundTag patchTag = this.getPatchTag(stack);
        List patchList = patchTag.m_128431_().stream().map(s -> {
            try {
                return PractitionersPouchPatches.valueOf(s);
            }
            catch (Exception ex) {
                return null;
            }
        }).filter(p -> p != null && p != PractitionersPouchPatches.SPEED).collect(Collectors.toList());
        return patchList.size();
    }

    @Nullable
    public Pair<IItemHandler, Direction> resolveRemoteInventory(ItemStack stack, Level world) {
        InventoryRitualKit inv = new InventoryRitualKit(stack);
        ItemStack markStack = inv.getStackInSlot(21);
        if (markStack.m_41619_() || !(markStack.m_41720_() instanceof ItemRuneMarking)) {
            return new Pair(null, (Object)Direction.UP);
        }
        BlockPos pos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(markStack);
        Direction face = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getFace(markStack);
        if (pos == null) {
            return new Pair(null, (Object)Direction.UP);
        }
        if (!world.m_46749_(pos)) {
            return new Pair(null, (Object)Direction.UP);
        }
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return new Pair(null, (Object)Direction.UP);
        }
        LazyOptional handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, face);
        if (!handler.isPresent()) {
            return new Pair(null, (Object)Direction.UP);
        }
        return new Pair((Object)((IItemHandler)handler.resolve().get()), (Object)face);
    }

    @Nullable
    private static RitualRecipe getRitual(Level world, ItemStack stack) {
        ResourceLocation rLoc = new ResourceLocation(PractitionersPouch.getRitualRLoc(stack, PractitionersPouch.getIndex(stack)));
        return RitualRecipe.find(world, rLoc);
    }

    public static String getRitualRLoc(ItemStack stack, int index) {
        CompoundTag compound = PractitionersPouch.getCurrentCompound(stack, index);
        if (compound == null || !compound.m_128441_(TAG_RITUAL_RLOC)) {
            return "";
        }
        return compound.m_128461_(TAG_RITUAL_RLOC);
    }

    @Nullable
    private static CompoundTag getCurrentCompound(ItemStack stack, int index) {
        ListTag list;
        if (stack == null || !stack.m_41782_() || !stack.m_41783_().m_128441_(TAG_MASTER)) {
            return null;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128425_(TAG_MASTER, 10)) {
            return tag.m_128469_(TAG_MASTER);
        }
        if (tag.m_128425_(TAG_MASTER, 9) && index < (list = (ListTag)tag.m_128423_(TAG_MASTER)).size()) {
            return list.m_128728_(index);
        }
        return null;
    }

    public static void setIndex(ItemStack stack, int index) {
        stack.m_41784_().m_128405_(KEY_INDEX, index);
        String translationKey = PractitionersPouch.getRitualRLoc(stack, PractitionersPouch.getIndex(stack));
        if (translationKey != "") {
            Component baseDisplayName = new ItemStack((ItemLike)stack.m_41720_()).m_41786_();
            MutableComponent stc = Component.m_237113_((String)"").m_7220_(baseDisplayName).m_130946_(": ");
            stc = stc.m_7220_((Component)Component.m_237115_((String)translationKey)).m_130940_(ChatFormatting.GOLD);
            stack.m_41714_((Component)stc);
        } else {
            stack.m_41787_();
        }
    }

    public static int getIndex(ItemStack stack) {
        if (stack.m_41782_()) {
            return stack.m_41783_().m_128451_(KEY_INDEX);
        }
        return 0;
    }

    public static boolean consumeItem(ItemStack bagStack, Container riftInv, IItemHandler remoteInv, Direction remoteFace, ItemStack consumeStack) {
        InventoryRitualKit inventory = new InventoryRitualKit(bagStack);
        return ((PractitionersPouch)ItemInit.PRACTITIONERS_POUCH.get()).consumeItem(consumeStack, inventory, riftInv, remoteInv, remoteFace, true);
    }

    public static boolean containsItem(ItemStack bagStack, Container riftInv, IItemHandler remoteInv, Direction remoteFace, ItemStack searchStack) {
        return ((PractitionersPouch)ItemInit.PRACTITIONERS_POUCH.get()).containsItem(searchStack, new InventoryRitualKit(bagStack), riftInv, remoteInv, remoteFace);
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            this.openGuiIfModifierPressed(player.m_21120_(hand), player, world);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Component cantStartReason;
        Level world = context.m_43725_();
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        if (!world.f_46443_ && context.m_43724_() == InteractionHand.MAIN_HAND && this.openGuiIfModifierPressed(context.m_43722_(), context.m_43723_(), context.m_43725_())) {
            return InteractionResult.SUCCESS;
        }
        IPlayerMagic magic = (IPlayerMagic)context.m_43723_().getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        IPlayerProgression progression = (IPlayerProgression)context.m_43723_().getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
        if (!magic.isMagicUnlocked()) {
            return InteractionResult.FAIL;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockState state = world.m_8055_(pos);
        MatchedRitual ritualMatch = null;
        RitualRecipe ritual = PractitionersPouch.getRitual(context.m_43725_(), stack);
        boolean clickedOnRune = false;
        boolean activatingNonStoredRitual = false;
        boolean placingChalkRunes = true;
        BlockState aboveState = world.m_8055_(pos.m_7494_());
        if (aboveState.m_60713_((Block)BlockInit.CHALK_RUNE.get())) {
            pos = pos.m_7494_();
            state = aboveState;
        }
        if (state.m_60713_((Block)BlockInit.CHALK_RUNE.get())) {
            clickedOnRune = true;
            placingChalkRunes = false;
            ritualMatch = RitualRecipe.matchAnyInWorld(pos, world);
            if (context.m_43723_().m_6047_()) {
                if (ritualMatch != null) {
                    if (!ritualMatch.getRitual().getIsKittable()) {
                        context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.not_kittable"));
                    } else if (this.storeRitual(ritualMatch, world, stack)) {
                        context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.stored"));
                    } else {
                        context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.store_failed"));
                    }
                } else {
                    context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.not_found"));
                }
                return InteractionResult.SUCCESS;
            }
            if (((Boolean)state.m_61143_((Property)ChalkRuneBlock.ACTIVATED)).booleanValue()) {
                return InteractionResult.FAIL;
            }
        }
        if (ritualMatch == null && clickedOnRune) {
            return InteractionResult.SUCCESS;
        }
        if (ritual == null) {
            if (ritualMatch != null) {
                ritual = ritualMatch.getRitual();
                activatingNonStoredRitual = true;
            } else {
                return InteractionResult.SUCCESS;
            }
        }
        if (ritual.getTier() > progression.getTier()) {
            context.m_43723_().m_213846_((Component)Component.m_237115_((String)"mna:ritual-start-tier-fail"));
            return InteractionResult.FAIL;
        }
        if (!clickedOnRune) {
            int bound = ritual.getLowerBound();
            for (int i = -bound; i <= bound; ++i) {
                for (int j = -bound; j <= bound; ++j) {
                    BlockPlaceContext bpc;
                    BlockPos offsetPos = pos.m_7918_(i, 0, j);
                    if (!Block.m_49936_((BlockGetter)world, (BlockPos)offsetPos)) {
                        return InteractionResult.PASS;
                    }
                    BlockPos abovePos = offsetPos.m_7494_();
                    aboveState = world.m_8055_(abovePos);
                    if (aboveState.m_60629_(bpc = new BlockPlaceContext(context.m_43723_(), context.m_43724_(), stack, new BlockHitResult(Vec3.m_82512_((Vec3i)abovePos), Direction.UP, abovePos, true)))) continue;
                    return InteractionResult.PASS;
                }
            }
        }
        ResourceLocation ritualID = ritual.m_6423_();
        RitualEffect matchedEffect = Registries.RitualEffect.get().getValues().stream().filter(r -> r.matchRitual(ritualID)).findFirst().orElse(null);
        if (matchedEffect == null) {
            context.m_43723_().m_213846_((Component)Component.m_237115_((String)"mna:ritual-start-failed"));
            return InteractionResult.FAIL;
        }
        if ((!context.m_43723_().m_7500_() || matchedEffect.applyStartCheckInCreative()) && (cantStartReason = matchedEffect.canRitualStart(new RitualCheckContext(context.m_43723_(), (ServerLevel)world, ritual, pos.m_7494_(), null))) != null) {
            context.m_43723_().m_213846_(cantStartReason);
            return InteractionResult.FAIL;
        }
        SimpleContainer riftInv = null;
        Pair<IItemHandler, Direction> remoteInv = new Pair<IItemHandler, Direction>(null, (Object)Direction.UP);
        if (this.getPatchLevel(stack, PractitionersPouchPatches.RIFT) > 0) {
            riftInv = magic.getRiftInventory();
        }
        if (this.getPatchLevel(stack, PractitionersPouchPatches.CONVEYANCE) > 0) {
            remoteInv = this.resolveRemoteInventory(stack, world);
        }
        if (!activatingNonStoredRitual) {
            if (ritualMatch != null) {
                NonNullList<RitualBlockPos> positions = ritualMatch.getPositions();
                for (int i = 0; i < positions.size(); ++i) {
                    BlockEntity be = world.m_7702_(((RitualBlockPos)positions.get(i)).getBlockPos());
                    if (be == null) {
                        return InteractionResult.PASS;
                    }
                    if (be instanceof ChalkRuneTile) {
                        ChalkRuneTile crTile = (ChalkRuneTile)be;
                        if (crTile.m_7983_()) continue;
                        context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.metal_runes_not_empty"));
                        return InteractionResult.PASS;
                    }
                    return InteractionResult.PASS;
                }
            }
            if (!this.ritualReagentsPresent(stack, (Container)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond()) || !this.ritualCatalystPresent(stack, (Container)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond())) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.not_enough_items"));
                return InteractionResult.PASS;
            }
            if (placingChalkRunes && !this.chalkPresent(stack, (Container)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond(), ritual.countRunes())) {
                context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.not_enough_items"));
                return InteractionResult.PASS;
            }
            if (!this.consumeRitualReagents(ritual, (Container)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond(), stack)) {
                ManaAndArtifice.LOGGER.error("Failed to consume ritual reagents from the ritual bag.  This is likely due to a conveyance rune marked on an inventory it can't insert AND extract from.");
                return InteractionResult.PASS;
            }
            if (placingChalkRunes && !this.consumeChalk(stack, (IItemHandlerModifiable)(riftInv != null ? new InvWrapper((Container)riftInv) : null), (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond(), ritual.countRunes())) {
                ManaAndArtifice.LOGGER.error("Failed to consume ritual reagents from the ritual bag.  This is likely due to a conveyance rune marked on an inventory it can't insert AND extract from.");
                return InteractionResult.PASS;
            }
        } else if (!PractitionersPouch.containsItem(stack, (Container)riftInv, (IItemHandler)remoteInv.getFirst(), (Direction)remoteInv.getSecond(), new ItemStack((ItemLike)ItemInit.PURIFIED_VINTEUM_DUST.get()))) {
            context.m_43723_().m_213846_((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.not_enough_items"));
            return InteractionResult.PASS;
        }
        if (!activatingNonStoredRitual) {
            if (this.placeRitual(stack, pos, world, ritualMatch)) {
                this.activateRitual(context.m_43723_(), stack, ritual, ritualMatch != null ? pos : pos.m_7494_(), world);
            }
        } else {
            ((PurifiedVinteumDust)ItemInit.PURIFIED_VINTEUM_DUST.get()).updateBlockStates(context, ritualMatch.getPositions(), true);
            PurifiedVinteumDust.RitualInteractResult result = ((PurifiedVinteumDust)ItemInit.PURIFIED_VINTEUM_DUST.get()).commandRitualEntity(context, ritualMatch.getPositions());
            if (result == PurifiedVinteumDust.RitualInteractResult.SPAWN) {
                ((PurifiedVinteumDust)ItemInit.PURIFIED_VINTEUM_DUST.get()).spawnRitualEntity(context, ritualMatch.getRitual(), ritualMatch.getPositions());
            } else if (result == PurifiedVinteumDust.RitualInteractResult.STARTED) {
                // empty if block
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        RitualRecipe ritual = PractitionersPouch.getRitual(worldIn, stack);
        if (Screen.m_96638_()) {
            Object patchString = I18n.m_118938_((String)"item.mna.patch.prompt", (Object[])new Object[0]);
            PractitionersPouchPatches[] patches = this.getAppliedPatches(stack);
            if (patches.length > 0) {
                for (int i = 0; i < patches.length; ++i) {
                    ItemStack patchStack = PractitionersPatch.getItemFor(patches[i], this.getPatchLevel(stack, patches[i]));
                    patchString = (String)patchString + I18n.m_118938_((String)(patchStack.m_41778_() + ".simple"), (Object[])new Object[0]) + ", ";
                }
                patchString = ((String)patchString).substring(0, ((String)patchString).length() - 2);
                tooltip.add((Component)Component.m_237113_((String)patchString).m_130940_(ChatFormatting.YELLOW));
            }
            if (ritual == null) {
                tooltip.add((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.no_ritual_stored"));
            } else {
                ChatFormatting notFoundColor;
                boolean hasRemoteInvPatch;
                ArrayList<ItemStack> reagents = this.getReagents(stack);
                InventoryRitualKit irk = new InventoryRitualKit(stack);
                ArrayList<ItemStack> combinedReagents = new ArrayList<ItemStack>();
                tooltip.add((Component)Component.m_237115_((String)"item.mna.practitioners_pouch.reagents"));
                for (ItemStack reagent : reagents) {
                    boolean found = false;
                    for (ItemStack listStack : combinedReagents) {
                        if (listStack.m_41720_() != reagent.m_41720_()) continue;
                        listStack.m_41764_(listStack.m_41613_() + 1);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    combinedReagents.add(reagent.m_41777_());
                }
                combinedReagents.add(new ItemStack((ItemLike)ItemInit.PURIFIED_VINTEUM_DUST.get()));
                boolean hasRiftPatch = this.getPatchLevel(stack, PractitionersPouchPatches.RIFT) > 0;
                boolean bl = hasRemoteInvPatch = this.getPatchLevel(stack, PractitionersPouchPatches.CONVEYANCE) > 0;
                ChatFormatting chatFormatting = hasRiftPatch && hasRemoteInvPatch ? ChatFormatting.LIGHT_PURPLE : (hasRiftPatch && !hasRemoteInvPatch ? ChatFormatting.DARK_PURPLE : (notFoundColor = !hasRiftPatch && hasRemoteInvPatch ? ChatFormatting.YELLOW : ChatFormatting.RED));
                if (this.chalkPresent(stack, null, null, Direction.UP, ritual.countRunes())) {
                    tooltip.add((Component)Component.m_237115_((String)((WizardChalk)ItemInit.WIZARD_CHALK.get()).m_5524_()).m_130940_(ChatFormatting.GREEN));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)((WizardChalk)ItemInit.WIZARD_CHALK.get()).m_5524_()).m_130940_(notFoundColor));
                }
                for (ItemStack listStack : combinedReagents) {
                    if (listStack.m_41619_()) continue;
                    ItemStack searchCopy = listStack.m_41777_();
                    if (searchCopy.m_41782_()) {
                        searchCopy.m_41783_().m_128473_("ritual_tags");
                        if (searchCopy.m_41783_().m_128431_().size() == 0) {
                            searchCopy.m_41751_(null);
                        }
                    }
                    if (InventoryUtilities.countItem(searchCopy, (IItemHandler)irk, Direction.UP, true, true) >= listStack.m_41613_()) {
                        tooltip.add((Component)Component.m_237115_((String)listStack.m_41720_().m_5524_()).m_130940_(ChatFormatting.GREEN));
                        continue;
                    }
                    tooltip.add((Component)Component.m_237115_((String)listStack.m_41720_().m_5524_()).m_130940_(notFoundColor));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"item.mna.spell.shift_prompt").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        IRadialMenuItem.super.m_7373_(stack, worldIn, tooltip, flagIn);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ItemFilterGroup filterGroup() {
        return ItemFilterGroup.ALL_ITEMS;
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedRitualKit(stack, null);
    }

    @Override
    public void fillByteBuffer(FriendlyByteBuf buf) {
        buf.writeBoolean(false);
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null && nbt.m_128441_(NBT_ID)) {
            stack.m_41751_(nbt);
        }
        return null;
    }

    @Override
    public int getCachedTier() {
        return this.tier;
    }

    @Override
    public void setCachedTier(int tier) {
        this.tier = tier;
    }
}

