/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.ritual;

import com.mna.api.items.TieredItem;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.LazyOptional;

public class WorldCharm
extends TieredItem {
    private static final String KEY_WORLD_TARGET_REGISTRY_NAME = "world_key_type";
    private static final String KEY_WORLD_TARGET_LOCATION = "world_key_value";

    public WorldCharm() {
        super(new Item.Properties().m_41487_(1));
    }

    public boolean SetWorldTarget(Player entity, ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        LazyOptional magic = entity.getCapability(PlayerMagicProvider.MAGIC);
        if (magic.isPresent()) {
            nbt.m_128359_(KEY_WORLD_TARGET_REGISTRY_NAME, entity.m_9236_().m_46472_().m_211136_().toString());
            nbt.m_128359_(KEY_WORLD_TARGET_LOCATION, entity.m_9236_().m_46472_().m_135782_().toString());
            return true;
        }
        return false;
    }

    @Nullable
    public ResourceKey<Level> GetWorldTarget(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_(KEY_WORLD_TARGET_REGISTRY_NAME) || !nbt.m_128441_(KEY_WORLD_TARGET_LOCATION)) {
            return null;
        }
        ResourceLocation location = new ResourceLocation(nbt.m_128461_(KEY_WORLD_TARGET_LOCATION));
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)location);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!worldIn.f_46443_) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            if (!nbt.m_128441_(KEY_WORLD_TARGET_REGISTRY_NAME) && !nbt.m_128441_(KEY_WORLD_TARGET_LOCATION)) {
                this.SetWorldTarget(playerIn, stack);
                playerIn.m_213846_((Component)Component.m_237115_((String)"item.mna.world_charm.attuned_success"));
            } else {
                playerIn.m_213846_((Component)Component.m_237115_((String)"item.mna.world_charm.attuned_failure"));
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128441_(KEY_WORLD_TARGET_LOCATION)) {
            tooltip.add((Component)Component.m_237115_((String)"item.mna.world_charm.not_attuned"));
            return;
        }
        ResourceLocation worldLocation = new ResourceLocation(nbt.m_128461_(KEY_WORLD_TARGET_LOCATION));
        tooltip.add((Component)Component.m_237110_((String)"item.mna.world_charm.attuned", (Object[])new Object[]{worldLocation.toString()}));
    }
}

