/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery;

import com.mna.api.items.IPhylacteryItem;
import com.mna.api.tools.MATags;
import com.mna.gui.containers.providers.NamedPhylacteryBook;
import com.mna.inventory.ItemInventoryBase;
import com.mna.items.ItemInit;
import com.mna.items.base.IRadialInventorySelect;
import com.mna.items.base.ItemBagBase;
import com.mna.items.filters.ItemFilterGroup;
import com.mna.items.sorcery.CrystalPhylactery;
import com.mna.tools.math.MathUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PhylacteryStaff
extends ItemBagBase
implements IRadialInventorySelect {
    public static final int CAPACITY = 24;
    public static final int RADIAL_CAPACITY = 12;

    @Override
    public ItemFilterGroup filterGroup() {
        return ItemFilterGroup.ANY_NON_EMPTY_PHYLACTERY;
    }

    @Override
    public MenuProvider getProvider(ItemStack stack) {
        return new NamedPhylacteryBook(stack);
    }

    @Override
    public int getIndex(ItemStack stack) {
        if (stack.m_41720_() == ItemInit.STAFF_PHYLACTERY.get() && stack.m_41782_() && stack.m_41783_().m_128441_("index")) {
            return stack.m_41783_().m_128451_("index");
        }
        return 0;
    }

    @Override
    public void setIndex(ItemStack stack, int index) {
        if (stack.m_41720_() == ItemInit.STAFF_PHYLACTERY.get()) {
            stack.m_41784_().m_128405_("index", index);
        }
    }

    public static boolean isFilled(ItemStack stack) {
        if (stack.m_41720_() == ItemInit.CRYSTAL_PHYLACTERY.get()) {
            return CrystalPhylactery.isFilled(stack);
        }
        if (stack.m_41720_() == ItemInit.STAFF_PHYLACTERY.get()) {
            int index = ((PhylacteryStaff)ItemInit.STAFF_PHYLACTERY.get()).getIndex(stack);
            ItemInventoryBase inv = new ItemInventoryBase(stack);
            ItemStack invStack = inv.getStackInSlot(index);
            return CrystalPhylactery.isFilled(invStack);
        }
        return false;
    }

    @Nullable
    public static EntityType<? extends Mob> getEntityType(ItemStack stack) {
        if (stack.m_41720_() == ItemInit.CRYSTAL_PHYLACTERY.get()) {
            return CrystalPhylactery.getEntityType(stack);
        }
        if (stack.m_41720_() == ItemInit.STAFF_PHYLACTERY.get()) {
            int index = ((PhylacteryStaff)ItemInit.STAFF_PHYLACTERY.get()).getIndex(stack);
            ItemInventoryBase inv = new ItemInventoryBase(stack);
            ItemStack invStack = inv.getStackInSlot(index);
            return CrystalPhylactery.getEntityType(invStack);
        }
        return null;
    }

    public static boolean addToPhylactery(ItemStack staffStack, EntityType<? extends Mob> type, float amount, Level world) {
        ItemStack matching;
        if (MATags.isEntityIn(type, MATags.EntityTypes.SUMMON_BLACKLIST)) {
            return false;
        }
        ItemInventoryBase inv = new ItemInventoryBase(staffStack);
        int matching_slot = -1;
        for (int i = 0; i < inv.getSlots(); ++i) {
            float containedAmount;
            EntityType<? extends Mob> containedType;
            ItemStack stack = inv.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof IPhylacteryItem) || (containedType = ((IPhylacteryItem)stack.m_41720_()).getContainedEntity(stack)) != type || !((containedAmount = ((IPhylacteryItem)stack.m_41720_()).getFillPct(stack)) < (float)((IPhylacteryItem)stack.m_41720_()).getMaximumFill())) continue;
            matching_slot = i;
        }
        if (matching_slot > -1 && (matching = inv.getStackInSlot(matching_slot)).m_41720_() instanceof IPhylacteryItem) {
            float existing = ((IPhylacteryItem)matching.m_41720_()).getContainedSouls(matching);
            existing = MathUtils.clamp(existing + amount, 0.0f, (float)((IPhylacteryItem)matching.m_41720_()).getMaximumFill());
            ((IPhylacteryItem)matching.m_41720_()).setContainedSouls(matching, existing);
            inv.writeItemStack();
            return true;
        }
        return false;
    }

    @Override
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        ItemInventoryBase inv = new ItemInventoryBase(stack);
        int index = ((PhylacteryStaff)ItemInit.STAFF_PHYLACTERY.get()).getIndex(stack);
        ItemStack invStack = inv.getStackInSlot(index);
        if (invStack.m_41720_() instanceof IPhylacteryItem) {
            ((CrystalPhylactery)ItemInit.CRYSTAL_PHYLACTERY.get()).m_7373_(invStack, worldIn, tooltip, flagIn);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        IRadialInventorySelect.super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int capacity() {
        return 12;
    }

    @Override
    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack book = player.m_21120_(hand);
        player.m_6674_(hand);
        if (!world.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            this.openGuiIfModifierPressed(book, player, world);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }
}

