/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery.bound;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.entities.EntityInit;
import com.mna.entities.sorcery.targeting.BoundBowProjectile;
import com.mna.interop.CuriosInterop;
import com.mna.items.ItemInit;
import com.mna.items.base.INoCreativeTab;
import com.mna.items.renderers.bound.BoundBowItemRenderer;
import com.mna.items.sorcery.bound.IBoundItem;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import org.apache.commons.lang3.mutable.MutableObject;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.network.GeckoLibNetwork;
import software.bernie.geckolib.util.GeckoLibUtil;
import top.theillusivec4.curios.api.SlotTypePreset;

public class BoundBow
extends BowItem
implements IBoundItem,
INoCreativeTab {
    private static final RawAnimation DRAW = RawAnimation.begin().thenPlay("animation.bound_bow.draw").thenLoop("animation.bound_bow.draw_idle");
    private static final RawAnimation FIRE = RawAnimation.begin().thenPlay("animation.bound_bow.fire").thenLoop("animation.bound_bow.idle");
    private static final String controller_id = "bound_bow_fire";
    AnimatableInstanceCache animCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BoundBow() {
        super(new Item.Properties());
        GeckoLibNetwork.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private final NonNullLazy<BlockEntityWithoutLevelRenderer> ister = NonNullLazy.of(() -> new BoundBowItemRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.ister.get();
            }
        });
    }

    public int getDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public float getPassiveManaDrain(Entity entity) {
        if (entity instanceof Player) {
            Player p = (Player)entity;
            if (CuriosInterop.IsItemInCurioSlot((Item)ItemInit.BATTLEMAGE_AMULET.get(), (LivingEntity)p, SlotTypePreset.NECKLACE)) {
                return 0.0f;
            }
        }
        return 0.2f;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.handleInventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        SpellRecipe recipe = this.getRecipe(stack);
        recipe.addItemTooltip(stack, worldIn, tooltip, (Player)mc.f_91074_);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ItemStack createFromSpell(LivingEntity caster, ItemStack original, ISpellDefinition recipe) {
        return IBoundItem.super.createFromSpell(caster, (Item)this, original, recipe);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        ItemStack restored = this.restoreItem(item);
        player.m_150109_().m_6836_(player.m_150109_().f_35977_, restored);
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public int manaPerShot(Player player, InteractionHand hand, ItemStack stack) {
        SpellRecipe recipe = this.getRecipe(stack);
        SpellCaster.applyAdjusters(stack, (LivingEntity)player, hand, false, recipe, SpellCastStage.CALCULATING_MANA_COST);
        return (int)recipe.getManaCost();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        MutableObject returnValue = new MutableObject((Object)InteractionResultHolder.m_19100_((Object)itemstack));
        SpellRecipe recipe = SpellRecipe.fromNBT(itemstack.m_41783_());
        if (!this.canCastSpell(recipe, (LivingEntity)playerIn, handIn)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        playerIn.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
            if (playerIn.m_150110_().f_35937_ || m.getCastingResource().hasEnough((LivingEntity)playerIn, this.manaPerShot(playerIn, handIn, itemstack))) {
                playerIn.m_6672_(handIn);
                if (worldIn instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)worldIn;
                    this.triggerAnim((Entity)playerIn, GeoItem.getOrAssignId((ItemStack)itemstack, (ServerLevel)serverLevel), controller_id, "draw");
                }
                returnValue.setValue((Object)InteractionResultHolder.m_19096_((Object)itemstack));
            }
        });
        return (InteractionResultHolder)returnValue.getValue();
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            int i;
            Player playerentity = (Player)entityLiving;
            if (worldIn instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)worldIn;
                this.triggerAnim((Entity)playerentity, GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)serverLevel), controller_id, "fire");
            }
            if ((i = this.m_8105_(stack) - timeLeft) < 0) {
                return;
            }
            float f = BoundBow.getArrowVelocity(i);
            if (!((double)f < 0.1)) {
                playerentity.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                    int mana = this.manaPerShot(playerentity, InteractionHand.MAIN_HAND, stack);
                    if (m.getCastingResource().hasEnough(entityLiving, mana)) {
                        SpellRecipe recipe = this.getRecipe(stack);
                        if (!worldIn.f_46443_) {
                            BoundBowProjectile shot = new BoundBowProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityInit.BOUND_BOW_PROJECTILE.get()), worldIn);
                            shot.m_6034_(playerentity.m_20185_(), playerentity.m_20186_() + (double)playerentity.m_20192_(), playerentity.m_20189_());
                            shot.m_5602_((Entity)playerentity);
                            shot.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_(), 0.0f, f * 3.0f, 1.0f);
                            shot.setSpell(recipe);
                            worldIn.m_7967_((Entity)shot);
                        }
                        m.getCastingResource().consume((LivingEntity)playerentity, mana);
                        IPlayerProgression progression = (IPlayerProgression)playerentity.getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null);
                        if (progression != null && !recipe.canFactionCraft(progression)) {
                            this.getRecipe(stack).usedByPlayer(playerentity);
                        }
                        worldIn.m_6263_((Player)null, playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (worldIn.f_46441_.m_188501_() * 0.4f + 1.2f) + f * 0.5f);
                        playerentity.m_36335_().m_41524_((Item)this, (int)((float)recipe.getCooldown((LivingEntity)playerentity) * 0.75f));
                    }
                });
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, controller_id, 0, state -> PlayState.STOP).triggerableAnim("draw", DRAW).triggerableAnim("fire", FIRE)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animCache;
    }
}

