/*
 * Decompiled with CFR 0.152.
 */
package com.mna.items.sorcery.bound;

import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.events.BoundItemDismissedEvent;
import com.mna.api.events.BoundItemSummonedEvent;
import com.mna.api.items.IShowHud;
import com.mna.api.spells.ComponentApplicationResult;
import com.mna.api.spells.adjusters.SpellCastStage;
import com.mna.api.spells.attributes.Attribute;
import com.mna.api.spells.base.IModifiedSpellPart;
import com.mna.api.spells.base.ISpellDefinition;
import com.mna.api.spells.parts.SpellEffect;
import com.mna.api.spells.targeting.SpellContext;
import com.mna.api.spells.targeting.SpellSource;
import com.mna.api.spells.targeting.SpellTarget;
import com.mna.api.timing.DelayedEventQueue;
import com.mna.api.timing.TimedDelayedSpellEffect;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.interop.CuriosInterop;
import com.mna.items.relic.BoundCharm;
import com.mna.spells.SpellCaster;
import com.mna.spells.crafting.SpellRecipe;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.mutable.MutableBoolean;
import software.bernie.geckolib.animatable.GeoItem;

public interface IBoundItem
extends GeoItem,
IShowHud {
    public static final UUID BASE_RANGE_UUID = UUID.fromString("84468043-330D-428A-A8A3-688DB03E029F");

    public float getPassiveManaDrain(Entity var1);

    default public ItemStack createFromSpell(LivingEntity caster, Item outputItem, ItemStack originalItem, ISpellDefinition spell) {
        CompoundTag nbt = new CompoundTag();
        originalItem.m_41739_(nbt);
        ItemStack bound = new ItemStack((ItemLike)outputItem);
        bound.m_41784_().m_128365_("original_item", (Tag)nbt);
        bound.m_41714_(originalItem.m_41786_());
        spell.writeToNBT(bound.m_41784_());
        CuriosInterop.GetSingleItem(caster, BoundCharm.class).ifPresent(slotResult -> {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)slotResult.stack());
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)bound);
        });
        MinecraftForge.EVENT_BUS.post((Event)new BoundItemSummonedEvent(bound));
        return bound;
    }

    default public ItemStack restoreItem(ItemStack stack) {
        ItemStack restored = ItemStack.m_41712_((CompoundTag)stack.m_41698_("original_item"));
        MinecraftForge.EVENT_BUS.post((Event)new BoundItemDismissedEvent(stack, restored));
        return restored;
    }

    default public SpellRecipe getRecipe(ItemStack stack) {
        return SpellRecipe.fromNBT(stack.m_41784_());
    }

    default public void handleInventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof Player) {
            Player player = (Player)entityIn;
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(m -> {
                if (!m.getCastingResource().hasEnoughAbsolute((LivingEntity)player, this.getPassiveManaDrain(entityIn))) {
                    int restoreSlot = itemSlot;
                    if (restoreSlot == 0 && ((ItemStack)player.m_150109_().f_35976_.get(0)).hashCode() == stack.hashCode()) {
                        restoreSlot = 40;
                    }
                    player.m_150109_().m_6836_(restoreSlot, this.restoreItem(stack));
                } else {
                    m.getCastingResource().consume((LivingEntity)player, this.getPassiveManaDrain(entityIn));
                }
            });
        }
    }

    default public boolean canCastSpell(ISpellDefinition recipe, LivingEntity attacker, InteractionHand hand) {
        if (!(attacker instanceof Player)) {
            return false;
        }
        Player caster = (Player)attacker;
        MutableBoolean canCast = new MutableBoolean(true);
        caster.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (!caster.m_7500_()) {
                if (recipe.getComplexity() > (float)p.getTierMaxComplexity() || recipe.getShape().getPart().getTier(attacker.m_9236_()) > p.getTier()) {
                    canCast.setFalse();
                }
                recipe.iterateComponents(c -> {
                    if (((SpellEffect)c.getPart()).getTier(attacker.m_9236_()) > p.getTier()) {
                        canCast.setFalse();
                    }
                });
            }
        });
        return canCast.booleanValue();
    }

    default public boolean affectTarget(ISpellDefinition recipe, LivingEntity attacker, LivingEntity target, InteractionHand hand) {
        MutableBoolean applied = new MutableBoolean(false);
        if (!attacker.m_9236_().m_5776_() && recipe.isValid()) {
            IPlayerProgression progression;
            if (!this.canCastSpell(recipe, attacker, hand)) {
                return false;
            }
            SpellContext context = new SpellContext(attacker.m_9236_(), recipe);
            SpellSource source = new SpellSource(attacker, hand);
            SpellCaster.applyAdjusters(attacker.m_21120_(hand), attacker, hand, false, recipe, SpellCastStage.CASTING);
            ArrayList<SpellEffect> appliedEffects = new ArrayList<SpellEffect>();
            recipe.iterateComponents(c -> {
                int delay = (int)(c.getValue(Attribute.DELAY) * 20.0f);
                boolean appliedComponent = false;
                if (delay > 0) {
                    DelayedEventQueue.pushEvent(attacker.m_9236_(), new TimedDelayedSpellEffect(((SpellEffect)c.getPart()).getRegistryName().toString(), delay, source, new SpellTarget((Entity)target), (IModifiedSpellPart<SpellEffect>)c, context));
                    applied.setTrue();
                    appliedComponent = true;
                } else if (((SpellEffect)c.getPart()).ApplyEffect(source, new SpellTarget((Entity)target), (IModifiedSpellPart<SpellEffect>)c, context) == ComponentApplicationResult.SUCCESS) {
                    applied.setTrue();
                    appliedEffects.add((SpellEffect)c.getPart());
                    appliedComponent = true;
                }
                if (appliedComponent && attacker instanceof Player) {
                    SpellCaster.addComponentRoteProgress((Player)attacker, (SpellEffect)c.getPart());
                }
            });
            if (applied.isTrue() && !attacker.m_9236_().m_5776_()) {
                SpellCaster.spawnClientFX(attacker.m_9236_(), attacker.m_20182_(), Vec3.f_82478_, source, appliedEffects);
            }
            if (attacker instanceof Player && applied.isTrue() && (progression = (IPlayerProgression)((Player)attacker).getCapability(PlayerProgressionProvider.PROGRESSION).orElse(null)) != null && !recipe.canFactionCraft(progression) && recipe instanceof SpellRecipe) {
                ((SpellRecipe)recipe).usedByPlayer((Player)attacker);
            }
        }
        return applied.booleanValue();
    }
}

