/*
 * Decompiled with CFR 0.152.
 */
package com.mna.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mna.Registries;
import com.mna.api.spells.SpellCraftingContext;
import com.mna.api.spells.base.ISpellComponent;
import com.mna.items.ItemInit;
import com.mna.items.sorcery.ItemTornJournalPage;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class RandomSilverSpell
extends LootItemConditionalFunction {
    ResourceLocation factionID;

    protected RandomSilverSpell(LootItemCondition[] conditionsIn, ResourceLocation factionID, boolean thesis) {
        super(conditionsIn);
        this.factionID = factionID;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        ArrayList candidates = new ArrayList();
        SpellCraftingContext scc = new SpellCraftingContext(null);
        Registries.Shape.get().forEach(s -> {
            if (!s.isCraftable(scc)) {
                return;
            }
            if (s.isSilverSpell() && (this.factionID == null || s.getFactionRequirement() == null || s.getFactionRequirement().is(this.factionID))) {
                candidates.add(s);
            }
        });
        Registries.SpellEffect.get().forEach(s -> {
            if (!s.isCraftable(scc)) {
                return;
            }
            if (s.isSilverSpell() && (this.factionID == null || s.getFactionRequirement() == null || s.getFactionRequirement().is(this.factionID))) {
                candidates.add(s);
            }
        });
        Registries.Modifier.get().forEach(s -> {
            if (!s.isCraftable(scc)) {
                return;
            }
            if (s.isSilverSpell() && (this.factionID == null || s.getFactionRequirement() == null || s.getFactionRequirement().is(this.factionID))) {
                candidates.add(s);
            }
        });
        if (candidates.size() == 0) {
            return stack;
        }
        ISpellComponent selected = (ISpellComponent)candidates.get((int)(Math.random() * (double)candidates.size()));
        ((ItemTornJournalPage)ItemInit.SPELL_PART_THESIS.get()).setComponent(stack, selected);
        return stack;
    }

    public LootItemFunctionType m_7162_() {
        return LootItemFunctions.f_80748_;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomSilverSpell> {
        public RandomSilverSpell deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            ResourceLocation factionID = null;
            boolean thesis = true;
            if (object.has("faction")) {
                factionID = new ResourceLocation(object.get("faction").getAsString());
            }
            if (object.has("thesis")) {
                thesis = object.get("thesis").getAsBoolean();
            }
            return new RandomSilverSpell(conditionsIn, factionID, thesis);
        }
    }
}

