/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.api.particles.MAParticleType;
import com.mna.api.particles.ParticleInit;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CloudstepJumpMessage
extends BaseClientMessage {
    private int entityID;

    public CloudstepJumpMessage(int entityID) {
        this.entityID = entityID;
        this.messageIsValid = true;
    }

    public CloudstepJumpMessage() {
        this.messageIsValid = false;
    }

    public int getEntityID() {
        return this.entityID;
    }

    public static CloudstepJumpMessage decode(FriendlyByteBuf buf) {
        CloudstepJumpMessage msg = new CloudstepJumpMessage();
        try {
            msg.entityID = buf.readInt();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading CloudstepJumpMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(CloudstepJumpMessage msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getEntityID());
    }

    @Override
    public void Handle(Level world, Player player) {
        Entity e = world.m_6815_(this.getEntityID());
        if (e != null && e instanceof LivingEntity) {
            for (int i = 0; i < 20; ++i) {
                Vec3 pos = e.m_20182_();
                e.m_9236_().m_7106_((ParticleOptions)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.AIR_ORBIT.get())).setScale(0.2f).setColor(10, 10, 10), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.25, (double)0.05f, 0.5);
            }
        }
    }
}

