/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.network.ExtendedItemStackPacketBuffer;
import com.mna.network.messages.BaseClientMessage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ExtendedSlotContainerContentsMessage
extends BaseClientMessage {
    private int containerId;
    private int stateId;
    private List<ItemStack> items;
    private ItemStack carriedItem;

    public ExtendedSlotContainerContentsMessage(int containerId, int stateId, NonNullList<ItemStack> items, ItemStack carriedItem) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.carriedItem = carriedItem.m_41777_();
        this.items = NonNullList.m_122780_((int)items.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, ((ItemStack)items.get(i)).m_41777_());
        }
        this.messageIsValid = true;
    }

    public ExtendedSlotContainerContentsMessage() {
        this.messageIsValid = false;
    }

    public int getContainerID() {
        return this.containerId;
    }

    public int getStateID() {
        return this.stateId;
    }

    public ItemStack getCarried() {
        return this.carriedItem;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public static ExtendedSlotContainerContentsMessage decode(FriendlyByteBuf buf) {
        ExtendedSlotContainerContentsMessage msg = new ExtendedSlotContainerContentsMessage();
        ExtendedItemStackPacketBuffer bufferWrapper = new ExtendedItemStackPacketBuffer((ByteBuf)buf);
        try {
            msg.containerId = bufferWrapper.readUnsignedByte();
            msg.stateId = bufferWrapper.m_130242_();
            msg.items = (List)bufferWrapper.readExtendedCollection(NonNullList::m_182647_, ExtendedItemStackPacketBuffer::readExtendedItemStack);
            msg.carriedItem = bufferWrapper.readExtendedItemStack();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ExtendedSlotContentsMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ExtendedSlotContainerContentsMessage msg, FriendlyByteBuf buf) {
        ExtendedItemStackPacketBuffer bufferWrapper = new ExtendedItemStackPacketBuffer((ByteBuf)buf);
        bufferWrapper.writeByte(msg.containerId);
        bufferWrapper.m_130130_(msg.stateId);
        bufferWrapper.writeExtendedCollection(msg.items, ExtendedItemStackPacketBuffer::writeExtendedItemStack);
        bufferWrapper.writeExtendedItemStack(msg.carriedItem);
    }

    @Override
    public void Handle(Level world, Player player) {
        if (this.getContainerID() == 0) {
            player.f_36095_.m_182410_(this.getStateID(), this.getItems(), this.getCarried());
        } else if (this.getContainerID() == player.f_36096_.f_38840_) {
            player.f_36096_.m_182410_(this.getStateID(), this.getItems(), this.getCarried());
        }
    }
}

