/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.Registries;
import com.mna.api.capabilities.IPlayerProgression;
import com.mna.api.faction.IFaction;
import com.mna.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.mna.network.messages.BaseClientMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ProgressionSyncMessageToClient
extends BaseClientMessage {
    private int _tier;
    private IFaction _faction;
    private int _factionStanding;
    private List<ResourceLocation> completedProgressionSteps;
    private CompoundTag codex_unlocks;

    private ProgressionSyncMessageToClient() {
        this.completedProgressionSteps = new ArrayList<ResourceLocation>();
        this.messageIsValid = false;
    }

    public ProgressionSyncMessageToClient(int tier, IFaction faction, int factionStanding, List<ResourceLocation> progressionCompletion, @Nullable CompoundTag codex_unlocks) {
        this.completedProgressionSteps = progressionCompletion;
        this._tier = tier;
        this._faction = faction;
        this._factionStanding = factionStanding;
        this.codex_unlocks = codex_unlocks;
        this.messageIsValid = true;
    }

    public int getTier() {
        return this._tier;
    }

    public IFaction getFaction() {
        return this._faction;
    }

    public int getFactionStanding() {
        return this._factionStanding;
    }

    public List<ResourceLocation> getCompletedProgressionSteps() {
        return this.completedProgressionSteps;
    }

    public static ProgressionSyncMessageToClient decode(FriendlyByteBuf buf) {
        ProgressionSyncMessageToClient msg = new ProgressionSyncMessageToClient();
        try {
            msg._tier = buf.readInt();
            msg._factionStanding = buf.readInt();
            if (buf.readBoolean()) {
                msg._faction = (IFaction)Registries.Factions.get().getValue(new ResourceLocation(buf.m_130277_()));
            }
            int count = buf.readInt();
            for (int i = 0; i < count; ++i) {
                msg.completedProgressionSteps.add(buf.m_130281_());
            }
            if (buf.readBoolean()) {
                msg.codex_unlocks = buf.m_130261_();
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(ProgressionSyncMessageToClient msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.getTier());
        buf.writeInt(msg.getFactionStanding());
        buf.writeBoolean(msg.getFaction() != null);
        if (msg.getFaction() != null) {
            buf.m_130070_(Registries.Factions.get().getKey((Object)msg.getFaction()).toString());
        }
        buf.writeInt(msg.getCompletedProgressionSteps().size());
        for (ResourceLocation rLoc : msg.getCompletedProgressionSteps()) {
            buf.m_130085_(rLoc);
        }
        if (msg.codex_unlocks != null) {
            buf.writeBoolean(true);
            buf.m_130079_(msg.codex_unlocks);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static ProgressionSyncMessageToClient fromCapability(IPlayerProgression capability) {
        return new ProgressionSyncMessageToClient(capability.getTier(), capability.getAlliedFaction(), capability.getFactionStanding(), capability.getCompletedProgressionSteps(), capability.saveCodexUnlocks());
    }

    @Override
    public void Handle(Level world, Player player) {
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            if (p.performedInitialSync() && p.getTier() < this.getTier()) {
                ManaAndArtifice.instance.proxy.showCodexEntriesUnlocked();
            }
            p.setTier(this.getTier(), null);
            p.setFactionStanding(this.getFactionStanding());
            p.setAlliedFaction(this.getFaction(), player);
            p.setTierProgression(this.getCompletedProgressionSteps());
            if (this.codex_unlocks != null) {
                p.loadCodexUnlocks(this.codex_unlocks);
                ManaAndArtifice.instance.proxy.recalculateCodexUnlocks();
            }
            p.setHasSynced();
        });
    }
}

