/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.network.messages.BaseClientMessage;
import com.mna.tools.loot.LootDrop;
import com.mna.tools.loot.LootTableCache;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RespondLootTableItems
extends BaseClientMessage {
    ResourceLocation lootTableID;
    List<LootDrop> lootDrops;

    public RespondLootTableItems(ResourceLocation lootTableID, List<LootDrop> drops) {
        this.lootTableID = lootTableID;
        this.lootDrops = drops;
        this.messageIsValid = true;
    }

    public RespondLootTableItems() {
        this.messageIsValid = false;
    }

    public ResourceLocation getLootTableID() {
        return this.lootTableID;
    }

    public List<LootDrop> getLootDrops() {
        return this.lootDrops;
    }

    public static RespondLootTableItems decode(FriendlyByteBuf buf) {
        RespondLootTableItems msg = new RespondLootTableItems();
        try {
            msg.lootTableID = buf.m_130281_();
            int numDrops = buf.readInt();
            msg.lootDrops = new ArrayList<LootDrop>();
            for (int i = 0; i < numDrops; ++i) {
                msg.lootDrops.add(LootDrop.readFrom(buf));
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading RespondLootTableItems: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(RespondLootTableItems msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.getLootTableID());
        buf.writeInt(msg.getLootDrops().size());
        for (int i = 0; i < msg.getLootDrops().size(); ++i) {
            msg.getLootDrops().get(i).writeTo(buf);
        }
    }

    @Override
    public void Handle(Level world, Player player) {
        LootTableCache.cacheLoot(this.getLootTableID(), this.getLootDrops());
    }
}

