/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_client;

import com.mna.ManaAndArtifice;
import com.mna.api.capabilities.IPlayerMagic;
import com.mna.capabilities.playerdata.magic.PlayerMagicProvider;
import com.mna.network.messages.BaseClientMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class SetLiftPositionMessage
extends BaseClientMessage {
    Vec3 position;

    public SetLiftPositionMessage(double x, double y, double z) {
        this.position = new Vec3(x, y, z);
        this.messageIsValid = true;
    }

    public SetLiftPositionMessage() {
        this.messageIsValid = false;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public static SetLiftPositionMessage decode(FriendlyByteBuf buf) {
        SetLiftPositionMessage msg = new SetLiftPositionMessage();
        try {
            msg.position = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading ManaweavePatternDrawnMessage: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static void encode(SetLiftPositionMessage message, FriendlyByteBuf buf) {
        buf.writeDouble(message.getPosition().f_82479_);
        buf.writeDouble(message.getPosition().f_82480_);
        buf.writeDouble(message.getPosition().f_82481_);
    }

    @Override
    public void Handle(Level world, Player player) {
        Player clientPlayer = ManaAndArtifice.instance.proxy.getClientPlayer();
        LazyOptional magicCap = clientPlayer.getCapability(PlayerMagicProvider.MAGIC);
        if (!magicCap.isPresent()) {
            return;
        }
        IPlayerMagic magicProperties = (IPlayerMagic)magicCap.orElse(null);
        if (magicProperties == null) {
            return;
        }
        magicProperties.setLiftPosition(this.getPosition());
    }
}

