/*
 * Decompiled with CFR 0.152.
 */
package com.mna.network.messages.to_server;

import com.mna.ManaAndArtifice;
import com.mna.api.spells.attributes.Attribute;
import com.mna.blocks.tileentities.wizard_lab.InscriptionTableTile;
import com.mna.network.messages.TileEntityServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class InscriptionTableAttributeChangeMessage
extends TileEntityServerMessage {
    private Attribute attr;
    private float value;
    private ChangeType type;

    public InscriptionTableAttributeChangeMessage() {
        super(null);
        this.messageIsValid = false;
    }

    public InscriptionTableAttributeChangeMessage(BlockPos position, Attribute attr, float value, ChangeType type) {
        super(position);
        this.attr = attr;
        this.value = value;
        this.type = type;
        this.messageIsValid = true;
    }

    public final Attribute getAttribute() {
        return this.attr;
    }

    public final float getValue() {
        return this.value;
    }

    public final ChangeType getChangeType() {
        return this.type;
    }

    public static final InscriptionTableAttributeChangeMessage decode(FriendlyByteBuf buf) {
        InscriptionTableAttributeChangeMessage msg = new InscriptionTableAttributeChangeMessage();
        try {
            msg.attr = Attribute.valueOf(buf.m_130136_(Short.MAX_VALUE));
            msg.value = buf.readFloat();
            msg.type = ChangeType.valueOf(buf.m_130136_(512));
            msg.pos = buf.m_130135_();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            ManaAndArtifice.LOGGER.error("Exception while reading MagicSyncMessageToClient: " + e);
            return msg;
        }
        msg.messageIsValid = true;
        return msg;
    }

    public static final void encode(InscriptionTableAttributeChangeMessage msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.attr.name());
        buf.writeFloat(msg.value);
        buf.m_130070_(msg.type.name());
        buf.m_130064_(msg.pos);
    }

    @Override
    public void Handle(ServerLevel world, ServerPlayer player) {
        InscriptionTableTile.handleAttributeValueChange(player, this);
    }

    public static enum ChangeType {
        SHAPE,
        COMPONENT;

    }
}

